//
//  HWMBizNotificationHandler.h
//  HWMUISDK
//
//  Created by y00450113 on 2020/8/3.
//  Copyright © 2020 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMBaseConfDetailParam.h"
#import "HWMSDKShareVmrInfoModel.h"
#import "HWMUISDKOperateExternalInviteeInfoModel.h"
#import "HWMSDKAddAttendeeResultListModel.h"
#import "HWMAttendeeInfo.h"
#import "HWMCorpConfigInfo.h"
#import "HWMSDKSubtitleRecordInfoModel.h"
#import "HWMSDKRealTimeSubtitleModel.h"

NS_ASSUME_NONNULL_BEGIN

@protocol HWMBizNotificationHandler <NSObject>

@optional
/// 个人角色是否是主持人变化通知
/// @param isChairMan 是否是主持人
- (void)onSelfIsChairManChanged:(BOOL)isChairMan;

/// 会议列表变化通知
/// @param confList 会议列表
- (void)onReceiveConfList:(NSArray<HWMBaseConfDetailParam *> *)confList;

/// 录播权限更新通知
/// @param isHasPermission 是否允许
- (void)onRecordPermissionNotify:(BOOL)isHasPermission;

/// 预约会议发送短信权限更新通知
/// @param isHasPermission 是否允许
- (void)onBookConfSmsPermissionNotify:(BOOL)isHasPermission;

/// 屏幕共享通知
/// @param isShare YES:开始共享, NO:停止共享
- (void)onSelfShareStateChanged:(BOOL)isShare;

/// 共享云会议室
- (void)onShareVmrInfoNotify:(HWMSDKShareVmrInfoModel *)shareVmrInfo;

/// 邀请或挂断外部受邀者
- (void)onOperateExternalAttendeeNotify:(HWMUISDKOperateExternalInviteeInfoModel *)externalInviteeInfo;

/// 添加与会者结果通知
/// - Parameter resultList: 添加与会者结果列表
- (void)onAddAttendeeNotify:(HWMSDKAddAttendeeResultListModel *)resultList;

/// 批量呼叫外部与会者
/// - Parameter externalAttendees: 外部与会者列表
- (void)onCallAllExternalAttendeesNotify:(NSArray<HWMUISDKExternalInviteeModel *> *)externalAttendees;

/// 等候室列表更新通知
/// - Parameter waitingInfoList: 等候室列表
- (void)onWaitingListChanged:(NSArray<HWMAttendeeInfo *> *)waitingInfoList;

/// 个人角色变化通知
/// - Parameter confRole: 角色
- (void)onSelfRoleChanged:(HWMConfRole)confRole;

/// 与会者列表更新通知
/// - Parameter attendeeList: 与会者列表
- (void)onAttendeeListChanged:(NSArray<HWMAttendeeInfo *> *)attendeeList;

/// 企业配置信息通知
/// - Parameter corpConfig: 企业配置
- (void)onCorpConfigNotify:(HWMCorpConfigInfo *)corpConfig;

/// 等候室状态更新通知
/// - Parameter isOpen: 是否开启
- (void)onWaitingRoomStateChanged:(BOOL)isOpen;

/// 字幕状态更新通知
/// - Parameter isOpen: 是否开启
- (void)onSubtitleStateChanged:(BOOL)isOpen;

/// 字幕消息实时通知
/// - Parameter realTimeSubtitle: 实时字幕信息
- (void)onRealTimeSubtitleInfoNotify:(HWMSDKRealTimeSubtitleModel *)realTimeSubtitle;

/// 字幕记录消息通知
/// - Parameter subtitleInfo: 字幕记录信息
- (void)onSubtitleRecordNotify:(HWMSDKSubtitleRecordInfoModel *)subtitleInfo;

/// 登录状态变更通知
/// - Parameter state: 登录状态
- (void)onLoginStateChangeNotify:(HWMLoginState)state;

@end

NS_ASSUME_NONNULL_END
