//
//  HWMCommonCellTextStyle.h
//  HWMCommonUI
//
//  Created by lWX914447 on 2020/7/6.
//  Copyright © 2020 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/// Cell 文本样式
@interface HWMCommonCellTextStyle : NSObject

/// 颜色
@property (nonatomic, strong) UIColor *textColor;
/// 禁用状态颜色
@property (nonatomic, strong) UIColor *disableColor;
/// 字体
@property (nonatomic, strong) UIFont *font;

/// Cell 标题样式
+ (instancetype)titleStyle;

/// Cell content样式
+ (instancetype)contentStyle;

/// Cell 底部文本样式
+ (instancetype)bottomTextStyle;

/// 初始化 Cell 文本样式
/// @param textColor 颜色
/// @param font 字体
+ (instancetype)textStyleWithColor:(UIColor *)textColor font:(UIFont *)font;
- (instancetype)initWithColor:(UIColor *)textColor font:(UIFont *)font;

@end

NS_ASSUME_NONNULL_END
