//
//  HWMConfPopMenuItem.h
//  HWMConfUI
//
//  Created by lining on 2024/8/30.
//  Copyright © 2024 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, HWMConfPopMenuType) {
    HWMConfPopMenuTypeShareToGuest,   // 分享给嘉宾
    HWMConfPopMenuTypeShareToAudience // 分享给观众
};

NS_ASSUME_NONNULL_BEGIN

@interface HWMConfPopMenuItem : NSObject

/// 菜单类型
@property (nonatomic, assign) HWMConfPopMenuType type;
/// 标题
@property (nonatomic, copy) NSString *title;
/// 点击事件
@property (nonatomic, copy) void(^clickEvent)(void);

/// 初始化菜单项
/// - Parameters:
///   - type: 菜单类型
///   - title: 标题
///   - clickEvent: 点击事件
- (instancetype)initWithType:(HWMConfPopMenuType)type title:(NSString *)title clickEvent:(void(^ _Nullable)(void))clickEvent;

/// 分享给嘉宾
+ (instancetype)defaultShareToGuestItem;

/// 分享给观众
+ (instancetype)defaultShareToAudienceItem;

@end

NS_ASSUME_NONNULL_END
