//
//  HWMCustomImageHandler.h
//  HWMConfUI
//
//  Created by lining on 2024/10/23.
//  Copyright © 2024 huawei. All rights reserved.
//

#import <UIKit/UIKit.h>

/// 自定义图片场景
typedef NS_ENUM(NSUInteger, HWMCustomImageScene) {
    HWMCustomImageSceneCloudRecordIcon = 0,       // 会中云录制主图标（云录制菜单弹窗、与会者列表）
    HWMCustomImageSceneMainWindowCloudRecordIcon, // 主窗口云录制Icon小图标
    HWMCustomImageSceneMainWindowCloudRecordLogo, // 主窗口云录制Logo大图标
    HWMCustomImageSceneButt,                      // 场景枚举的最后一项，新增的场景，需要插在本项之前，并将本项依次下移
};

NS_ASSUME_NONNULL_BEGIN

/// 图片信息
@interface HWMCustomImageInfo : NSObject

/// 图片
@property (nonatomic, strong) UIImage *image;
/// 图片显示宽度
@property (nonatomic, assign) CGFloat width;
/// 图片显示高度
@property (nonatomic, assign) CGFloat height;

- (instancetype)initWithImage:(UIImage *)image width:(CGFloat)width height:(CGFloat)height;

@end

@protocol HWMCustomImageHandler <NSObject>

@optional

/// 自定义图片
/// - Parameter scene: 场景
- (HWMCustomImageInfo *)customImageForScene:(HWMCustomImageScene)scene;

@end

NS_ASSUME_NONNULL_END
