//
//  HWMStartP2PConfParam.h
//  HWMUISDK
//
//  Created by yaolili/ywx577644 on 2023/6/2.
//  Copyright © 2023 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMCallerInfo.h"
#import "HWMCalleeInfo.h"
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMStartP2PConfParam : NSObject

/// 被叫信息
@property(nonatomic, strong) HWMCalleeInfo *calleeInfo;

/// 主叫信息
@property(nonatomic, strong) HWMCallerInfo *callerInfo;

/// 媒体类型
@property (nonatomic, assign) HWMMediaType mediaType;

/// 是否来宾免密码入会
@property (nonatomic, assign) BOOL isGuestJoinConfWithoutPwd;

/// 允许入会的用户类型
@property (nonatomic, assign)  HWMJoinConfRestrictionType confAllowJoinUser;

/// 是否关闭扬声器，默认不关闭
@property (nonatomic, assign) BOOL isSpeakerOff;

/// 可选，端侧自定义数据，服务器不感知业务
@property (nonatomic, copy, nullable) NSString *customInfo;
@end

NS_ASSUME_NONNULL_END
