//
//  HWMUISDKCommonDefine.h
//  Pods
//
//  Created by Shepherd on 2024/3/19.
//

#ifndef HWMUISDKCommonDefine_h
#define HWMUISDKCommonDefine_h

typedef NS_ENUM(NSInteger, HWMUISDKPrivateAttendeeType) {
    HWMUISDKPrivateAttendeeTypeNormal = 0,        /**<[en]Indicates conference soft terminal user [cn]会议软终端用户 */
    HWMUISDKPrivateAttendeeTypeCustomnumber = 1,        /**<[en]Indicates custom number [cn]自定义号码 */
    HWMUISDKPrivateAttendeeTypeMobile = 2,        /**<[en]Indicates user mobile phone number [cn]用户手机号码 */
    HWMUISDKPrivateAttendeeTypeTelephone = 3,        /**<[en]Indicates user telephone [cn]用户固定电话 */
};

typedef NS_ENUM(NSInteger, HWMUISDKInviteeState) {
    HWMUISDKExternalAttendeeStateWaiting = 0,        /**<[en]Indicates exteranal attendee state waiting [cn]外部用户呼叫中 */
    HWMUISDKExternalAttendeeStateTimeout = 1,        /**<[en]Indicates exteranal attendee state timeout [cn]外部用户呼叫超时 */
    HWMUISDKExternalAttendeeStateBusy = 2,        /**<[en]Indicates exteranal attendee state busy [cn]外部用户呼叫忙 */
    HWMUISDKExternalAttendeeStateDenied = 3,        /**<[en]Indicates exteranal attendee state denied [cn]外部用户呼叫拒接 */
    HWMUISDKExternalAttendeeStateConnecting = 4,        /**<[en]Indicates exteranal attendee state connecting [cn]外部用户入会中 */
    HWMUISDKExternalAttendeeStateSuccess = 5,        /**<[en]Indicates exteranal attendee state success [cn]外部用户入会成功 */
    HWMUISDKExternalAttendeeStateFailed = 6,        /**<[en]Indicates exteranal attendee state failed [cn]外部用户入会失败 */
    HWMUISDKExternalAttendeeStateRemoved = 7,        /**<[en]Indicates exteranal attendee state removed [cn]外部用户移除 */
    HWMUISDKExternalAttendeeStateHangup = 8,        /**<[en]Indicates exteranal attendee state hangup [cn]外部用户被挂断 */
};

typedef NS_ENUM(NSInteger, HWMUISDKOperateExternalInviteeType) {
    HWMUISDKOperateExternalInviteeCall = 0,        /**<[en]Indicates call external invitee [cn]呼叫外部邀请者 */
    HWMUISDKOperateExternalInviteeHangup = 1,        /**<[en]Indicates hangup external hang up [cn]挂断外部邀请者 */
    HWMUISDKOperateExternalInviteeRemove = 2,        /**<[en]Indicates hangup external remove [cn]移除外部邀请者 */
    HWMUISDKOperateExternalInviteeOtherNumber = 3,        /**<[en]Indicates hangup external [cn]呼叫其他号码 */
};


#endif /* HWMUISDKCommonDefine_h */
