﻿/**
 * @file HwmSdkDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief Xxxxxx.
 */


#ifndef __HWM_SDK_PRIVATE_DEF_H__
#define __HWM_SDK_PRIVATE_DEF_H__

#import "HwmSdkCommonDef.h"
#import "HwmLoginServiceDef.h"
#import "HwmNativeSdkDef.h"


BEGIN_HWM_SDK_NAMESPACE

/**
* [en]This structure is used to describe the application param.
* [cn]应用程序信息参数(私有)
* @private
*/
typedef struct tagAppInfoParamPrivate
{
    AppInfoParam appInfoParam;                              /**< [extends][en]describe the application param.
                                                            [cn]应用程序信息参数 */
    ClientType clientType;                                  /**< [en]Indicates type of client.
                                                            [cn]客户端类型 */
    HWM_BOOL isWelink;                                       /**< [en]is welink terminalType.
                                                            [cn]是否welink */
    HWM_BOOL isSupportMultiAppLogin;                     /**< [en]is support multi app login.
                                                            [cn]是否支持同终端多应用登录 */
    HWM_CHAR terminalType[HWM_MAX_DEVICETYPE_LEN];          /**< [en]Indicates xxx.
                                                            [cn]终端类型 */
    HWM_CHAR appVersion[HWM_MAX_CLIENT_VERSION_LEN];        /**< [en]Indicates app version.
                                                            [cn]应用版本 */
    HWM_CHAR osName[HWM_MAX_OS_NAME_LEN];                   /**< [en]Indicates xxx.
                                                            [cn]操作系统 */                                                     
    HWM_CHAR deviceModel[HWM_MAX_DEVICETYPE_LEN];           /**< [en]Indicates xxx.
                                                            [cn]手机终端类型 */
    DevicePerformanceLevel deviceLevel;                     /**< [en]Indicates device performancelevel.
                                                            [cn]设备性能等级 */
    HWM_CHAR pcBsMoudlePath[HWM_MAX_FILE_PATH_LEN];           /**< [en]Indicates xxx.
                                                            [cn]资源路径-虚拟背景模型文件 */
    HWM_CHAR pcBsMoudleCpuPath[HWM_MAX_FILE_PATH_LEN];        /**< [en]Indicates xxx.
                                                            [cn]资源路径-虚拟背景模型文件(供CPU模式使用) */
    HWM_CHAR pcSegProcPath[HWM_MAX_FILE_PATH_LEN];            /**< [en]Indicates xxx.
                                                            [cn]资源路径-虚拟背景proc.exe文件 */
    HWM_CHAR pcSegCoordPath[HWM_MAX_FILE_PATH_LEN];           /**< [en]Indicates xxx.
                                                            [cn]资源路径-虚拟背景Coord文件 */
    HWM_CHAR virtualBackgroundPluginModelPath[HWM_MAX_FILE_PATH_LEN];    /**< [en]Indicates xxx.
                                                            [cn]资源路径-虚拟背景第三方插件模型 */
    HWM_CHAR frameworksPath[HWM_MAX_FILE_PATH_LEN];         /**< [en]Indicates xxx.
                                                            [cn]资源路径-framework路径 */
    HWM_UINT32 logKeepDays;                                 /**< [en]Indicates the log keeping days.
                                                            [cn] 配置项-日志保存天数，0为使用SDK内部策略，非0情况范围3-30 */
    HWM_CHAR cfgClientType[HWM_MAX_CFG_CLIENT_TYPE_LEN];    /**< [en]Indicates type of client.
                                                            [cn]客户端类型, 上层传入的客户端类型字符串 */
    HWM_CHAR rtcLibPath[HWM_MAX_RTC_LIB_PATH_LEN];          /**< [en]Indicates sparkrtc lib path.
                                                            [cn]资源路径-sparkrtc lib 路径 */
    HWM_CHAR workspacePluginZipPath[HWM_MAX_FILE_PATH_LEN]; /**< [en]Indicates workspacePlugin zip path.
                                                            [cn]资源路径-云桌面插件 压缩包 路径 */
    ServerMultiPicType serverMultipicType;                  /**< [en]Indicates serverMultipic Type.
                                                            [cn]服务端合成画面类型 */
    HWM_BOOL enableRtc;                                     /**< [en]Indicates enable sparkrtc flag.
                                                            [cn]是否支持sparkrtc会议 */
    HWM_UINT64 publishTimestamp;                            /**< [en]Indicates publish timestamp.
                                                            [cn]版本发布的时间戳, utc时间戳, 单位ms */
    HWM_CHAR videoExtraProcessPath[HWM_MAX_FILE_PATH_LEN];  /**< [en]Indicates video extra process path.
                                                            [cn]HME获取硬编能力进程路径 */
    HWM_BOOL enableVerifyTrust;                             /**< [en]Indicates enable verify trust.
                                                            [cn]使能程序信任校验 [cs_allowNull:Y]*/
}AppInfoParamPrivate;

/**
* [en]ideahub code table type.
* [cn]ideahub码表类型
* @private
* @pc:disable
* @ios:disable
* @openHarmony:disable
*/
typedef enum tagAndroidAppIdeaHubCodeTableType {
    CODE_TABLE_TYPE_DEFAULT,
    CODE_TABLE_TYPE_01,         /** 码表: h264
                                        { STATEGY_RESOLUTION_TYPE_HUGE,              5056, 1080,  1920, 20, 30,  0, 0,  1314, 3200,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_LARGE,             1856,  720,  1280, 20, 30,  0, 0,   468, 1638,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_MEDIUM,             960,  360,   640, 19, 30,  0, 0,   334,  730,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_MEDIUM,             704,  270,   480, 19, 20,  0, 0,   195,  390,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_SUB_MEDIUM,         448,  180,   320, 19, 20,  0, 0,   160,  195,  0, 0 }
                                          h265
                                        { STATEGY_RESOLUTION_TYPE_HUGE,              4032, 1080,  1920, 20, 30,   0, 0,  1051, 2000,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_LARGE,             1856,  720,  1280, 20, 30,   0, 0,   450, 1200,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_MEDIUM,             960,  360,   640, 19, 30,   0, 0,   256,  625,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_MEDIUM,             704,  270,   480, 19, 20,   0, 0,   140,  293,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_SUB_MEDIUM,         448,  180,   320, 19, 20,   0, 0,   130,  160,  0, 0 } */
                           
    CODE_TABLE_TYPE_02,         /** 码表: h264
                                        { STATEGY_RESOLUTION_TYPE_HUGE,              5056, 1080, 1920, 20, 30,  0, 0,  1314, 3200,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_MEDIUM,             960, 360, 640, 19, 30,  0, 0,   334,  730,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_SUB_MEDIUM,         448, 180, 320, 19, 20, 0, 0, 160, 195, 0, 0}
                                          h265
                                        { STATEGY_RESOLUTION_TYPE_HUGE,              4032, 1080,  1920, 20, 30,   0, 0,  1051, 2000,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_MEDIUM,             960,  360,   640, 19, 30,   0, 0,   256,  625,  0, 0 },
                                        { STATEGY_RESOLUTION_TYPE_SUB_MEDIUM,         448, 180, 320, 19, 20, 0, 0, 160, 195, 0, 0} */
    CODE_TABLE_TYPE_03,
    CODE_TABLE_TYPE_04,
    CODE_TABLE_TYPE_05,
    CODE_TABLE_TYPE_END
}AndroidAppIdeaHubCodeTableType;

/**
* [en]ideahub hard codec mode.
* [cn]ideahub硬编解码类型
* @private
* @pc:disable
* @ios:disable
* @openHarmony:disable
*/
typedef enum tagHardCodecMode {
    HARD_CODEC_MODE_DEFAULT = 0,            /**强制硬编硬解，默认值*/
    HARD_CODEC_MODE_FORCED_ENCODING = 1,    /**强制硬编，解码不做要求*/                           
    HARD_CODEC_MODE_FORCED_DECODING = 2     /**强制硬解，编码不做要求*/
}HardCodecMode;

/**
* [en]This structure is used to describe the android application ability.
* [cn]android应用程序能力
* @private
* @pc:disable
* @ios:disable
* @openHarmony:disable
*/
typedef struct tagAndroidAppAbilityPrivate
{
    HWM_BOOL supportPairServer;                     /**< [en]if support pair server.
                                                            [cn]是否扫码配对服务（被扫码） */
    HWM_BOOL supportHdSvc;                          /**< [en]if support High Definition svc.
                                                            [cn]是否支持高分辨率多流会议 */
    AndroidAppIdeaHubCodeTableType ideaHubCodeTableType;  /**< [en]ideahub code table type.
                                                               [cn]ideahub 码表类型 */
    HWM_BOOL supportEncodedStream;                  /**< [en]if support encoded stream.
                                                            [cn]是否支持主流透传流 */
    HWM_BOOL enableCamera2;                         /**< [en]if enable camera2.
                                                            [cn]是否使用camera2 */
    HWM_BOOL isHardCodecForced;                     /**< [en]whether forced to use hard codec.
                                                            [cn]是否强制硬编硬解 */
    HardCodecMode hardCodecMode;                    /**< [en]hard codec mode.
                                                            [cn]硬编解码类型 */                                                                                                                          
    HWM_BOOL isH265Disabled;                        /**< [en]is h265 disabled.
                                                            [cn]是否禁用H265 */
    HWM_BOOL isMeetingAudioSharingCaptureDisabled;  /**< [en]is meeting audio sharing capture disabled.
                                                            [cn]屏幕共享时是否可以采集会中音频 */
    HWM_BOOL isCustomCameraSelectionEnabled;        /**< [en]whether custom camera selection enabled.
                                                            [cn]是否启用自定义相机 */
    HWM_INT32 customMainCameraId;                   /**< [en]custom main camera id.
                                                            [cn]自定义主相机id */ 
                                                            
}AndroidAppAbilityPrivate;

/**
* [en]This structure is used to describe the android application param.
* [cn]android应用程序信息参数
* @private
* @pc:disable
* @ios:disable
* @openHarmony:disable
*/
typedef struct tagAndroidAppInfoParamPrivate
{
    AppInfoParamPrivate appInfoPrivate;                     /**< [extends][en]describe the application param.
                                                            [cn]android私有应用程序信息参数 */
    HWM_CHAR channelPartner[HWM_MAX_CHANNEL_PARTNER_LEN];   /**< [en]Indicates channel partner.
                                                            [cn]渠道商 */
    HWM_CHAR srmoudlePath[HWM_MAX_FILE_PATH_LEN];           /**< [en]Indicates xxx.
                                                            [cn]算法路径-虚拟背景 */
    HWM_CHAR bsmoudlePath[HWM_MAX_FILE_PATH_LEN];           /**< [en]Indicates xxx.
                                                            [cn]资源路径-虚拟背景 */
    HWM_BOOL enableExternalCapture;                         /**< [en]Indicates external capture.
                                                            [cn]配置项-外部采集模式 */
    HWM_BOOL enableExternalAudioCapture;                    /**< [en]Indicates external audio capture.
                                                            [cn]配置项-外部音频采集模式 */
    HWM_UINT32 sampleRate;                                    /**< [en]Indicates external audio capture sampleRate.
                                                            [cn]配置项-外部音频采集的采样率 */
    AndroidAppAbilityPrivate androidAbility;                /**< [en]android ability.
                                                            [cn]安卓能力 */
}AndroidAppInfoParamPrivate;


END_HWM_SDK_NAMESPACE

#endif /* __HWM_SDK_DEF_H__ */


