//
//  BaseTableViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/5/29.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "BaseTableViewController.h"

@interface BaseTableViewController ()

@end

@implementation BaseTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
}

- (void)setupTableView {
    self.tableView = [[UITableView alloc] init];
    [self.view addSubview:self.tableView];
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.bottom.mas_equalTo(0);
    }];
    self.tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    [self.tableView registerClass:[TableViewCell class] forCellReuseIdentifier:@"TableViewCell"];
    self.tableView.delegate = self;
    self.tableView.dataSource = self;
    self.tableView.estimatedRowHeight = 54;
    self.tableView.rowHeight = UITableViewAutomaticDimension;
}

-(void)setupViews{
    [super setupViews];
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section{
    return self.dataArray.count;
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    TableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    if (self.dataArray.count == 0) {
        return;
    }
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    if (self.dataArray.count > indexPath.row && [[self.dataArray objectAtIndex:indexPath.row] isKindOfClass:[ActionModel class]]) {
        ActionModel *model = [self.dataArray objectAtIndex:indexPath.row];
        if (model.actionCtrl) {
            [self pushViewControllerWithVcString:model.actionCtrl];
        }else if (model.action){
            NSString *selector = NSStringFromSelector(model.action);
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Warc-performSelector-leaks"
            if ([selector hasSuffix:@":"]) {
                [self performSelector:model.action withObject:[tableView cellForRowAtIndexPath:indexPath]];
            } else {
                [self performSelector:model.action];
            }
#pragma clang diagnostic pop
        }else{
            //DO nothing
        }
    }
}

-(NSArray *)dataArray
{
    if (!_dataArray) {
        _dataArray = [NSArray array];
    }
    return _dataArray;
}


@end
