

//
//  MediaTypeSwitchView.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//


#import "MediaTypeSwitchView.h"

@interface MediaTypeSwitchView()

@property (nonatomic, strong) UIButton *audioBtn;
@property (nonatomic, strong) UIButton *videoBtn;

@property (nonatomic, assign) SelectType type;

@end

@implementation MediaTypeSwitchView

-(instancetype)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        self.audioBtn = [self newSelectBtn];
        [self addSubview:self.audioBtn];
        self.audioBtn.tag = 0;
        [self.audioBtn addTarget:self action:@selector(btnSelect:) forControlEvents:UIControlEventTouchUpInside];
        [self.audioBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(0);
            make.left.mas_equalTo(0);
            make.width.height.mas_equalTo(20);
        }];
        
        UILabel * audioLabel = [self newLabelWithTitle:@"音频"];
        [audioLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.audioBtn.mas_right).mas_offset(10);
            make.centerY.mas_equalTo(self.audioBtn);
        }];
        
        self.videoBtn = [self newSelectBtn];
        [self addSubview:self.videoBtn];
        self.videoBtn.tag = 1;
        [self.videoBtn addTarget:self action:@selector(btnSelect:) forControlEvents:UIControlEventTouchUpInside];
        [self.videoBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(self.audioBtn.mas_bottom).mas_offset(10);
            make.left.mas_equalTo(self.audioBtn);
            make.width.mas_equalTo(self.audioBtn);
            make.height.mas_equalTo(self.audioBtn);
        }];
        
        UILabel * videoLabel = [self newLabelWithTitle:@"视频"];
        [videoLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(audioLabel);
            make.centerY.mas_equalTo(self.videoBtn);
        }];
        [self changeBtnSelectStatus];
        
    }
    return self;
}

- (UIButton *)newSelectBtn {
    UIButton * btn = [UIButton buttonWithType:UIButtonTypeCustom];
    btn.layer.masksToBounds = YES;
    btn.layer.cornerRadius = 10;
    btn.layer.borderWidth = 2;
    return btn;
}

- (UILabel *)newLabelWithTitle:(NSString *)title {
    UILabel * label = [[UILabel alloc] init];
    [self addSubview:label];
    label.text = title;
    label.font = [UIFont systemFontOfSize:16];
    label.textColor = HexColor(0x333333);
    return label;
}

- (void)btnSelect:(UIButton *)sender {
    if (sender.tag == self.type) {
        return;
    }
    self.type = sender.tag;
    [self changeBtnSelectStatus];
    if (self.selectBlcok) {
        self.selectBlcok(self.type);
    }
}

- (void)changeMediaSelectType:(SelectType)type {
    self.type = type;
    [self changeBtnSelectStatus];
}

- (SelectType)currentSelectMediaType{
    return self.type;
}

- (void)changeBtnSelectStatus {
    for (UIView * view in self.subviews) {
        if ([view isKindOfClass:[UIButton class]]) {
            UIButton * btn = (UIButton *)view;
            BOOL isSelect = (self.type == btn.tag);
            [btn setBackgroundColor: isSelect ? HexColor(0xcc3300):HexColor(0xffffff)];
            btn.layer.borderColor = isSelect? HexColor(0xcc3300).CGColor:HexColor(0x666666).CGColor;
        }
        else {
            
        }
    }
}

@end
