//
//  CycleConfViewController.m
//  HWMSDKDemo
//
//  Created by 付细华 on 2021/10/20.
//  Copyright © 2021 HuaWei. All rights reserved.
//

#import "CycleConfViewController.h"
#import "MediaTypeSwitchView.h"
#import "SelectDateView.h"
#import "DateUtil.h"
#import <HWMUISDK/HWMSdk.h>
#import "UIUtil.h"
#import "CommonUtil.h"
const int cycleConfViewMarginLeft = 30;
@interface CycleConfViewController ()

@property (nonatomic, strong) UIScrollView *scrollView;
@property (nonatomic, strong) UITextField *confSubjectTextField;
@property (nonatomic, strong) UITextField *customInfoTextField;
@property (nonatomic, strong) UITextField *startTimeTextField;
@property (nonatomic, strong) HWMUITextField *confDurationTextField;
@property (nonatomic, strong) HWMUITextField *concurrentParticipantsTextField;
@property (nonatomic, strong) UILabel *confIdTypeLabel;
@property (nonatomic, strong) UISwitch *personalIDSwitch;
@property (nonatomic, strong) HWMUITextField *pwdTextField;
@property (nonatomic, strong) UISwitch *generalPwdSwitch;
@property (nonatomic, strong) UISwitch *joinSwitch;
@property (nonatomic, strong) UITextView *memberView;
@property (nonatomic, strong) UILabel *joinConfRestrictionLabel;
@property (nonatomic, strong) UISwitch *recordSwitch;
@property (nonatomic, strong) UISwitch *autoRecordSwitch;
@property (nonatomic, strong) UISwitch *emailSwitch;
@property (nonatomic, strong) UISwitch *smsSwitch;
@property (nonatomic, strong) UISwitch *calendarSwitch;
@property (nonatomic, strong) UISwitch *autoInviteSwitch;
@property (nonatomic, strong) UISwitch *supportWatermarkSwitch;
@property (nonatomic, strong) HWMUITextField *timeZoneTextField;
@property (nonatomic, strong) UISwitch *allowGuestStartConfSwitch;
@property (nonatomic, strong) UITextField *allowGuestStartConfTimeTextField;
@property (nonatomic, strong) UISwitch *vmrIdTypeSwitch;
@property (nonatomic, strong) UIView *vmrIdTypeView;
@property (nonatomic, strong) UIButton *submitBtn;
@property (nonatomic, strong) NSArray <HWMContactSelectedModel *> *selectedMemebrs;
@property (nonatomic, strong) NSArray<HWMAttendeeInfo *> *attendee;
@property (nonatomic, strong) NSArray<HWMVmrInfoModel *> *vmrList;
@property (nonatomic, strong) SelectDateView *selectEndDateView;
@property (nonatomic, strong) MediaTypeSwitchView * selectView;
@property (nonatomic, strong) UILabel *cycleModeLable;
@property (nonatomic, strong) HWMUITextField *intervalTextField;
@property (nonatomic, strong) UITextField *cycleTimeSelectTextField;
@property (nonatomic, strong) HWMUITextField *preRemindeTextField;
@property (nonatomic, strong) UITextField *endDateTextField;
@property (nonatomic ,strong) HWMSDKModifySubCycleConfParamModel *modifySubCycleConfParam;
@property (nonatomic, strong) UISwitch *waitingRoomSwitch;
@property (nonatomic, assign) BOOL isEnableShareVmr;
@property (nonatomic, strong) UILabel *autoMuteLabel;
@property (nonatomic, strong) UILabel *hardTerminalAutoMuteLabel;
@property (nonatomic, strong) UISwitch *attendeesExcludeSelfSwitch;

@end

@implementation CycleConfViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.view.backgroundColor = [UIColor whiteColor];
    self.title = [self viewControllerTitle];
    [self initData];
    [self setupViews];
}

- (void)initData{
    if ([HWMSdk hasInit]) {
        [[HWMBizSdk getBizOpenApi] getVmrInfoList:^(NSError * _Nullable error, HWMVmrInfoListModel * _Nullable result) {
            if (!error) {
                self.vmrList = result.vmrList;
                self.isEnableShareVmr = result.isEnableShareVmr;
                [self updateVmrInfoView];
            } else {
                [UIUtil showMessageWithError:error];
            }
        }];
    }
    
    if (self.confDetail.attendee.count > 0) {
        self.attendee = self.confDetail.attendee.copy;
        NSMutableArray * selectedMemebrs = [NSMutableArray array];
        [self.confDetail.attendee enumerateObjectsUsingBlock:^(HWMAttendeeInfo * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
            HWMContactSelectedModel * model = [[HWMContactSelectedModel alloc] init];
            model.number = obj.number;
            model.name = obj.name;
            model.email = obj.email;
            model.sms = obj.sms;
            model.accountId = obj.accountId;
            model.isHardTerminal = obj.isHardTerminal;
            [selectedMemebrs addObject:model];
        }];
        self.selectedMemebrs = selectedMemebrs;
    }
    
    if (self.operationType == HWMCycleConfOperationTypeEdit){
        [self.cycleConfInfo.cycleParam setCycleType:self.confDetail.cycleParam.cycleType];
        [self.cycleConfInfo.orderConfParam setCallInRestrictionType:(HWMJoinConfRestrictionType)self.confDetail.callInRestriction];
    }else if(self.operationType == HWMCycleConfOperationTypeEditSubConf){
        [self.modifySubCycleConfParam setCallInRestriction:self.subConfInfo.callInRestriction];
    }else{
        [self.cycleConfInfo.cycleParam setCycleType:HWMSDKCycleTypeDay];
        [self.cycleConfInfo.orderConfParam setCallInRestrictionType:HWMJoinConfRestrictionAll];
    }
}

- (void)setupViews{
    self.scrollView = [[UIScrollView alloc] init];
    [self.view addSubview:self.scrollView];
    [self.scrollView addTapAction:@selector(touchesBegan) target:self];
    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.mas_equalTo(0);
        make.width.mas_equalTo(Screen_Width);
    }];
    
    // 会议主题
    self.confSubjectTextField = [self creatLabelAndTextFieldWithTopView:nil describe:@"会议主题" placeholder:@"请输入会议主题"];
    if (self.operationType != HWMCycleConfOperationTypeBook) {
        self.confSubjectTextField.text = self.confDetail.confSubject;
    }
    if (self.operationType == HWMCycleConfOperationTypeEditSubConf) {
        self.confSubjectTextField.enabled = NO;
    }
    
    // 自定义信息
    self.customInfoTextField = [self creatLabelAndTextFieldWithTopView:self.confSubjectTextField describe:@"自定义信息" placeholder:@"请输入自定义信息"];
    self.customInfoTextField.text = self.cycleConfInfo.orderConfParam.customInfo;

    // 开始时间
    self.startTimeTextField = [self creatLabelAndTextFieldWithTopView:self.customInfoTextField describe:@"开始时间" placeholder:@"格式2020-08-16 12:00"];
    if (self.operationType == HWMCycleConfOperationTypeBook) {
        NSTimeInterval timeInterval = [NSDate date].timeIntervalSince1970;
        self.startTimeTextField.text = [DateUtil formatTimeStringWithTimeInterval:timeInterval isHasTimeZoneInterval:NO];
    }else if (self.operationType == HWMCycleConfOperationTypeEditSubConf){
        self.startTimeTextField.text = [DateUtil formatTimeStringWithTimeInterval:self.subConfInfo.startTimeStamp isHasTimeZoneInterval:NO];
    }else{
        self.startTimeTextField.text = [DateUtil formatTimeStringWithTimeInterval:self.confDetail.startTimeStamp isHasTimeZoneInterval:NO];
    }
    
    [self.startTimeTextField addTapAction:@selector(selectStartTime) target:self];
    // 会议时长
    self.confDurationTextField =[self creatLabelAndTextFieldWithTopView:self.startTimeTextField describe:@"会议时长" placeholder:@"请输入会议时长"];
    self.confDurationTextField.keyboardType = UIKeyboardTypeNumberPad;
    NSInteger duration = 0;
    if (self.operationType == HWMCycleConfOperationTypeEdit) {
        duration = (self.confDetail.endTimeStamp - self.confDetail.startTimeStamp) /  60;
    }else if(self.operationType == HWMCycleConfOperationTypeEditSubConf){
        duration = (self.subConfInfo.endTimeStamp - self.subConfInfo.startTimeStamp) /  60;
    }else{
        
    }
    if (duration > 0) {
        self.confDurationTextField.text = [NSString stringWithFormat:@"%zd",duration];
    }
    if (self.operationType != HWMCycleConfOperationTypeEditSubConf) {
        self.concurrentParticipantsTextField =[self creatLabelAndTextFieldWithTopView:self.confDurationTextField describe:@"最大与会人数" placeholder:@"默认0"];
        self.concurrentParticipantsTextField.keyboardType = UIKeyboardTypeNumberPad;
        if (self.confDetail.concurrentParticipants > 0) {
            self.concurrentParticipantsTextField.text = [NSString stringWithFormat:@"%zd",self.confDetail.concurrentParticipants];
        }
        
        // 周期模式
        UILabel *cycleModeLabel = [self newLabelWithTitle:@"周期模式"];
        [self.scrollView addSubview:cycleModeLabel];
        cycleModeLabel.userInteractionEnabled = YES;
        [cycleModeLabel addTapAction:@selector(selectCycleMode:) target:self];
        [cycleModeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(cycleConfViewMarginLeft);
            make.right.mas_equalTo(self.confSubjectTextField);
            make.top.mas_equalTo(self.concurrentParticipantsTextField.mas_bottom).mas_offset(20);
        }];
        
        self.cycleModeLable = [self newLabelWithTitle:@""];
        [self.scrollView addSubview:self.cycleModeLable];
        [self updateCycleTypeLabelText];
        [self.cycleModeLable mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.mas_equalTo(self.confSubjectTextField);
            make.centerY.mas_equalTo(cycleModeLabel);
        }];
        
        // 周期会议间隔
        self.intervalTextField = [self creatTipsLabelAndTextFieldWithTopView:cycleModeLabel
                                           describe:@"周期间隔"
                                        placeholder:@"周期间隔"
                                               tips:@"周期间隔输入范围按天（1~15），按周（1~5）,按月（1~3）"];
        
        self.intervalTextField.keyboardType = UIKeyboardTypeNumberPad;
        if (self.confDetail.cycleParam.interval > 0) {
            self.intervalTextField.text = [NSString stringWithFormat:@"%zd",self.confDetail.cycleParam.interval];
        }
        
        // 时间选择
        self.cycleTimeSelectTextField = [self
                                         creatTipsLabelAndTextFieldWithTopView:self.intervalTextField describe:@"时间选择"
                                         placeholder:@"时间选择"
                                         tips:@"时间选择格式要求：按周输入数字0~6（0代表周日，1-6代表周一至周六），使用逗号分隔开，例如：0,3,5。按月输入数字1~31。"];
        
        self.cycleTimeSelectTextField.text = self.confDetail.cycleParam.listPoints;
        
        //结束日期
        self.endDateTextField = [self creatLabelAndTextFieldWithTopView:self.cycleTimeSelectTextField describe:@"结束于" placeholder:@"格式2020-08-16 12:00"];
        NSTimeInterval endTimeInterval = self.confDetail.cycleParam.endTimeStamp ? : [NSDate date].timeIntervalSince1970;
        self.endDateTextField.text = [DateUtil formatTimeStringWithTimeInterval:endTimeInterval isHasTimeZoneInterval:NO];
        [self.endDateTextField addTapAction:@selector(selectEndTime) target:self];
        
        //周期会议提前通知时间
        self.preRemindeTextField =[self creatLabelAndTextFieldWithTopView:self.endDateTextField describe:@"提前通知" placeholder:@"通知天数（0-7天）"];
        if (self.confDetail.cycleParam.preRemindDays > 0) {
            self.preRemindeTextField.text = [NSString stringWithFormat:@"%zd",self.confDetail.cycleParam.preRemindDays];
        }
        self.preRemindeTextField.keyboardType = UIKeyboardTypeNumberPad;
    }
    
    // 会议类型
    MediaTypeSwitchView *selectView = [[MediaTypeSwitchView alloc] init];
    [self.scrollView addSubview:selectView];
    SelectType type = SelectTypeAudio;
    if (self.operationType == HWMCycleConfOperationTypeEdit) {
        type = self.confDetail.isVideo ? SelectTypeVideo : SelectTypeAudio ;
    }else if(self.operationType == HWMCycleConfOperationTypeEditSubConf){
        type = (self.subConfInfo.confMediaType == HWMConfMediaTypeAudio) ? SelectTypeAudio : SelectTypeVideo;
    }else{
        
    }
    [selectView changeMediaSelectType:type];
    [selectView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.operationType != HWMCycleConfOperationTypeEditSubConf ? self.preRemindeTextField.mas_bottom : self.confDurationTextField.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(cycleConfViewMarginLeft);
        make.height.mas_equalTo(50);
        make.right.mas_equalTo(self.confSubjectTextField);
    }];
    self.selectView = selectView;
    UIView * topView = selectView;
    
    if (self.operationType != HWMCycleConfOperationTypeEditSubConf) {
        // 与会者
        self.joinSwitch = [self creatLabelAndSwitchWithTopView:topView describe:@"是否携带与会者"];
        [self.joinSwitch setOn:self.selectedMemebrs.count > 0];
        [self.joinSwitch addTarget:self action:@selector(joinSwitchChanged:) forControlEvents:(UIControlEventValueChanged)];
        topView = self.joinSwitch;
    }
    
    // 允许入会
    UILabel *joinConfRestrictionLabel = [self newLabelWithTitle:@"允许入会"];
    [self.scrollView addSubview:joinConfRestrictionLabel];
    joinConfRestrictionLabel.userInteractionEnabled = YES;
    [joinConfRestrictionLabel addTapAction:@selector(selectJoinConfRestriction:) target:self];
    [joinConfRestrictionLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(cycleConfViewMarginLeft);
        make.right.mas_equalTo(self.confSubjectTextField);
        make.top.mas_equalTo(topView.mas_bottom).mas_offset(20);
    }];
    
    self.joinConfRestrictionLabel = [self newLabelWithTitle:@""];
    [self.scrollView addSubview:self.joinConfRestrictionLabel];
    HWMConfAllowJoinUserType allowJoinType = HWMConfAllowJoinUserTypeAnyone;
    if (self.operationType == HWMCycleConfOperationTypeEdit) {
        allowJoinType = (HWMConfAllowJoinUserType)self.confDetail.callInRestriction;
    }else if(self.operationType == HWMCycleConfOperationTypeEditSubConf){
        allowJoinType = (HWMConfAllowJoinUserType)self.subConfInfo.callInRestriction;
    }
    self.joinConfRestrictionLabel.text = [self getTitleAllowInComming:allowJoinType];
    [self.joinConfRestrictionLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(self.confSubjectTextField);
        make.centerY.mas_equalTo(joinConfRestrictionLabel);
    }];
    topView = self.joinConfRestrictionLabel;
    
    if (self.operationType != HWMCycleConfOperationTypeEditSubConf) {
        // 录制会议
        self.recordSwitch = [self creatLabelAndSwitchWithTopView:joinConfRestrictionLabel describe:@"打开会议录制"];
        if (self.operationType == HWMCycleConfOperationTypeEdit) {
            self.recordSwitch.on = self.confDetail.recordType == 2;
        }
        
        // 自动录制会议
        self.autoRecordSwitch = [self creatLabelAndSwitchWithTopView:self.recordSwitch describe:@"打开自动录制会议"];
        if (self.operationType == HWMCycleConfOperationTypeEdit) {
            self.autoRecordSwitch.on = self.confDetail.isAutoRecord;
        }
        
        // 发送邮件通知
        self.emailSwitch = [self creatLabelAndSwitchWithTopView:self.autoRecordSwitch describe:@"邮件通知"];
        if (self.operationType == HWMCycleConfOperationTypeEdit) {
            self.emailSwitch.on = self.confDetail.isSendNotify;
            self.emailSwitch.enabled = !self.confDetail.isSendNotify;
        }
        
        // 发送短信通知
        self.smsSwitch = [self creatLabelAndSwitchWithTopView:self.emailSwitch describe:@"短信通知"];
        if (self.operationType == HWMCycleConfOperationTypeEdit) {
            self.smsSwitch.on = self.confDetail.isSendSms;
            self.smsSwitch.enabled = !self.confDetail.isSendSms;
        }
        
        // 发送日历通知
        self.calendarSwitch = [self creatLabelAndSwitchWithTopView:self.smsSwitch describe:@"日历邮件通知"];
        if (self.operationType == HWMCycleConfOperationTypeEdit) {
            self.calendarSwitch.on = self.confDetail.isSendCalendarNotify;
            self.calendarSwitch.enabled = !self.confDetail.isSendCalendarNotify;
        }
        
        self.autoInviteSwitch = [self creatLabelAndSwitchWithTopView:self.calendarSwitch describe:@"会议开始自动呼叫与会者"];
        [self.autoInviteSwitch setOn:YES];
        
        self.supportWatermarkSwitch = [self creatLabelAndSwitchWithTopView:self.autoInviteSwitch describe:@"是否提供水印"];
        [self.supportWatermarkSwitch setOn:self.cycleConfInfo.orderConfParam.supportWatermark];
        
        self.waitingRoomSwitch = [self creatLabelAndSwitchWithTopView:self.supportWatermarkSwitch describe:@"开启等候室"];
        if (self.operationType == HWMCycleConfOperationTypeEdit) {
            self.waitingRoomSwitch.on = self.confDetail.isOpenWaitingRoom;
        }
        
        UILabel *autoMuteTitleLabel = [self newLabelWithTitle:@"个人客户端入会自动静音"];
        [self.scrollView addSubview:autoMuteTitleLabel];
        autoMuteTitleLabel.userInteractionEnabled = YES;
        [autoMuteTitleLabel addTapAction:@selector(selectAutoMuteMode:) target:self];
        [autoMuteTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(cycleConfViewMarginLeft);
            make.right.mas_equalTo(self.waitingRoomSwitch);
            make.top.mas_equalTo(self.waitingRoomSwitch.mas_bottom).mas_offset(20);
        }];
        
        self.autoMuteLabel = [self newLabelWithTitle:@""];
        [self.scrollView addSubview:self.autoMuteLabel];
        [self.autoMuteLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.right.mas_equalTo(autoMuteTitleLabel);
        }];
        
        UILabel *hardTerminalAutoMuteTitleLabel = [self newLabelWithTitle:@"会议室设备入会自动静音"];
        [self.scrollView addSubview:hardTerminalAutoMuteTitleLabel];
        hardTerminalAutoMuteTitleLabel.userInteractionEnabled = YES;
        [hardTerminalAutoMuteTitleLabel addTapAction:@selector(selectHardTerminalAutoMuteMode:) target:self];
        [hardTerminalAutoMuteTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(cycleConfViewMarginLeft);
            make.right.mas_equalTo(autoMuteTitleLabel);
            make.top.mas_equalTo(autoMuteTitleLabel.mas_bottom).mas_offset(20);
        }];
        
        self.hardTerminalAutoMuteLabel = [self newLabelWithTitle:@""];
        [self.scrollView addSubview:self.hardTerminalAutoMuteLabel];
        [self.hardTerminalAutoMuteLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.centerY.mas_equalTo(hardTerminalAutoMuteTitleLabel);
        }];
        [self updateAutoMuteLabelText];
        
        topView = self.hardTerminalAutoMuteLabel;
        
        // 时区
        if (self.operationType == HWMCycleConfOperationTypeBook) {
            self.timeZoneTextField =  [self creatLabelAndTextFieldWithTopView:topView describe:@"时区" placeholder:@"范围1-77。 56中国"];
            self.timeZoneTextField.keyboardType = UIKeyboardTypeNumberPad;
            topView = self.timeZoneTextField;
        }
    }
    BOOL allowGuestStartConf = YES;
    NSInteger allowGuestStartConfTime = 0;
    if (self.operationType == HWMCycleConfOperationTypeEditSubConf) {
        allowGuestStartConf = self.subConfInfo.allowGuestStartConf;
        allowGuestStartConfTime = self.subConfInfo.allowGuestStartConfTime;
    }else if(self.operationType == HWMCycleConfOperationTypeEdit){
        allowGuestStartConf = self.confDetail.allowGuestStartConf;
        allowGuestStartConfTime = self.confDetail.allowGuestStartConfTime;
    }else{
        allowGuestStartConf = YES;
        allowGuestStartConfTime = 0;
    }
    self.allowGuestStartConfSwitch = [self creatLabelAndSwitchWithTopView:topView describe:@"允许来宾在主持人之前入会"];
    [self.allowGuestStartConfSwitch setOn:allowGuestStartConf];

    self.allowGuestStartConfTimeTextField =  [self creatLabelAndTextFieldWithTopView:self.allowGuestStartConfSwitch describe:@"可提前" placeholder:@"分钟。0:任意时间"];
    self.timeZoneTextField.keyboardType = UIKeyboardTypeNumberPad;
    self.allowGuestStartConfTimeTextField.text = [NSString stringWithFormat:@"%zd", allowGuestStartConfTime];
    [self.allowGuestStartConfTimeTextField mas_updateConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(Screen_Width - cycleConfViewMarginLeft - 200);
        make.left.mas_equalTo(self.scrollView).mas_offset(120);
    }];
    
    UILabel *allowGuestStartConfLable = [self newLabelWithTitle:@"分钟入会"];
    [self.scrollView addSubview:allowGuestStartConfLable];
    [allowGuestStartConfLable mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.allowGuestStartConfTimeTextField.mas_right).offset(10);
        make.right.mas_equalTo(self.scrollView);
        make.height.mas_equalTo(30);
        make.centerY.mas_equalTo(self.allowGuestStartConfTimeTextField);
    }];
    
    // 预约周期会议时显示“去掉预定者开关”，编辑周期会议/子会议时隐藏该开关
    if (self.operationType == HWMCycleConfOperationTypeBook) {
        self.attendeesExcludeSelfSwitch = [self creatLabelAndSwitchWithTopView:self.allowGuestStartConfTimeTextField describe:@"与会者列表是否去掉预定者"];
        self.attendeesExcludeSelfSwitch.on = self.cycleConfInfo.orderConfParam.attendeesExcludeSelf;
        topView = self.attendeesExcludeSelfSwitch;
    }
    
    if (self.operationType == HWMCycleConfOperationTypeBook) {
        self.vmrIdTypeView = [[UIView alloc] init];
        self.vmrIdTypeView.hidden = YES;
        [self.scrollView addSubview:self.vmrIdTypeView];
        self.vmrIdTypeSwitch = [self creatLabelAndSwitchWithTopView:topView superView:self.vmrIdTypeView describe:@"云会议室是否随机会议id"];
        self.vmrIdTypeSwitch.accessibilityIdentifier = HWMManageConfVmrIdTypeSwitch;
        [self.vmrIdTypeView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(0);
            make.right.mas_equalTo(self.confSubjectTextField.mas_right);
            make.top.mas_equalTo(topView.mas_bottom);
            make.bottom.mas_equalTo(self.vmrIdTypeSwitch.mas_bottom);
        }];
        topView = self.vmrIdTypeView;
    }
    
    self.memberView = [[UITextView alloc] init];
    self.memberView.textColor = HexColor(0x333333);
    self.memberView.font = [UIFont systemFontOfSize:14];
    self.memberView.hidden = YES;
    [self.scrollView addSubview:self.memberView];
    [self.memberView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(topView.mas_bottom).mas_offset(20);
        make.left.mas_equalTo(cycleConfViewMarginLeft);
        make.right.mas_equalTo(self.confSubjectTextField);
        make.height.mas_equalTo(50);
    }];
    
    UIButton *submitBtn = [UIButton newButtonWithTitle:[self viewControllerTitle]];
    [self.scrollView addSubview:submitBtn];
    [submitBtn addTarget:self action:@selector(submitBtnClick) forControlEvents:UIControlEventTouchUpInside];
    [submitBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(topView.mas_bottom).mas_offset(50);
        make.left.mas_equalTo(cycleConfViewMarginLeft);
        make.right.mas_equalTo(self.confSubjectTextField);
        make.height.mas_equalTo(50);
    }];
    self.submitBtn = submitBtn;
    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(submitBtn.mas_bottom).mas_offset(150);
    }];
    
    if (self.selectedMemebrs.count > 0) {
        [self isShowMemberView:YES];
        [self refreshMemberView];
    }
}

- (void)selectAutoMuteMode:(UITapGestureRecognizer *)tap {
    [self handleSelectAutoMuteMode:tap handler:^(HWMAutoMuteType type) {
        self.cycleConfInfo.orderConfParam.autoMuteMode = type;
        [self updateAutoMuteLabelText];
    }];
}

- (void)selectHardTerminalAutoMuteMode:(UITapGestureRecognizer *)tap {
    [self handleSelectAutoMuteMode:tap handler:^(HWMAutoMuteType type) {
        self.cycleConfInfo.orderConfParam.hardTerminalAutoMuteMode = type;
        [self updateAutoMuteLabelText];
    }];
}

- (void)handleSelectAutoMuteMode:(UITapGestureRecognizer *)tap handler:(void(^)(HWMAutoMuteType type))handler {
    UIAlertController *alertController = [CommonUtil createAutoMuteAlertController:handler];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.scrollView;
        alertController.popoverPresentationController.sourceRect = tap.view.frame;
    }
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)updateAutoMuteLabelText {
    self.autoMuteLabel.text = [CommonUtil getTitleAutoMute:self.cycleConfInfo.orderConfParam.autoMuteMode];
    self.hardTerminalAutoMuteLabel.text = [CommonUtil getTitleAutoMute:self.cycleConfInfo.orderConfParam.hardTerminalAutoMuteMode];
}

- (UISwitch *)creatLabelAndSwitchWithTopView:(UIView *)topView superView:(UIView *)superView describe:(NSString *)describe {
    
    UISwitch *swt = [[UISwitch alloc] init];
    [superView addSubview:swt];
    [swt mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(topView.mas_bottom).mas_offset(20);
        make.right.mas_equalTo(self.confSubjectTextField);
    }];
    
    UILabel *describeLabel = [self newLabelWithTitle:describe];
    [superView addSubview:describeLabel];
    [describeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(swt);
        make.left.mas_equalTo(superView.mas_left).mas_offset(50);
    }];
    return swt;
}

- (NSString *)viewControllerTitle{
    NSString *title = @"";
    if (self.operationType == HWMCycleConfOperationTypeEdit) {
        title = @"编辑周期会议";
    }else if(self.operationType == HWMCycleConfOperationTypeEditSubConf){
        title = @"编辑子会议";
    }else{
        title = @"预约周期会议";
    }
    return title;;
}

- (void)selectEndTime{
    [self touchesBegan];
    [self.view addSubview:self.selectEndDateView];
    [self.selectEndDateView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(self.view);
    }];
    weakify(self)
    self.selectEndDateView.dateChange = ^(NSString * _Nonnull dataText) {
        strongify(self)
        self.endDateTextField.text = dataText;
    };
}

- (void)selectCycleMode:(UITapGestureRecognizer *)tap{
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"周期模式" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    
    UIAlertAction *dayAction = [UIAlertAction actionWithTitle:@"按日" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self setCycleType:HWMSDKCycleTypeDay];
        [self updateCycleTypeLabelText];
    }];
    UIAlertAction *weekAction = [UIAlertAction actionWithTitle:@"按周" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self setCycleType:HWMSDKCycleTypeWeek];
        [self updateCycleTypeLabelText];
    }];
    UIAlertAction *monthAction = [UIAlertAction actionWithTitle:@"按月" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self setCycleType:HWMSDKCycleTypeMonth];
        [self updateCycleTypeLabelText];
    }];
    [alertController addAction:cancelAction];
    [alertController addAction:dayAction];
    [alertController addAction:weekAction];
    [alertController addAction:monthAction];
    
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.scrollView;
        alertController.popoverPresentationController.sourceRect = tap.view.frame;
    }
    
    [self presentViewController:alertController animated:YES completion:nil];
}

- (HWMVmrIdType)getVmrIDType {
   BOOL isVmrMeetingRoom = self.cycleConfInfo.orderConfParam.vmrId.length > 0 && ![self.cycleConfInfo.orderConfParam.vmrId isEqualToString:self.vmrList[0].vmrId];
   if (isVmrMeetingRoom) {
       return self.vmrIdTypeSwitch.isOn ? HWMVmrIdTypeRandom : HWMVmrIdTypeFixed;
   }
   return HWMVmrIdTypeFixed;
}

- (void)setCycleType:(HWMCycleType)cycleType{
    [self.cycleConfInfo.cycleParam setCycleType:cycleType];
}

- (void)updateCycleTypeLabelText {
    self.cycleModeLable.text = [self getTitleCycleType:self.cycleConfInfo.cycleParam.cycleType];
}

- (NSString *)getTitleCycleType:(HWMCycleType)cycleType
{
    switch (cycleType) {
        case HWMSDKCycleTypeDay:
            return @"按日";
            break;
        case HWMSDKCycleTypeWeek:
            return @"按周";
            break;
        case HWMSDKCycleTypeMonth:
            return @"按月";
            break;
        default:
            return @"";
            break;
    }
}

- (void)submitBtnClick{
    [self updateInfo];
    switch (self.operationType) {
        case HWMCycleConfOperationTypeBook:
            [self handleBookCycleConf];
            break;
        case HWMCycleConfOperationTypeEdit:
            [self handleEditCycleConf];
            break;
        case HWMCycleConfOperationTypeEditSubConf:
            [self editSubCycleConf];
            break;
        default:
            break;
    }
}

- (void)updateInfo{
    if (!self.joinSwitch.isOn) {
        self.attendee = nil;
    }
    if ([self.attendee count] > 0) {
        BOOL autoInvite = self.autoInviteSwitch.isOn;
        [self.attendee enumerateObjectsUsingBlock:^(HWMAttendeeInfo * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
            obj.isAutoInvite = autoInvite;
        }];
    }
    if (self.operationType == HWMCycleConfOperationTypeEditSubConf) {
        self.modifySubCycleConfParam.confId = self.confDetail.confId;
        self.modifySubCycleConfParam.subConfID = self.subConfInfo.subConfID;
        self.modifySubCycleConfParam.confMediaType = (HWMConfMediaType)[self.selectView currentSelectMediaType];
        self.modifySubCycleConfParam.startTimeStamp = [DateUtil formatTimeIntervalWithTime:self.startTimeTextField.text];
        self.modifySubCycleConfParam.confLen = [self.confDurationTextField.text integerValue];
        self.modifySubCycleConfParam.isAutoRecord = self.autoRecordSwitch.isOn;
        self.modifySubCycleConfParam.recordAuthType = self.subConfInfo.recordAuthType;
        self.modifySubCycleConfParam.allowGuestStartConf = self.allowGuestStartConfSwitch.isOn;
        self.modifySubCycleConfParam.allowGuestStartConfTime = [self.allowGuestStartConfTimeTextField.text integerValue];
    }else{
        self.cycleConfInfo.orderConfParam.confSubject = self.confSubjectTextField.text;
        // 计算utc时间戳
        self.cycleConfInfo.orderConfParam.startTimeStamp = [DateUtil formatTimeIntervalWithTime:self.startTimeTextField.text];
        self.cycleConfInfo.orderConfParam.duration = [self.confDurationTextField.text integerValue];
        self.cycleConfInfo.orderConfParam.isRecordOn = self.recordSwitch.isOn;
        self.cycleConfInfo.orderConfParam.isAutoRecord = self.autoRecordSwitch.isOn;
        self.cycleConfInfo.orderConfParam.supportWatermark = self.supportWatermarkSwitch.isOn;
        self.cycleConfInfo.orderConfParam.isMailOn = self.emailSwitch.isOn;
        self.cycleConfInfo.orderConfParam.isSmsOn = self.smsSwitch.isOn;
        self.cycleConfInfo.orderConfParam.isEmailCalenderOn = self.calendarSwitch.isOn;
        self.cycleConfInfo.orderConfParam.allowGuestStartConf = self.allowGuestStartConfSwitch.isOn;
        self.cycleConfInfo.orderConfParam.allowGuestStartConfTime = [self.allowGuestStartConfTimeTextField.text integerValue];
        self.cycleConfInfo.orderConfParam.confType = (HWMOrderConfType)[self.selectView currentSelectMediaType];
        if (self.operationType == HWMCycleConfOperationTypeBook) {
            self.cycleConfInfo.orderConfParam.isNeedConfPwd = self.generalPwdSwitch.isOn;
            self.cycleConfInfo.orderConfParam.timeZone = [self.timeZoneTextField.text integerValue];
            self.cycleConfInfo.orderConfParam.vmrIdType = [self getVmrIDType];
        }else{
            [self.cycleConfInfo.orderConfParam setConfId:self.confDetail.confId];
        }
        self.cycleConfInfo.orderConfParam.attendee = self.joinSwitch.isOn ? self.attendee : nil;
        self.cycleConfInfo.cycleParam.startTimeStamp = [DateUtil formatTimeIntervalWithTime:self.startTimeTextField.text];
        self.cycleConfInfo.cycleParam.endTimeStamp = [DateUtil formatTimeIntervalWithTime:self.endDateTextField.text];
        self.cycleConfInfo.cycleParam.interval = [self.intervalTextField.text integerValue];
        self.cycleConfInfo.cycleParam.listPoints = self.cycleTimeSelectTextField.text;
        self.cycleConfInfo.cycleParam.preRemindDays = [self.preRemindeTextField.text integerValue];
        self.cycleConfInfo.orderConfParam.isOpenWaitingRoom = self.waitingRoomSwitch.isOn;
        self.cycleConfInfo.orderConfParam.customInfo = self.customInfoTextField.text;
        if (self.concurrentParticipantsTextField.text && self.concurrentParticipantsTextField.text.length > 0) {
            self.cycleConfInfo.orderConfParam.concurrentParticipants = [self.concurrentParticipantsTextField.text integerValue];
        } else {
            if (self.operationType == HWMCycleConfOperationTypeEdit) {
                self.cycleConfInfo.orderConfParam.concurrentParticipants = 0;
            }
        }
    }
    self.cycleConfInfo.orderConfParam.attendeesExcludeSelf = self.attendeesExcludeSelfSwitch.isOn;
}

/// 如果是固定vmrid 且 “allowGuestStartConf”值变了需要在预约会议和编辑会议之前调用changeVmrInfo接口修改vmr信息，否则固定vmrid的预约会议和编辑会议“allowGuestStartConf”不生效
- (HWMModifyVMRParam *)needModifyVmrInfoWithVmrId:(NSString *)vmrId vmrIdType:(HWMVmrIdType)vmrIdType allowGuestStartConf:(BOOL)allowGuestStartConf {
    BOOL needCheck = vmrId && vmrId.length > 0 && vmrIdType == HWMVmrIdTypeFixed;
    NSLog(@"check need modifyVmr, vmrId:%@, vmrIdType:%zd", vmrId, vmrIdType);
    if (!needCheck) {
        return nil;
    }
    
    __block HWMVmrInfoModel *vmrInfo = nil;
    [self.vmrList enumerateObjectsUsingBlock:^(HWMVmrInfoModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        if ([vmrId isEqualToString:obj.vmrId] && obj.allowGuestStartConf != allowGuestStartConf) {
            *stop = YES;
            vmrInfo = obj;
        }
    }];
    
    if (vmrInfo) {
        NSLog(@"new allowGuestStartConf:%d", vmrInfo.allowGuestStartConf);
        HWMModifyVMRParam *modifyVmrParam = [[HWMModifyVMRParam alloc] init];
        modifyVmrParam.vmrId = vmrInfo.vmrId;
        modifyVmrParam.vmrName = vmrInfo.name;
        modifyVmrParam.guestPwd = vmrInfo.chairmanPwd;
        modifyVmrParam.guestPwd = vmrInfo.guestPwd;
        modifyVmrParam.allowGuestStartConf = allowGuestStartConf;
        return modifyVmrParam;
    }
 
    return nil;
}

- (void)handleBookCycleConf{
    HWMModifyVMRParam *vmrInfo = [self needModifyVmrInfoWithVmrId:self.cycleConfInfo.orderConfParam.vmrId
                                                        vmrIdType:self.cycleConfInfo.orderConfParam.vmrIdType
                                              allowGuestStartConf:self.cycleConfInfo.orderConfParam.allowGuestStartConf];
    if (vmrInfo) {
        [[HWMBizSdk getBizOpenApi] changeVmrInfo:vmrInfo callback:^(NSError * _Nullable error, id  _Nullable result) {
            if (error) {
                [UIUtil showMessageWithError:error];
            } else {
                [self bookCycleConf];
            }
        }];
    } else {
        [self bookCycleConf];
    }
}

- (void)handleEditCycleConf{
    HWMModifyVMRParam *vmrInfo = [self needModifyVmrInfoWithVmrId:self.cycleConfInfo.orderConfParam.vmrId
                                                        vmrIdType:self.cycleConfInfo.orderConfParam.vmrIdType
                                              allowGuestStartConf:self.cycleConfInfo.orderConfParam.allowGuestStartConf];
    if (vmrInfo) {
        [[HWMBizSdk getBizOpenApi] changeVmrInfo:vmrInfo callback:^(NSError * _Nullable error, id  _Nullable result) {
            if (error) {
                [UIUtil showMessageWithError:error];
            } else {
                [self editCycleConf];
            }
        }];
    } else {
        [self editCycleConf];
    }
}

- (void)bookCycleConf{
    [self.cycleConfInfo.orderConfParam setGuestPwd:self.pwdTextField.text];
    [[HWMBizSdk getBizOpenApi] bookCycleConf:self.cycleConfInfo callback:^(NSError * _Nullable error, id  _Nullable result) {
        if (!error) {
            NSLog(@"book cycle conf success");
            [UIUtil showMessage:@"预约周期会议会议成功"];
        }else{
            NSLog(@"book cycle conf fail errorCode : %zd",error.code);
            [UIUtil showMessageWithError:error];

        }
    }];
}

- (void)editCycleConf{
    [[HWMBizSdk getBizOpenApi] editCycleConf:self.cycleConfInfo callback:^(NSError * _Nullable error, id  _Nullable result) {
        if (!error) {
            NSLog(@"edit cycle conf success");
            [UIUtil showMessage:@"编辑周期会议会议成功"];
        }else{
            NSLog(@"edit cycle conf fail errorCode : %zd",error.code);
            [UIUtil showMessageWithError:error];

        }
    }];
}

- (void)editSubCycleConf{
    [[HWMBizSdk getBizOpenApi] editSubCycleConf:self.modifySubCycleConfParam callback:^(NSError * _Nullable error, id  _Nullable result) {
        if (!error) {
            [UIUtil showMessage:@"编辑周期子会议会议成功"];
        }else{
            [UIUtil showMessageWithError:error];
        }
    }];
}

- (void)updateVmrInfoView{
    UIView * topView = self.selectView;
    if (HWMCycleConfOperationTypeBook ==  self.operationType) {
        //个人会议ID
        if (self.vmrList.count == 1 && !self.isEnableShareVmr) {
            self.personalIDSwitch = [self creatLabelAndSwitchWithTopView:topView describe:[NSString stringWithFormat:@"使用个人会议ID %@", self.vmrList[0].confId]];
            [self.personalIDSwitch addTarget:self action:@selector(personalIDSwitchChange:) forControlEvents:UIControlEventValueChanged];
            topView = self.personalIDSwitch;
        } else {
            // 会议ID类型
            UILabel *confIdTypeLabel = [self newLabelWithTitle:@"会议ID类型"];
            [self.scrollView addSubview:confIdTypeLabel];
            confIdTypeLabel.userInteractionEnabled = YES;
            [confIdTypeLabel addTapAction:@selector(selectConfIdType:) target:self];
            [confIdTypeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.mas_equalTo(topView);
                make.right.mas_equalTo(self.confSubjectTextField);
                make.top.mas_equalTo(topView.mas_bottom).mas_offset(20);
            }];
            
            self.confIdTypeLabel = [self newLabelWithTitle:@"随机会议ID"];
            [self.scrollView addSubview:self.confIdTypeLabel];
            [self.confIdTypeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
                make.right.mas_equalTo(self.confSubjectTextField);
                make.centerY.mas_equalTo(confIdTypeLabel);
            }];
            topView = confIdTypeLabel;
        }
        
        // 来宾密码
        self.generalPwdSwitch = [self creatLabelAndSwitchWithTopView:topView describe:@"来宾密码"];
        
        // 密码输入
        self.pwdTextField = [self creatLabelAndTextFieldWithTopView:self.generalPwdSwitch describe:@"会议密码" placeholder:@"会议密码"];
        self.pwdTextField.keyboardType = UIKeyboardTypeNumberPad;
        topView = self.pwdTextField;
        
        [self.joinSwitch mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(topView.mas_bottom).offset(20);
            make.right.mas_equalTo(self.confSubjectTextField);
        }];
    }
}

- (void)changeVmrIdTypeViewHidden:(BOOL)hidden {
    self.vmrIdTypeView.hidden = hidden;
}

- (HWMSDKModifySubCycleConfParamModel *)modifySubCycleConfParam{
    if (!_modifySubCycleConfParam) {
        _modifySubCycleConfParam = [[HWMSDKModifySubCycleConfParamModel alloc] init];
    }
    return _modifySubCycleConfParam;
}

- (HWMOrderCycleConfParam *)cycleConfInfo{
    if (!_cycleConfInfo) {
        _cycleConfInfo = [[HWMOrderCycleConfParam alloc] init];
        _cycleConfInfo.orderConfParam = [[HWMOrderConfParam alloc] init];
        _cycleConfInfo.cycleParam = [[HWMSDKCycleConfParamModel alloc] init];
    }
    return _cycleConfInfo;
}

- (void)touchesBegan {
    [self endEdit];
}

- (void)endEdit {
    [self.view endEditing:YES];
}

- (void)selectStartTime {
    [self touchesBegan];
    SelectDateView *startDateView = [[SelectDateView alloc] init];
    [self.view addSubview:startDateView];
    [self.view addSubview:startDateView];
    [startDateView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.mas_equalTo(self.view);
    }];
    startDateView.dateChange = ^(NSString * _Nonnull dataText) {
        self.startTimeTextField.text = dataText;
    };
}



- (void)joinSwitchChanged:(UISwitch *)swt {
    [self isShowMemberView:swt.isOn];
    if (swt.on) {
        __weak __typeof(self) weakSelf = self;
        __block NSMutableArray *numbers = [NSMutableArray array];
        [self.selectedMemebrs enumerateObjectsUsingBlock:^(HWMContactSelectedModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
            HWMConfContactModel * model = [[HWMConfContactModel alloc] init];
            model.number = obj.number;
            model.accountId = obj.accountId;
            model.isHardTerminal = obj.isHardTerminal;
            [numbers addObject:model];
        }];
        
        [[HWMSdk getPrivateApi] openContactSelectPage:numbers scene:HWMSelectedContactBookConf completeHander:^(NSArray<HWMContactSelectedModel *> * _Nonnull result, NSError * _Nonnull error) {
            NSMutableArray * selectedMemebrs = [NSMutableArray arrayWithArray:self.selectedMemebrs];
            [selectedMemebrs addObjectsFromArray:result];
            weakSelf.selectedMemebrs = selectedMemebrs;
            [weakSelf refreshMemberView];
            [weakSelf updateConfInfoAttendee:result];
        }];
    }
}

- (void)isShowMemberView:(BOOL)show {
    self.memberView.hidden = !show;
    [self.submitBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
        if(show) {
            make.top.mas_equalTo(self.memberView.mas_bottom).mas_offset(50);
        } else {
            make.top.mas_equalTo(self.memberView.mas_top).mas_offset(30);
        }
        make.left.mas_equalTo(cycleConfViewMarginLeft);
        make.right.mas_equalTo(self.confSubjectTextField);
        make.height.mas_equalTo(50);
    }];
}

- (void)refreshMemberView{
    __block NSMutableString *memberString = [[NSMutableString alloc] init];
    [self.selectedMemebrs enumerateObjectsUsingBlock:^(HWMContactSelectedModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        [memberString appendFormat:@"%@,", obj.name];
    }];
    self.memberView.text = memberString;
}

- (void)updateConfInfoAttendee:(NSArray <HWMContactSelectedModel *> *)selectedMemebrs {
    NSMutableArray * attendee = [NSMutableArray arrayWithArray:self.attendee];
    NSArray * newSelectAttendee = [HWMAttendeeInfo convertAttendeesFromContactList:selectedMemebrs];
    [attendee addObjectsFromArray:newSelectAttendee];
    self.attendee = attendee.copy;
}

- (void)personalIDSwitchChange:(UISwitch *)swt {
    HWMVmrInfoModel * model = self.vmrList[0];
    [self.pwdTextField setEnabled:!swt.isOn];
    [self updatePwdTextFeild:swt.isOn ? self.vmrList[0].guestPwd : @""];
    [self.cycleConfInfo.orderConfParam setVmrId:swt.isOn ? model.vmrId : @""];
}

- (void)selectConfIdType:(UITapGestureRecognizer *)tap {
    [self endEdit];
    if (self.vmrList.count == 1 && !self.isEnableShareVmr) {
        return;
    }
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"会议类型" message:@"" preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.scrollView;
        alertController.popoverPresentationController.sourceRect = tap.view.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    [alertController addAction:cancelAction];
    
    [self.vmrList enumerateObjectsUsingBlock:^(HWMVmrInfoModel * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        UIAlertAction *action;
        if (idx == 0) {
            NSString * title = @"个人会议ID";
            [self changeVmrIdTypeViewHidden:YES];
            action = [UIAlertAction actionWithTitle:title style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                [self updateConfIdTypeLabelText:title confPwd:obj.guestPwd vmrId:obj.vmrId];
            }];
        } else {
            NSString * title = [NSString stringWithFormat:@"%@(%zd)%@", obj.name, obj.maxParties, obj.confId];
            [self changeVmrIdTypeViewHidden:NO];
            action = [UIAlertAction actionWithTitle:title style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
                [self updateConfIdTypeLabelText:title confPwd:obj.guestPwd vmrId:obj.vmrId];
            }];
        }
        [alertController addAction:action];
    }];
    
    NSString * title = @"随机会议ID";
    UIAlertAction *action = [UIAlertAction actionWithTitle:title style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self updateConfIdTypeLabelText:title confPwd:@"" vmrId:@""];
    }];
    [alertController addAction:action];
    if (self.isEnableShareVmr) {
        UIAlertAction *action = [UIAlertAction actionWithTitle:@"共享云会议室" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
            [self changeVmrIdTypeViewHidden:YES];
            [self updateConfIdTypeLabelText:@"共享云会议室" confPwd:@"" vmrId:@""];
            self.cycleConfInfo.orderConfParam.confResType = HWMSDKConfRestypeShareVmr;
            self.cycleConfInfo.orderConfParam.vmrIdType = HWMVmrIdTypeRandom;
        }];
        action.accessibilityIdentifier = HWMManageCycleConfVmrIdTypeShareVmr;
        [alertController addAction:action];
    }
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)updatePwdTextFeild:(NSString *)pwd {
    self.pwdTextField.text = pwd;
}

- (void)updateConfIdTypeLabelText:(NSString *)text confPwd:(NSString *)pwd vmrId:(NSString *)vmrId {
    self.confIdTypeLabel.text = text;
    [self updatePwdTextFeild:pwd];
    [self.cycleConfInfo.orderConfParam setVmrId:vmrId];
}

- (void)selectJoinConfRestriction:(UITapGestureRecognizer *)tap {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"允许入会" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.scrollView;
        alertController.popoverPresentationController.sourceRect = tap.view.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    
    UIAlertAction *allAction = [UIAlertAction actionWithTitle:@"所有人" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self setCallInRestrictionType:HWMConfAllowJoinUserTypeAnyone];
    }];
    UIAlertAction *companyAction = [UIAlertAction actionWithTitle:@"仅企业内人员" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self setCallInRestrictionType:HWMConfAllowJoinUserTypeInCompanyUser];
    }];
    UIAlertAction *invitedAction = [UIAlertAction actionWithTitle:@"仅会议邀请人员" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self setCallInRestrictionType:HWMConfAllowJoinUserTypeInvitedUser];
    }];
    [alertController addAction:cancelAction];
    [alertController addAction:allAction];
    [alertController addAction:companyAction];
    [alertController addAction:invitedAction];
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)setCallInRestrictionType:(HWMConfAllowJoinUserType)type{
    switch (self.operationType) {
        case HWMCycleConfOperationTypeBook:
            [self.cycleConfInfo.orderConfParam setCallInRestrictionType:(HWMJoinConfRestrictionType)type];
            break;
        case HWMCycleConfOperationTypeEdit:
            [self.cycleConfInfo.orderConfParam setCallInRestrictionType:(HWMJoinConfRestrictionType)type];
            break;
        case HWMCycleConfOperationTypeEditSubConf:
            [self.modifySubCycleConfParam setCallInRestriction:type];
            break;
        default:
            break;
    }
    self.joinConfRestrictionLabel.text = [self getTitleAllowInComming:type];
}

-(SelectDateView *)selectEndDateView {
    if (!_selectEndDateView) {
        _selectEndDateView = [[SelectDateView alloc] init];
    }
    return _selectEndDateView;
}

- (HWMUITextField *)creatLabelAndTextFieldWithTopView:(UIView *)topView describe:(NSString *)describe placeholder:(NSString *)placeholder {
    UILabel *describeLabel = [self newLabelWithTitle:describe];
    [self.scrollView addSubview:describeLabel];
    [describeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        if (topView) {
            make.top.mas_equalTo(topView.mas_bottom).mas_offset(20);
        } else {
            make.top.mas_equalTo(100);
        }
        make.left.mas_equalTo(cycleConfViewMarginLeft);
        make.height.mas_equalTo(30);
        make.width.mas_equalTo(100);
    }];
    
    HWMUITextField *textField = [[HWMUITextField alloc] init];
    [self.scrollView addSubview:textField];
    textField.placeholder = placeholder;
    [textField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(describeLabel);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(describeLabel.mas_right).mas_offset(20);
        make.width.mas_equalTo(Screen_Width - cycleConfViewMarginLeft - 140);
    }];
    [UIView addBottomLineWithView:textField parentView:self.scrollView];
    return textField;
}

- (UITextField *)creatTipsLabelAndTextFieldWithTopView:(UIView *)topView
                                              describe:(NSString *)describe
                                           placeholder:(NSString *)placeholder
                                                  tips:(NSString *)tips{
    UILabel *tipsLable = [[UILabel alloc] init];
    tipsLable.numberOfLines = 0;
    tipsLable.textColor = [UIColor lightGrayColor];
    tipsLable.text = tips;
    [self.scrollView addSubview:tipsLable];
    [tipsLable mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(cycleConfViewMarginLeft);
        make.width.mas_equalTo(Screen_Width - 2 * cycleConfViewMarginLeft);
        make.top.equalTo(topView.mas_bottom).offset(20);
    }];
    
    UILabel *describeLabel = [self newLabelWithTitle:describe];
    [self.scrollView addSubview:describeLabel];
    [describeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        if (topView) {
            make.top.mas_equalTo(tipsLable.mas_bottom);
        } else {
            make.top.mas_equalTo(100);
        }
        make.left.mas_equalTo(cycleConfViewMarginLeft);
        make.height.mas_equalTo(30);
        make.width.mas_equalTo(70);
    }];
    
    UITextField *textField = [[UITextField alloc] init];
    [self.scrollView addSubview:textField];
    textField.placeholder = placeholder;
    [textField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(describeLabel);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(describeLabel.mas_right).mas_offset(20);
        make.width.mas_equalTo(Screen_Width - cycleConfViewMarginLeft - 140);
    }];
    
    [UIView addBottomLineWithView:textField parentView:self.scrollView];
    return textField;
}

- (UISwitch *)creatLabelAndSwitchWithTopView:(UIView *)topView describe:(NSString *)describe {
    
    UISwitch *swt = [[UISwitch alloc] init];
    [self.scrollView addSubview:swt];
    [swt mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(topView.mas_bottom).mas_offset(20);
        make.right.mas_equalTo(self.confSubjectTextField);
    }];
    
    UILabel *describeLabel = [self newLabelWithTitle:describe];
    [self.scrollView addSubview:describeLabel];
    [describeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.mas_equalTo(swt);
        make.left.mas_equalTo(cycleConfViewMarginLeft);
    }];
    
    
    return swt;
}

- (UILabel *)newLabelWithTitle:(NSString *)title {
    UILabel *label = [[UILabel alloc] init];
    label.text = title;
    label.font = [UIFont systemFontOfSize:16];
    label.textColor = HexColor(0x333333);
    return label;
}

- (NSString *)getTitleAllowInComming:(HWMConfAllowJoinUserType)callInRestrictionType
{
    switch (callInRestrictionType) {
        case HWMConfAllowJoinUserTypeAnyone:
            return @"所有人";
            break;
        case HWMConfAllowJoinUserTypeInCompanyUser:
            return @"仅企业内人员";
            break;
        case HWMConfAllowJoinUserTypeInvitedUser:
            return @"仅会议邀请人员";
            break;
        default:
            return @"";
            break;
    }
}

@end
