//
//  CancelConfViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/8/4.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "CancelConfViewController.h"
#import <HWMUISDK/HWMBizSdk.h>
@interface CancelConfViewController ()
@property (nonatomic, strong) UITextField *confIdTextField;
@end

@implementation CancelConfViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"取消会议";
}

- (void)setupViews {
    [super setupViews];
    self.confIdTextField = [[UITextField alloc] init];
    [self.view addSubview:self.confIdTextField];
    self.confIdTextField.placeholder = @"会议ID";
    self.confIdTextField.accessibilityIdentifier = HWMCancelConfConfId;
    [self.confIdTextField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(100);
        make.height.mas_equalTo(30);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
    }];
    [UIView addBottomLineWithView:self.confIdTextField parentView:self.view];

    UIButton *cancelConfBtn = [UIButton newButtonWithTitle:@"取消会议"];
    cancelConfBtn.accessibilityIdentifier = HWMCancelConfCancel;
    [self.view addSubview:cancelConfBtn];
    [cancelConfBtn addTarget:self action:@selector(cancelConf) forControlEvents:UIControlEventTouchUpInside];
    [cancelConfBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.confIdTextField.mas_bottom).mas_offset(50);
        make.left.right.mas_equalTo(self.confIdTextField);
        make.height.mas_equalTo(50);
    }];
}

- (void)cancelConf {
    if (self.confIdTextField.text.length == 0) {
        [UIUtil showMessage:@"请输入会议ID"];
    }
    [[HWMBizSdk getBizOpenApi] cancelConf:self.confIdTextField.text callback:^(NSError * _Nullable error, id  _Nullable result) {
        [UIUtil showMessage:@"取消会议成功" error:error];
    }];
}
@end
