//
//  InvocationViewController.m
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/8/3.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "InvocationViewController.h"
#import <HWMUISDK/HWMUISDK.h>
typedef NS_ENUM(NSInteger, CellType) {
    CellTypeSelfIsChairman,
    CellTypeSelfShareState,
    CellTypeGetLoginState,
    CellTypeGetLoginToken,
    CellTypeSubtitlePageOpened,
    CellTypeWaitingRoomOpened,
    CellTypeVirtualBackgroundSettingPageOpened,
};

@interface InvocationViewController ()

@end

@implementation InvocationViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"主动调用";
    [self setupDatas];
    [self setupTableView];
}


- (void)setupDatas{
    self.dataArray = @[[ActionModel initWithTitle:@"自己是否是主持人" type:CellTypeSelfIsChairman],
                       [ActionModel initWithTitle:@"自己是否在共享" type:CellTypeSelfShareState],
                       [ActionModel initWithTitle:@"获取登录状态" type:CellTypeGetLoginState],
                       [ActionModel initWithTitle:@"获取登录Token" type:CellTypeGetLoginToken],
                       [ActionModel initWithTitle:@"是否已经开启字幕页面" type:CellTypeSubtitlePageOpened],
                       [ActionModel initWithTitle:@"是否已经开启等候室" type:CellTypeWaitingRoomOpened],
                       [ActionModel initWithTitle:@"是否已经打开虚拟背景设置" type:CellTypeVirtualBackgroundSettingPageOpened]];
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    UITableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"UITableViewCell"];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:@"UITableViewCell"];
    }
    [cell setSelectionStyle:UITableViewCellSelectionStyleDefault];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.textLabel.text = model.title;
    if (model.type == CellTypeSelfIsChairman) {
        cell.detailTextLabel.text = [[HWMBizSdk getBizOpenApi] selfIsChairMan]?@"YES":@"NO";
    } else if (model.type == CellTypeSelfShareState) {
        cell.detailTextLabel.text = [[HWMBizSdk getBizOpenApi] getSelfShareState] ? @"YES" : @"NO";
    } else if (model.type == CellTypeGetLoginState) {
        cell.detailTextLabel.text = [self getLoginState];
    } else if (model.type == CellTypeGetLoginToken) {
        cell.detailTextLabel.text = [[HWMBizSdk getBizOpenApi] getLoginToken];
    } else if (model.type == CellTypeSubtitlePageOpened) {
        cell.detailTextLabel.text = [[HWMBizSdk getBizOpenApi] subtitlePageOpened] ? @"YES" : @"NO";
    } else if (model.type == CellTypeWaitingRoomOpened) {
        cell.detailTextLabel.text = [[HWMBizSdk getBizOpenApi] waitingRoomOpened] ? @"YES" : @"NO";
    } else if (model.type == CellTypeVirtualBackgroundSettingPageOpened) {
        cell.detailTextLabel.text = [[HWMBizSdk getBizOpenApi] virtualBackgroundSettingPageOpened] ? @"YES" : @"NO";
    }
    
    return cell;
}

- (NSString *)getLoginState {
    HWMLoginState loginState = [[HWMBizSdk getBizOpenApi] getLoginState];
    switch (loginState) {
        case HWMLoginStateUnLogin: return @"未登录";
        case HWMLoginStateLogining: return @"登录中";
        case HWMLoginStateLogined: return @"已登录";
        case HWMLoginStateLogouting: return @"登出中";
        default: return @"";
    }
}

@end
