//
//  NotifyMessageModel.m
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/8/3.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "NotifyMessageModel.h"

@implementation NotifyMessageModel

- (instancetype)initWithMsgType:(NotifyMessageModelType)type content:(NSString *)desc{
    if (self = [super init]) {
        self.msgType = type;
        self.desc = desc;
        self.title = [self generateTitle:type];
    }
    return self;
}

- (NSString *)generateTitle:(NotifyMessageModelType)type{
    switch (type) {
        case NotifyMessageModelTypeCreateConf:
            return @"收到创建会议结果消息";
        case NotifyMessageModelTypeKickOut:
            return @"收到被T消息";
        case NotifyMessageModelTypeCallStatus:
            return @"收到点对点呼叫状态消息";
        case NotifyMessageModelTypeConfStatus:
            return @"收到会议状态消息";
        case NotifyMessageModelTypeConfEnd:
            return @"收到会议结束消息";
        case NotifyMessageModelTypeCallEnd:
            return @"收到点对点呼叫结束消息";
        case NotifyMessageModelTypeSelfHostRoleChange:
             return @"收到自己主持人角色改变消息";
        case NotifyMessageModelTypeRecordPermission:
             return @"收到录播权限改变消息";
        case NotifyMessageModelTypeSmsPermission:
             return @"收到短信发送权限改变消息";
        case NotifyMessageModelTypeConfDetail:
             return @"收到会中会议详情消息";
        case NotifyMessageModelTypeConfComing:
             return @"收到会议来电消息";
        case NotifyMessageModelTypeScreenShareStateChange:
            return @"收到屏幕共享状态改变通知";
        case NotifyMessageModelTypeP2PConfRecord:
            return @"收到立即会议通话记录消息";
        case NotifyMessageModelTypeToolBarItemClick:
            return @"收到ToolBar菜单点击消息";
        case NotifyMessageModelTypeFloatingWindowStateChange:
            return @"收到悬浮窗状态变化消息";
        case NotifyMessageModelTypeAddAttendeeResult:
            return @"收到添加与会者结果通知";
        case NotifyMessageModelTypeWaitingListChange:
            return @"收到等候室列表变更通知";
        case NotifyMessageModelTypeCallOtherNumber:
            return @"收到呼叫其他号码通知";
        case NotifyMessageModelTypeSelfRoleChange:
             return @"收到自己角色改变消息";
        case NotifyMessageModelTypeAttendeeListChange:
            return @"收到与会者列表变更通知";
        case NotifyMessageModelTypeCorpConfigInfoChange:
            return @"收到企业配置信息变更通知";
        case NotifyMessageModelTypeSubtitleStateChange:
            return @"收到字幕状态变更通知";
        case NotifyMessageModelTypeWaitingRoomStateChange:
            return @"收到等候室状态变更通知";
        case NotifyMessageModelTypeUserCorpConfigChange:
            return @"用户企业信息变更通知";
        case NotifyMessageModelTypeLoginStateChange:
            return @"收到登录状态变更通知";
        default:
            return @"";
    }
}
@end
