//
//  AcceptConfViewController.m
//  HWMSDKDemo
//
//  Created by lining on 2025/4/7.
//  Copyright © 2025 HuaWei. All rights reserved.
//

#import "AcceptConfViewController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "GlobalHandlerImpl.h"

typedef NS_ENUM(NSInteger, CellType) {
    AudioAcceptSwitchCell,
    SpeakerOffSwitchCell,
    AcceptCell
};

@interface AcceptConfViewController ()

@property (nonatomic, strong) HWMAcceptConfParam *param;

@end

@implementation AcceptConfViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupDatas];
    [self setupTableView];
}

- (void)setupDatas{
    self.param = [[HWMAcceptConfParam alloc] init];
    self.dataArray = @[
        [ActionModel initWithTitle:@"语音接听(立即视频会议生效)" type:AudioAcceptSwitchCell],
        [ActionModel initWithTitle:@"开启听筒" type:SpeakerOffSwitchCell],
        [ActionModel initWithTitle:@"接听" type:AcceptCell],
    ];
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    TableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    [cell setSelectionStyle:UITableViewCellSelectionStyleDefault];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.titleLabel.text = model.title;
    switch (model.type) {
        case AudioAcceptSwitchCell:
        {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:self.param.isAudioAccept];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                self.param.isAudioAccept = isSelect;
            };
        }
            break;
        case SpeakerOffSwitchCell:
        {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:self.param.isSpeakerOff];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                self.param.isSpeakerOff = isSelect;
            };
        }
            break;
        case AcceptCell: {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = YES;
        }
            break;
        default:
            break;
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    ActionModel *model = self.dataArray[indexPath.row];
    switch (model.type) {
        case AcceptCell:{
            [self accept];
        }
            break;
        default:
            break;
    }
}

- (void)accept {
    [[HWMSdk getOpenApi] acceptConf:self.param callback:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [UIUtil showMessage:@"接听来电失败" error:error];
        }
    }];
}

@end
