//
//  ConfSettingViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2020/8/10.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "ConfSettingViewController.h"
#import "SDKEnvConfig.h"
#import "GlobalHandlerImpl.h"
#import "AttendeesViewController.h"
#import "VoiceViewController.h"
#import "VirtualBackgroundViewController.h"

typedef NS_ENUM (NSInteger, CellType) {
    CellTypeCustomDeviceStatus = 1,
    CellTypeMicStatus,
    CellTypeCameraStatus,
    CellTypeAnswerBtnShowType,
    CellTypeRing,                   /**< 来电时响铃 */
    CellTypeVibrate,                /**< 来电时震动 */
};

@interface ConfSettingViewController ()

@end

@implementation ConfSettingViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"会议设置";
    [self setupDatas];
    [self setupTableView];
}

- (void)setupDatas {
    self.dataArray = @[[ActionModel initWithTitle:@"是否自定义会议相关设置开关" type:CellTypeCustomDeviceStatus accessibilityId:HWMConfSettingCustomDeviceStatus],
                       [ActionModel initWithTitle:@"接听会议麦克风状态" type:CellTypeMicStatus accessibilityId:HWMConfSettingAcceptMicStatus],
                       [ActionModel initWithTitle:@"接听会议摄像头状态" type:CellTypeCameraStatus accessibilityId:HWMConfSettingAcceptCameraStatus],
                       [ActionModel initWithTitle:@"视频会议来电时按钮显示状态" action:@selector(chooseAnswerBtnShowType:) accessibilityId:HWMConfSettingAnswerButtonShowType],
                       [ActionModel initWithTitle:@"来电时接听状态(默认、拒接、接听)" action:@selector(chooseInComingCallAnswer:) accessibilityId:HWMConfSettingAcceptIncomingStatus],
                       [ActionModel initWithTitle:@"添加与会者" action:@selector(handleAddAttendees) accessibilityId:HWMConfSettingAddAttendee],
                       [ActionModel initWithTitle:@"离开会议" action:@selector(leaveConf) accessibilityId:HWMConfSettingLeaveConf],
                       [ActionModel initWithTitle:@"结束会议" action:@selector(endConf) accessibilityId:HWMConfSettingEndConf],
                       [ActionModel initWithTitle:@"来电响铃(登录，设置成功后生效)" type:CellTypeRing],
                       [ActionModel initWithTitle:@"来电振动(登录，设置成功后生效)" type:CellTypeVibrate],
                       [ActionModel initWithTitle:@"获取与会者列表" action:@selector(handleGetAttendeeList) accessibilityId:HWMConfSettingGetAttendeeList],
                       [ActionModel initWithTitle:@"获取观众列表" action:@selector(handleGetAudienceList) accessibilityId:HWMConfSettingGetAudienceList],
                       [ActionModel initWithTitle:@"设置会中提示音" action:@selector(settingVoicePrompts)],
                       [ActionModel initWithTitle:@"停止共享" action:@selector(stopShare)],
                       [ActionModel initWithTitle:@"接听来电" action:@selector(acceptConf)],
                       [ActionModel initWithTitle:@"挂断来电" action:@selector(rejectConf)],
                       [ActionModel initWithTitle:@"会议水印控制类型" action:@selector(chooseWatermarkControlOption:)],
                       [ActionModel initWithTitle:@"设置虚拟背景图片" action:@selector(openVirtualBackgroundImagePage)],
    ];
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    TableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.titleLabel.text = model.title;
    [cell setSelectionStyle:UITableViewCellSelectionStyleNone];
    switch (model.type) {
        case CellTypeCustomDeviceStatus:
        {
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].customConfSetting];
            weakify(self)
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                strongify(self)
                [self handleConfSettingCustom:isSelect];
                [self.tableView reloadData];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CellTypeMicStatus:
        {
            cell.selectTypeSwitch.hidden = ![SDKEnvConfig sharedInstance].customConfSetting;
            [cell.selectTypeSwitch setOn:[GlobalHandlerImpl sharedInstance].isOpenMic];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [GlobalHandlerImpl sharedInstance].isOpenMic = isSelect;
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CellTypeCameraStatus:
        {
            cell.selectTypeSwitch.hidden = ![SDKEnvConfig sharedInstance].customConfSetting;
            [cell.selectTypeSwitch setOn:[GlobalHandlerImpl sharedInstance].isOpenCamera];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [GlobalHandlerImpl sharedInstance].isOpenCamera = isSelect;
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CellTypeRing:
        {
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[GlobalHandlerImpl sharedInstance].ringIncoming];
            weakify(self)
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                strongify(self)
                [GlobalHandlerImpl sharedInstance].ringIncoming = isSelect;
                [self changeInComingNotice];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CellTypeVibrate:
        {
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[GlobalHandlerImpl sharedInstance].vibrateIncoming];
            weakify(self)
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                strongify(self)
                [GlobalHandlerImpl sharedInstance].vibrateIncoming = isSelect;
                [self changeInComingNotice];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        default: {
            cell.selectTypeSwitch.hidden = YES;
            cell.accessibilityIdentifier = model.accessibilityId;
        }
            break;
    }
    return cell;
}

/// 会存储个人DB
- (void)changeInComingNotice {
    BOOL result = [[HWMSdk getOpenApi] changeInComingNoticeWithRing:[GlobalHandlerImpl sharedInstance].ringIncoming vibrate:[GlobalHandlerImpl sharedInstance].vibrateIncoming];
    [UIUtil showMessage:result ? @"设置成功" : @"设置失败"];
}

- (void)handleAddAttendees {
    [[HWMSdk getPrivateApi] openContactSelectPage:@[] scene:HWMSelectedContactCreateConf completeHander:^(NSArray<HWMContactSelectedModel *> * _Nonnull result, NSError * _Nonnull error) {
        [self addAttendeeInConf:result];
    }];
}

- (void)addAttendeeInConf:(NSArray<HWMContactSelectedModel *> *)result {
    [[HWMSdk getOpenApi] addAttendee:result completeHandler:^(NSError * _Nullable error, id  _Nullable result) {
        [UIUtil showMessage:@"邀请成功" error:error];
    }];
}

/// 离开会议
- (void)leaveConf {
    [[HWMSdk getOpenApi] leaveConf:^(NSError * _Nullable error, id  _Nullable result) {
        [UIUtil showMessage:@"离开会议" error:error];
    }];
}

/// 结束会议
- (void)endConf {
    [[HWMSdk getOpenApi] endConf:^(NSError * _Nullable error, id  _Nullable result) {
        [UIUtil showMessage:@"结束会议成功" error:error];
    }];
}

- (void)handleGetAttendeeList {
    [self pushAttendeesViewController:ListTypeAttendee];
}

- (void)handleGetAudienceList {
    [self pushAttendeesViewController:ListTypeAudience];
}

- (void)pushAttendeesViewController:(ListType)type {
    AttendeesViewController * vc = [[AttendeesViewController alloc] init];
    vc.type = type;
    [self.navigationController pushViewController:vc animated:YES];
}

- (void)chooseAnswerBtnShowType:(UITableViewCell *)cell {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"视频会议来电时按钮显示状态" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.tableView;
        alertController.popoverPresentationController.sourceRect = cell.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    
    UIAlertAction *allAction = [UIAlertAction actionWithTitle:@"全部显示" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [GlobalHandlerImpl sharedInstance].answerBtnShowType = HWMAnswerBtnShowTypeAll;
    }];
    UIAlertAction *audioAction = [UIAlertAction actionWithTitle:@"只显示语音按钮(仅MCU会议生效)" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [GlobalHandlerImpl sharedInstance].answerBtnShowType = HWMAnswerBtnShowTypeOnlyAudio;
    }];
    UIAlertAction *videoAction = [UIAlertAction actionWithTitle:@"只显示视频按钮" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [GlobalHandlerImpl sharedInstance].answerBtnShowType = HWMAnswerBtnShowTypeOnlyVideo;
    }];
    [alertController addAction:cancelAction];
    [alertController addAction:allAction];
    [alertController addAction:audioAction];
    [alertController addAction:videoAction];
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)chooseInComingCallAnswer:(UITableViewCell *)cell {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"会议来电自动处理" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.tableView;
        alertController.popoverPresentationController.sourceRect = cell.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    
    UIAlertAction *allAction = [UIAlertAction actionWithTitle:@"默认" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [GlobalHandlerImpl sharedInstance].inComingAnswerType = HWMIncomingAnswerNormal;
    }];
    UIAlertAction *audioAction = [UIAlertAction actionWithTitle:@"自动拒绝来电" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [GlobalHandlerImpl sharedInstance].inComingAnswerType = HWMIncomingAnswerAutoDecline;
    }];
    UIAlertAction *videoAction = [UIAlertAction actionWithTitle:@"自动接听来电" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [GlobalHandlerImpl sharedInstance].inComingAnswerType = HWMIncomingAnswerAutoAnswer;
    }];
    UIAlertAction *customAction = [UIAlertAction actionWithTitle:@"自定义来电弹窗" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [GlobalHandlerImpl sharedInstance].inComingAnswerType = HWMInComingAnswerCustom;
    }];
    [alertController addAction:cancelAction];
    [alertController addAction:allAction];
    [alertController addAction:audioAction];
    [alertController addAction:videoAction];
    [alertController addAction:customAction];
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)handleConfSettingCustom:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].customConfSetting = isOn;
    [HWMSdk getSdkConfig].confSettingHandler = isOn ? [GlobalHandlerImpl sharedInstance] : nil;
}

- (void)settingVoicePrompts {
    VoiceViewController *vc = [[VoiceViewController alloc] init];
    [self.navigationController pushViewController:vc animated:YES];
}

- (void)stopShare {
    [[HWMBizSdk getBizOpenApi] stopShare:@""];
}

- (void)acceptConf {
    [self pushViewControllerWithVcString:@"AcceptConfViewController"];
}

- (void)rejectConf {
    [[HWMSdk getOpenApi] rejectConf:^(NSError * _Nullable error, id  _Nullable result) {
        if (error) {
            [UIUtil showMessage:@"挂断来电失败" error:error];
        }
    }];
}

- (void)chooseWatermarkControlOption:(UITableViewCell *)cell {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"会议水印控制类型" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.tableView;
        alertController.popoverPresentationController.sourceRect = cell.frame;
    }
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    
    UIAlertAction *allAction = [UIAlertAction actionWithTitle:@"默认" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [GlobalHandlerImpl sharedInstance].watermarkControlOption = HWMWatermarkControlOptionNormal;
    }];
    UIAlertAction *audioAction = [UIAlertAction actionWithTitle:@"强制开" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [GlobalHandlerImpl sharedInstance].watermarkControlOption = HWMWatermarkControlOptionForceOn;
    }];
    UIAlertAction *videoAction = [UIAlertAction actionWithTitle:@"强制关" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [GlobalHandlerImpl sharedInstance].watermarkControlOption = HWMWatermarkControlOptionForceOff;
    }];
    [alertController addAction:cancelAction];
    [alertController addAction:allAction];
    [alertController addAction:audioAction];
    [alertController addAction:videoAction];
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)openVirtualBackgroundImagePage {
    [self pushViewControllerWithVcString:@"VirtualBackgroundViewController"];
}

@end
