//
//  VirtualBackgroundViewController.m
//  HWMSDKDemo
//
//  Created by yaolili/ywx577644 on 2022/5/11.
//  Copyright © 2022 HuaWei. All rights reserved.
//

#import "VirtualBackgroundViewController.h"
#import "HWMVirtualBackgroundImageConfig.h"

@interface VirtualBackgroundViewController ()

@property (weak, nonatomic) IBOutlet UISwitch *allowCustomSwitch;
@property (weak, nonatomic) IBOutlet UILabel *modeLable;
@property (weak, nonatomic) IBOutlet UIButton *addButton;
@property (weak, nonatomic) IBOutlet UIButton *replaceButton;

@property (nonatomic, assign) HWMSettingVBDefaultImageMode mode;
@property (nonatomic, assign) BOOL switchIsOn;

@end

@implementation VirtualBackgroundViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.mode = HWMSettingVBDefaultImageModeReplaceAll;
    self.switchIsOn = YES;
    [self.allowCustomSwitch setOn:self.switchIsOn];
}

- (IBAction)addAction:(UIButton *)sender {
    self.modeLable.text = @"追加";
    self.mode = HWMSettingVBDefaultImageModeAppend;
}

- (IBAction)replaceAction:(UIButton *)sender {
    self.modeLable.text = @"替换";
    self.mode = HWMSettingVBDefaultImageModeReplaceAll;
}

- (IBAction)saveAction:(UIButton *)sender {
    NSInteger count = 5;
    NSMutableArray<NSString *> *subPathArr = [NSMutableArray array];
    for (int i = 1; i <= count; i++) {
        NSString *path = [[NSBundle mainBundle] pathForResource:[NSString stringWithFormat:@"img%d", i] ofType:@"jpeg"];
        NSLog(@"path %@", path);
        if (path && path.length > 0) {
            [subPathArr addObject:path];
        }
    }
    
    NSMutableArray<HWMVirtualBackgroundImageModel *> *images = [NSMutableArray array];
    [subPathArr enumerateObjectsUsingBlock:^(NSString * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        HWMVirtualBackgroundImageModel *model1 = [[HWMVirtualBackgroundImageModel alloc] init];
        model1.imagePath = obj;
        [images addObject:model1];
    }];
    
    HWMVirtualBackgroundImageConfig *config = [[HWMVirtualBackgroundImageConfig alloc] init];
    config.imageInfos = [images copy];
    config.imageMode = self.mode;
    config.allowCustomVirtualBackgroundImage = self.switchIsOn;
        
    [[HWMSdk getOpenApi] setVirtualBackgroundDefaultImages:config];
}

- (IBAction)allowCustomSwitchAction:(UISwitch *)sender {
    self.switchIsOn = sender.isOn;
}


@end
