//
//  HWMVideoConfMenuHandlerImpl.m
//  HWMConfUI
//
//  Created by y00450113 on 2020/7/8.
//  Copyright © 2020 huawei. All rights reserved.
//

#import "VideoConfMenuHandlerImpl.h"
#import "HWMConfMenuListItem.h"
#import "HWMConfSettingGroup.h"
#import "HWMConfToolBarMenuItem.h"
#import "HWMConfSettingItem.h"
@implementation VideoConfMenuHandlerImpl
/// 构建视频会议底部toolbar的会控全量菜单
- (NSArray <HWMConfToolBarMenuItem *> *)buildToolBarMenuItems {
    // 麦克风静音 or 取消静音
    HWMConfToolBarMenuItem *micItem = [HWMConfToolBarMenuItem defaultMicItem];
    // 打开 or 关闭摄像头
    HWMConfToolBarMenuItem *videoItem = [HWMConfToolBarMenuItem defaultVideoItem];
    // 屏幕共享开始 or 停止
    HWMConfToolBarMenuItem *screenShareItem = [HWMConfToolBarMenuItem defaultScreenShareItem];
    // 观众观看
    HWMConfToolBarMenuItem *audienceWatch = [HWMConfToolBarMenuItem defaultAudienceWatch];
    // 与会者列表
    HWMConfToolBarMenuItem *attendeeItem = [HWMConfToolBarMenuItem defaultAttendeeItem];
    // 聊天
    HWMConfToolBarMenuItem *chatItem = [HWMConfToolBarMenuItem defaultChatItem];
    // 举手
    HWMConfToolBarMenuItem *handupItem = [HWMConfToolBarMenuItem defaultHandupItem];
    // 投票
    HWMConfToolBarMenuItem *voteItem = [HWMConfToolBarMenuItem defaultVoteItem];
    // 更多
    HWMConfToolBarMenuItem *moreItem = [HWMConfToolBarMenuItem defaultMoreItem];
    return @[micItem, videoItem, screenShareItem, audienceWatch, attendeeItem, chatItem, handupItem, voteItem, moreItem];
}

/// 构建视频会议底部toolbar的“更多”菜单
- (NSArray <HWMConfMenuListItem *> *)buildToolBarMoreMenuItems {
    // 聊天
    HWMConfMenuListItem *chatItem = [HWMConfMenuListItem defaultChatItem];
    // 传译
    HWMConfMenuListItem *interpretItem = [HWMConfMenuListItem defaultInterpretItem];
    // 邀请
    HWMConfMenuListItem *inviteItem = [HWMConfMenuListItem defaultInviteItem];
    //录制
    HWMConfMenuListItem *recordItem = [HWMConfMenuListItem defaultRecordItem];
    //直播
    HWMConfMenuListItem *liveBraodcastItem = [HWMConfMenuListItem defaultLiveBroadcastItem];
    // 举手
    HWMConfMenuListItem *raiseHandsItem = [HWMConfMenuListItem defaultRaiseHandsItem];
    // 投票
    HWMConfMenuListItem *voteItem = [HWMConfMenuListItem defaultVoteItem];
    // 虚拟背景
    HWMConfMenuListItem *backgroundItem = [HWMConfMenuListItem defaultVirtualBackgroundItem];
    // 设置
    HWMConfMenuListItem *settingItem = [HWMConfMenuListItem defaultSettingItem];
    // 改名
    HWMConfMenuListItem *renameItem = [HWMConfMenuListItem defaultRenameItem];
    // 分享
    HWMConfMenuListItem *shareItem = [HWMConfMenuListItem defaultShareItem];
    // 屏幕共享开始 or 停止
    HWMConfMenuListItem *screenShareItem = [HWMConfMenuListItem defaultScreenShareItem];
    // 字幕
    HWMConfMenuListItem *subtitleItem = [HWMConfMenuListItem defaultSubtitleItem];
    return @[screenShareItem, chatItem, interpretItem, inviteItem, recordItem, renameItem, shareItem, subtitleItem, liveBraodcastItem, raiseHandsItem, voteItem, backgroundItem, settingItem];
}

// 构建视频会议点击更多菜单的设置弹出的设置列表项目
- (NSArray <HWMConfSettingGroup *> *)buildSettingItems {
    HWMConfSettingGroup *audioVideoGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"音视频"];
    HWMConfSettingItem *howlItem = [HWMConfSettingItem defaultHowlDetection];
    HWMConfSettingItem *beautyItem = [HWMConfSettingItem defaultBeautyItem];
    HWMConfSettingItem *mirrorItem = [HWMConfSettingItem defaultMirror];
    HWMConfSettingItem *hideSmallViewItem = [HWMConfSettingItem defaultHideSmallVideoItem];
    HWMConfSettingItem *hideFloatMicroButtonItem = [HWMConfSettingItem defaultHideFloatMicroButtonItem];
    HWMConfSettingItem *hdPreferredItem = [HWMConfSettingItem defaultHDPreferred];
    HWMConfSettingItem *enhanceVideoQualityItem = [HWMConfSettingItem defaultEnhanceVideoQuality];
    HWMConfSettingItem *picRatio = [HWMConfSettingItem defaultPictureRatio];
    HWMConfSettingItem *noiseReductionItem = [HWMConfSettingItem defaultNoiseReductionItem];

    audioVideoGroup.items = @[howlItem, beautyItem, mirrorItem, hideSmallViewItem, hideFloatMicroButtonItem, noiseReductionItem, hdPreferredItem, enhanceVideoQualityItem, picRatio];

    HWMConfSettingGroup *securityGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"入会控制"];
    HWMConfSettingItem *lockItem = [HWMConfSettingItem defaultLockItem];
    HWMConfSettingItem *allowJoinConfItem = [HWMConfSettingItem defaultAllowJoinConf];
    HWMConfSettingItem *waitingRoomItem = [HWMConfSettingItem defaultWaitingRoom];
    HWMConfSettingItem *autoMuteItem = [HWMConfSettingItem defaultAutoMuteItem];
    securityGroup.items = @[lockItem, allowJoinConfItem, waitingRoomItem, autoMuteItem];
    
    HWMConfSettingGroup *infoSecurityGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"信息安全"];
    HWMConfSettingItem *watermarkItem = [HWMConfSettingItem defaultWatermarkItem];
    infoSecurityGroup.items = @[watermarkItem];

    HWMConfSettingGroup *authorityGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"与会者权限"];
    HWMConfSettingItem *allowUnmuteItem = [HWMConfSettingItem defaultAllowAttendeeUnmuteItem];
    HWMConfSettingItem *allowAttendeeAnnotate = [HWMConfSettingItem defaultAllowAttendeeAnnotate];
    HWMConfSettingItem *allowOpenCameraItem = [HWMConfSettingItem defaultAllowAttendeeOpenCameraItem];
    HWMConfSettingItem *cameraPermissionItem = [HWMConfSettingItem defaultCameraPermission];
    HWMConfSettingItem *shareLockItem = [HWMConfSettingItem defaultLockShareItem];
    HWMConfSettingItem *preemptSharePermissionItem = [HWMConfSettingItem defaultPreemptSharePermissionItem];
    HWMConfSettingItem *chatItem = [HWMConfSettingItem defaultAllowChat];
     HWMConfSettingItem *localRecordRightsItem = [HWMConfSettingItem defaultLocalRecordRights];
    HWMConfSettingItem *allowRenameItem = [HWMConfSettingItem defaultAllowRenameItem];
    authorityGroup.items = @[allowUnmuteItem, allowAttendeeAnnotate, allowOpenCameraItem, cameraPermissionItem, shareLockItem, preemptSharePermissionItem, chatItem, allowRenameItem, localRecordRightsItem];

    HWMConfSettingGroup *commonGroup = [[HWMConfSettingGroup alloc] initWithTitle:@"通用"];
    HWMConfSettingItem *networkDetectItem = [HWMConfSettingItem defaultNetworkDetectItem];
    HWMConfSettingItem *feedbackItem = [HWMConfSettingItem defaultFeedbackItem];
    HWMConfSettingItem *chatRemindItem = [HWMConfSettingItem defaultChatRemindItem];
    HWMConfSettingItem *subtitleLanguageItem = [HWMConfSettingItem defaultSubtitleLanguageItem];
    commonGroup.items = @[subtitleLanguageItem, chatRemindItem, networkDetectItem, feedbackItem];
    
    return @[audioVideoGroup, securityGroup, infoSecurityGroup, authorityGroup, commonGroup];
}

@end
