//
//  EnableFeatureViewController.m
//  HWMSDKDemo
//
//  Created by lining on 2025/2/20.
//  Copyright © 2025 HuaWei. All rights reserved.
//

#import "EnableFeatureViewController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "SDKEnvConfig.h"

@interface EnableFeatureViewController ()
@property (weak, nonatomic) IBOutlet UISwitch *breakoutConfSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *recordAlertSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *saveNickNameSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *disconnectAudioSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *virtualBackgroundSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *hideInviteToastSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *hideOfflineParticipantListSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *hideVBRiskTipSwitch;
@property (weak, nonatomic) IBOutlet UISwitch *hideConfEndTipsSwitch;

@end

@implementation EnableFeatureViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.breakoutConfSwitch.on = [SDKEnvConfig sharedInstance].supportBreakoutConf;
    self.recordAlertSwitch.on = [SDKEnvConfig sharedInstance].isShowRecordSafeAlert;
    self.saveNickNameSwitch.on = [SDKEnvConfig sharedInstance].isSaveNickNameWhenAnonymousJoin;
    self.disconnectAudioSwitch.on = [SDKEnvConfig sharedInstance].supportDisconnectAudio;
    self.virtualBackgroundSwitch.on = [SDKEnvConfig sharedInstance].supportVirtualBackground;
    self.hideInviteToastSwitch.on = [SDKEnvConfig sharedInstance].hideInviteResultToast;
    self.hideVBRiskTipSwitch.on = [SDKEnvConfig sharedInstance].isHiddenVBRiskTip;
    self.hideConfEndTipsSwitch.on = [SDKEnvConfig sharedInstance].hideConfEndTips;
}

- (IBAction)enableBreakoutConfFeatureSwitchChanged:(UISwitch *)sender {
    [SDKEnvConfig sharedInstance].supportBreakoutConf = sender.isOn;
    if ([HWMSdk hasInit]) {
        [[HWMSdk getSdkConfig] enableFeature:HWMFeatureTypeBreakoutConf isEnable:sender.isOn];
    }
}

- (IBAction)enableRecordAlertFeatureSwitchChanged:(UISwitch *)sender {
    [SDKEnvConfig sharedInstance].isShowRecordSafeAlert = sender.isOn;
    if ([HWMSdk hasInit]) {
        [[HWMSdk getSdkConfig] enableFeature:HWMFeatureTypeRecoedAlert isEnable:sender.isOn];
    }
}

- (IBAction)enableSaveAnonymousNickNameFeatureSwitchChanged:(UISwitch *)sender {
    [SDKEnvConfig sharedInstance].isSaveNickNameWhenAnonymousJoin = sender.isOn;
    if ([HWMSdk hasInit]) {
        [[HWMSdk getSdkConfig] enableFeature:HWMFeatureTypeSaveNickNameWhenAnonymousJoin isEnable:sender.isOn];
    }
}

- (IBAction)enableSupportDisconectAudioFeatureSwitchChanged:(UISwitch *)sender {
    [SDKEnvConfig sharedInstance].supportDisconnectAudio = sender.isOn;
    if ([HWMSdk hasInit]) {
        [[HWMSdk getSdkConfig] enableFeature:HWMFeatureTypeSupportDisconnectAudio isEnable:sender.isOn];
    }
}

- (IBAction)enableSupportVBFeatureSwitchChanged:(UISwitch *)sender {
    [SDKEnvConfig sharedInstance].supportVirtualBackground = sender.isOn;
    if ([HWMSdk hasInit]) {
        [[HWMSdk getSdkConfig] enableFeature:HWMFeatureTypeSupportVirtualBackground isEnable:sender.isOn];
    }
}

- (IBAction)enableHideInviteResultToastFeatureSwitchChanged:(UISwitch *)sender {
    [SDKEnvConfig sharedInstance].hideInviteResultToast = sender.isOn;
    if ([HWMSdk hasInit]) {
        [[HWMSdk getSdkConfig] enableFeature:HWMFeatureTypeHideInviteResultToast isEnable:sender.isOn];
    }
}

- (IBAction)enableHideOfflineParticipantListSwitchChanged:(UISwitch *)sender {
    [SDKEnvConfig sharedInstance].hideOfflineParticipantList = sender.isOn;
    if ([HWMSdk hasInit]) {
        [[HWMSdk getSdkConfig] enableFeature:HWMFeatureTypeHideOfflineParticipantList isEnable:sender.isOn];
    }
}

- (IBAction)enableHiddenVBRiskTipChangedUISwitchsender:(UISwitch *)sender {
    [SDKEnvConfig sharedInstance].isHiddenVBRiskTip = sender.isOn;
    if ([HWMSdk hasInit]) {
        [[HWMSdk getSdkConfig] enableFeature:HWMFeatureTypeHiddenVBRiskTip isEnable:sender.isOn];
    }
}

- (IBAction)enableHideConfEndTipsChanged:(UISwitch *)sender {
    [SDKEnvConfig sharedInstance].hideConfEndTips = sender.isOn;
    if ([HWMSdk hasInit]) {
        [[HWMSdk getSdkConfig] enableFeature:HWMFeatureTypeConfEndHideTips isEnable:sender.isOn];
    }
}

@end
