//
//  FirstViewController.m
//  HWMSDKDemo
//
//  Created by 融合软终端02 on 2020/2/17.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "FirstViewController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "UIUtil.h"
#import "ShareView.h"
#import "ContactSelectViewController.h"
#import "ActionModel.h"
#import "SDKEnvConfig.h"
#import "AudioCallMenuHandlerImpl.h"
#import "AudioConfMenuHandlerImpl.h"
#import "VideoCallMenuHandlerImpl.h"
#import "VideoConfMenuHandlerImpl.h"
#import "ParticipantListMenuHandlerImpl.h"
#import "ConfTitleBarMenuHandlerImpl.h"
#import "GlobalHandlerImpl.h"
#import "NotifyMessageHandler.h"
#import "SsoLoginViewController.h"
#import "APPIDLoginViewController.h"
#import "CycleConfViewController.h"
#import "PairCodeJoinConfController.h"
#import "RemoteControlPairViewController.h"
#import "LoginManager.h"

@interface FirstViewController ()
@property (nonatomic, strong) AudioCallMenuHandlerImpl *defaultAudioCallImpl;
@property (nonatomic, strong) AudioConfMenuHandlerImpl *defaultAudioConfImpl;
@property (nonatomic, strong) VideoCallMenuHandlerImpl *defaultVideoCallImpl;
@property (nonatomic, strong) VideoConfMenuHandlerImpl *defaultVideoConfImpl;
@property (nonatomic, strong) ParticipantListMenuHandlerImpl *defaultMemberListImpl;
@property (nonatomic, strong) ConfTitleBarMenuHandlerImpl *defaultTitleBarImpl;
@end

@implementation FirstViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupDatas];
    [self setupTableView];
}

- (void)setupDatas {
    self.dataArray = @[[ActionModel initWithTitle:@"初始化(使用所有功能前必须初始化)" actionCtrl:@"InitSDKViewController" accessibilityId:HWMInitSDK],
                       [ActionModel initWithTitle:@"登录"  actionCtrl:@"LoginViewController" accessibilityId:HWMLogin],
                       [ActionModel initWithTitle:@"APPID登录"  actionCtrl:@"APPIDLoginViewController" accessibilityId:HWMAppIDLogin],
                       [ActionModel initWithTitle:@"sso登录" action:@selector(ssoLogin) accessibilityId:HWMSsoLogin],
                       [ActionModel initWithTitle:@"nonce登录" action:@selector(nonceLogin) accessibilityId:HWMNonceLogin],
                       [ActionModel initWithTitle:@"创建会议"  actionCtrl:@"CreateMeetingViewController" accessibilityId:HWMCreatConf],
                       [ActionModel initWithTitle:@"加入会议" actionCtrl:@"JoinMeetingViewController" accessibilityId:HWMJoinConf],
                       [ActionModel initWithTitle:@"立即会议" actionCtrl:@"P2PConfViewController" accessibilityId:HWMCall],
                       [ActionModel initWithTitle:@"登出" action:@selector(logout) accessibilityId:HWMLogout],
                       [ActionModel initWithTitle:@"全局配置" actionCtrl:@"GlobalConfigViewController" accessibilityId:HWMGlobalConfig],
                       [ActionModel initWithTitle:@"会议信息" actionCtrl:@"ConfInfoViewController" accessibilityId:HWMConfRelative],
                       [ActionModel initWithTitle:@"链接拉起入会" actionCtrl:@"SchemeLinkChooseViewController" accessibilityId:HWMSchemeLink],
                       [ActionModel initWithTitle:@"会议设置" actionCtrl:@"ConfSettingViewController" accessibilityId:HWMConfSetting],
                       [ActionModel initWithTitle:@"预约会议" actionCtrl:@"BookConfViewController" accessibilityId:HWMBookConf],
                       [ActionModel initWithTitle:@"预约周期会议" actionCtrl:@"CycleConfViewController" accessibilityId:HWMBookCycleConf],
                       [ActionModel initWithTitle:@"取消会议" actionCtrl:@"CancelConfViewController" accessibilityId:HWMCancelConf],
                       [ActionModel initWithTitle:@"会议列表" actionCtrl:@"ConfListViewController" accessibilityId:HWMConfList],
                       [ActionModel initWithTitle:@"虚拟会议室列表" actionCtrl:@"VmrListViewController" accessibilityId:HWMVmrList],
                       [ActionModel initWithTitle:@"配对码入会" actionCtrl:@"PairCodeJoinConfController" accessibilityId:HWMPairCodeJoin],
                       [ActionModel initWithTitle:@"控制器配对"  action:@selector(openRoomsControllerPage) accessibilityId:HWMRoomsController],
                       [ActionModel initWithTitle:@"显示会议主窗口"  action:@selector(showMeetingWindow) accessibilityId:HWMShowMeetingWindow],
                       [ActionModel initWithTitle:@"开启特性"  actionCtrl:@"EnableFeatureViewController" accessibilityId:HWMEnableFeature],
                       [ActionModel initWithTitle:@"会控" actionCtrl:@"ConfControlViewController"]
    ];
    self.defaultAudioCallImpl = [[AudioCallMenuHandlerImpl alloc] init];
    self.defaultAudioConfImpl = [[AudioConfMenuHandlerImpl alloc] init];
    self.defaultVideoCallImpl = [[VideoCallMenuHandlerImpl alloc] init];
    self.defaultVideoConfImpl = [[VideoConfMenuHandlerImpl alloc] init];
    self.defaultMemberListImpl = [[ParticipantListMenuHandlerImpl alloc] init];
    self.defaultTitleBarImpl = [[ConfTitleBarMenuHandlerImpl alloc] init];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    TableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    [cell setSelectionStyle:UITableViewCellSelectionStyleDefault];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.titleLabel.text = model.title;
    cell.selectTypeSwitch.hidden = YES;
    cell.accessibilityIdentifier = model.accessibilityId;
    return cell;
}

/// sso登录
- (void)ssoLogin {
    SsoLoginViewController *ssoLoginVc = [[SsoLoginViewController alloc] initWithNibName:@"SsoLoginViewController" bundle:[NSBundle mainBundle]];
    [self.navigationController pushViewController:ssoLoginVc animated:YES];
}

/// nonce登录
- (void)nonceLogin {
    APPIDLoginViewController * vc = [[APPIDLoginViewController alloc] init];
    vc.isGetNonce = YES;
    vc.isNonceLogin = YES;
    [self.navigationController pushViewController:vc animated:YES];
}

/// 退出登录
- (void)logout {
    if (![HWMSdk hasInit]) {
        [UIUtil showMessage:@"请先初始化"];
        return;
    }
    [self showLoading];
    [[HWMSdk getOpenApi] logout:^(NSError * _Nullable error, HWMLogoutResult * _Nullable result) {
        [self hideLoading];
        NSString *msg;
        if (error) {
            msg = [NSString stringWithFormat:@"登出失败:%zd %@", error.code, error.localizedDescription];
        } else {
            [[LoginManager sharedInstance] updateHasLogin:NO];
            msg = [NSString stringWithFormat:@"登出成功\nuuid:%@\naccount:%@\nthirdAccount:%@", result.userUuid, result.account, result.thirdAccount];
        }
        [UIUtil showMessage:msg vc:self];
    }];
}

- (void)openRoomsControllerPage {
    RemoteControlPairViewController *ctrl = [[RemoteControlPairViewController alloc] initWithNibName:@"RemoteControlPairViewController" bundle:[NSBundle mainBundle]];
    [self.navigationController pushViewController:ctrl animated:YES];
}

- (void)showMeetingWindow {
    [[HWMBizSdk getBizOpenApi] showMeetingWindow];
}

@end
