//
//  GlobalConfigViewController.m
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/7/4.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "GlobalConfigViewController.h"
#import "UIUtil.h"
#import <HWMUISDK/HWMUISDK.h>
#import "SDKEnvConfig.h"
#import "GlobalHandlerImpl.h"
#import "HWMSDKNetworkService.h"
#import "AutomateIDConstant.h"

typedef NS_ENUM(NSInteger, CellType) {
    CellTypeSiteType,
    CellTypeLaunchMode,
    CellTypeHideOfflineMember,
    CellTypeHideExternalLabel,              // 设置是否隐藏外部标签
    CellTypeSetAppId,                       // 设置AppId
    CustomUITypeConfSocialShareIntercept,   // 与会者列表右上角分享后，弹出的分享页面拦截
    CustomUITypeConfSelectContactIntercept, // 会中选择联系人页面拦截
    CustomUITypeConfContactHeadPortrait,    // 会中联系人头像
    CustomUITypeConfContactUpdateHeadImage, // 上传个人头像
    CustomUITypeConfSetNetworkMode,         // 设置网络模式
    CustomUITypeConfShareScreenPermission,  // 屏幕共享权限
    CustomUITypeGuaranteeIpAddrs,           // 设置(会控)保底IP
    CustomUITypeSetExtensionBundleId,       // 设置Extension BundleId
    CustomUITypeSetAllowMeetingUt,          // 关闭SDK日志自动收集与上报会中打点
    CustomUITypeCustomText,                 // 自定义场景文案
    CustomUITypeVirtualBackground,          // 虚拟背景添加自定义图片
    CustomUITypeCustomImage,                // 自定义场景图片
    CustomUITypeCustomCallOtherNumber,      // 自定义呼叫其他号码
    CustomUITypeSetGlobalGuaranteedIpAddrs, // 设置(管理面)保底ip
    CustomUITypeInterruptShare,             // 拦截共享
    CustomUITypeSetAvatarStyle,             // 设置默认头像风格
    CustomUITypeConfQueryContactIntercept,  // 会中查询联系人信息拦截
};

@interface GlobalConfigViewController ()

@end

@implementation GlobalConfigViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupDatas];
    [self setupTableView];
}

- (void)setupDatas{
    self.dataArray = @[[ActionModel initWithTitle:@"是否为中国站点" type:CellTypeSiteType],
                       [ActionModel initWithTitle:@"是否使用push方式加载" type:CellTypeLaunchMode],
                       [ActionModel initWithTitle:@"是否隐藏不在线的与会者" type:CellTypeHideOfflineMember accessibilityId:HWMGlobalConfigHideOfflineParticipant],
                       [ActionModel initWithTitle:@"是否隐藏外部标签" type:CellTypeHideExternalLabel accessibilityId:HWMGlobalConfigHideExternalLabel],
                       [ActionModel initWithTitle:@"设置AppId" type:CellTypeSetAppId],
                       [ActionModel initWithTitle:@"拦截会中分享页面" type:CustomUITypeConfSocialShareIntercept accessibilityId:HWMGlobalConfigSocialShareIntercept],
                       [ActionModel initWithTitle:@"拦截选择联系人页面" type:CustomUITypeConfSelectContactIntercept accessibilityId:HWMGlobalConfigSelectContactIntercept],
                       [ActionModel initWithTitle:@"定制会中联系人头像" type:CustomUITypeConfContactHeadPortrait],
                       [ActionModel initWithTitle:@"上传联系人头像" type:CustomUITypeConfContactUpdateHeadImage],
                       [ActionModel initWithTitle:@"设置网络模式" type:CustomUITypeConfSetNetworkMode],
                       [ActionModel initWithTitle:@"设置共享权限" type:CustomUITypeConfShareScreenPermission accessibilityId:HWMGlobalConfigShareScreenPermission],
                       [ActionModel initWithTitle:@"设置(会控)保底IP" type:CustomUITypeGuaranteeIpAddrs],
                       [ActionModel initWithTitle:@"设置Extension BundleId" type:CustomUITypeSetExtensionBundleId],
                       [ActionModel initWithTitle:@"关闭SDK日志自动收集与上报会中打点" type:CustomUITypeSetAllowMeetingUt],
                       [ActionModel initWithTitle:@"自定义场景文案" type:CustomUITypeCustomText],
                       [ActionModel initWithTitle:@"拦截虚拟背景添加自定义图片" type:CustomUITypeVirtualBackground],
                       [ActionModel initWithTitle:@"自定义场景图片" type:CustomUITypeCustomImage],
                       [ActionModel initWithTitle:@"自定义呼叫其他号码" type:CustomUITypeCustomCallOtherNumber],
                       [ActionModel initWithTitle:@"设置(管理面)保底IP" type:CustomUITypeSetGlobalGuaranteedIpAddrs],
                       [ActionModel initWithTitle:@"拦截共享" type:CustomUITypeInterruptShare],
                       [ActionModel initWithTitle:@"设置默认头像风格" type:CustomUITypeSetAvatarStyle],
                       [ActionModel initWithTitle:@"拦截查询联系人信息" type:CustomUITypeConfQueryContactIntercept],
    ];
}


-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    TableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    [cell setSelectionStyle:UITableViewCellSelectionStyleDefault];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.titleLabel.text = model.title;
    switch (model.type) {
        case CellTypeSiteType:
        {
            [cell setSelectionStyle:UITableViewCellSelectionStyleNone];
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].isChinaSite];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [SDKEnvConfig sharedInstance].isChinaSite = isSelect;
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CellTypeLaunchMode:
        {
            [cell setSelectionStyle:UITableViewCellSelectionStyleNone];
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].usePushLaunch];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [SDKEnvConfig sharedInstance].usePushLaunch = isSelect;
                [HWMSdk getSdkConfig].ctrlLaunchMode = isSelect?HWMSdkCtrlLaunchModePush:HWMSdkCtrlLaunchModePresent;
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CellTypeHideOfflineMember:
        {
            [cell setSelectionStyle:UITableViewCellSelectionStyleNone];
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].hideOfflineMembers];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [HWMSdk getSdkConfig].hideOfflineParticipant = isSelect;
                [SDKEnvConfig sharedInstance].hideOfflineMembers = isSelect;
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CellTypeHideExternalLabel:
        {
            [cell setSelectionStyle:UITableViewCellSelectionStyleNone];
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].isHideExternalLabel];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [HWMSdk getSdkConfig].hideExternalLabel = isSelect;
                [SDKEnvConfig sharedInstance].isHideExternalLabel = isSelect;
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeConfSelectContactIntercept:
        {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].customContact];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [self handleContantCustom:isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeConfSocialShareIntercept:
        {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].customSocialShare];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [self handleSocialShareCustom:isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeConfContactHeadPortrait:
        {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].contactHeadPortrait];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [self handleContactHeadPortraitCustom:isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeConfShareScreenPermission:
        {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].enableScreenSharePermission];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [self handleScreenSharePermission:isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeSetAllowMeetingUt:
        {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [[HWMBizSdk getBizOpenApi] setAllowMeetingUt:!isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeCustomText: {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            cell.selectTypeSwitch.on = [SDKEnvConfig sharedInstance].customText;
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [self handleCustomText:isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeCustomImage: {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            cell.selectTypeSwitch.on = [SDKEnvConfig sharedInstance].customImage;
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [self handleCustomImage:isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeVirtualBackground:
        {
            [cell setSelectionStyle:UITableViewCellSelectionStyleNone];
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].customVirtualBackground];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [self handleVirtualBackgroundCustom:isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeCustomCallOtherNumber:
        {
            [cell setSelectionStyle:UITableViewCellSelectionStyleNone];
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].customCallOtherNumber];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [self handleCustomCallOtherNumber:isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeInterruptShare:
        {
            [cell setSelectionStyle:UITableViewCellSelectionStyleNone];
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].interceptShare];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [self handleInterruptShare:isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        case CustomUITypeConfQueryContactIntercept:
        {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:[SDKEnvConfig sharedInstance].customQueryContact];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                [self handleQueryContantCustom:isSelect];
            };
            cell.selectTypeSwitch.accessibilityIdentifier = model.accessibilityId;
        }
            break;
        default: {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = YES;
            cell.accessibilityIdentifier = model.accessibilityId;
        }
            break;
    }
    return cell;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    ActionModel *model = self.dataArray[indexPath.row];
    switch (model.type) {
        case CustomUITypeConfContactHeadPortrait: {
            if ([SDKEnvConfig sharedInstance].contactHeadPortrait) {
                [self pushViewControllerWithVcString:@"SelectHeadPortraitViewController"];
            }
        }
            break;
        case CustomUITypeConfContactUpdateHeadImage:
        {
            [self pushViewControllerWithVcString:@"SelectHeadPortraitViewController"];
        }
            break;
        case CellTypeSetAppId: {
            [self pushViewControllerWithVcString:@"SetAPPIDViewController"];
        }
            break;
        case CustomUITypeConfSetNetworkMode: {
            [self chooseNetworkMode:[tableView cellForRowAtIndexPath:indexPath]];
        }
            break;
        case CustomUITypeGuaranteeIpAddrs: {
            [self pushViewControllerWithVcString:@"SetGuaranteeIpAddrsViewController"];
        }
            break;
        case CustomUITypeSetExtensionBundleId: {
            [self pushViewControllerWithVcString:@"SetExtensionBundleIdViewController"];
        }
            break;
        case CustomUITypeCustomText: {
            [self pushViewControllerWithVcString:@"CustomTextViewController"];
        }
            break;
        case CustomUITypeSetGlobalGuaranteedIpAddrs: {
            [self pushViewControllerWithVcString:@"SetGlobalGuaranteeIpAddrsViewController"];
        }
            break;
        case CustomUITypeSetAvatarStyle: {
            [self pushViewControllerWithVcString:@"SetAvatarStyleViewController"];
        }
            break;
        default:
            break;
    }
}

- (void)handleContantCustom:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].customContact = isOn;
    [HWMSdk getSdkConfig].contactUIHandler = isOn ? [GlobalHandlerImpl sharedInstance] : nil;
}

- (void)handleSocialShareCustom:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].customSocialShare = isOn;
    [HWMSdk getSdkConfig].socialShareHandler = isOn ? [GlobalHandlerImpl sharedInstance] : nil;
}

- (void)handleContactHeadPortraitCustom:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].contactHeadPortrait = isOn;
    [HWMSdk getSdkConfig].headPortraitApiHandler = isOn ? [GlobalHandlerImpl sharedInstance] : nil;
}

- (void)handleScreenSharePermission:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].enableScreenSharePermission = isOn;
    [[HWMSdk getOpenApi] setShareScreenPermission:isOn];
}

- (void)chooseNetworkMode:(UITableViewCell *)cell {
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"设置网络模式" message:nil preferredStyle:UIAlertControllerStyleActionSheet];
    if (Is_Ipad) {
        alertController.popoverPresentationController.sourceView = self.tableView;
        alertController.popoverPresentationController.sourceRect = cell.frame;
    }
    UIAlertAction *normal = [UIAlertAction actionWithTitle:@"默认" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self handleNetworkMode:HWMSDKAccessTypeAuto];
    }];
    UIAlertAction *inner = [UIAlertAction actionWithTitle:@"公司内网接入" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self handleNetworkMode:HWMSDKAccessTypeInner];
    }];
    UIAlertAction *outer = [UIAlertAction actionWithTitle:@"公司外网接入" style:UIAlertActionStyleDefault handler:^(UIAlertAction * _Nonnull action) {
        [self handleNetworkMode:HWMSDKAccessTypeOuter];
    }];
    UIAlertAction *cancel = [UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:nil];
    
    [alertController addAction:normal];
    [alertController addAction:inner];
    [alertController addAction:outer];
    [alertController addAction:cancel];
    [self presentViewController:alertController animated:YES completion:nil];
}

- (void)handleNetworkMode:(HWMNetworkAccessType)type {
    [SDKEnvConfig sharedInstance].accessType = type;
    HWMSDKNetWorkModeInfoModel *networkInfo = [[HWMSDKNetWorkModeInfoModel alloc] init];
    networkInfo.accessType = type;
    HWMSDKERR ret = [[HWMSDKNetworkService shareInstance] setNetworkModeWithNetworkInfo:networkInfo];
    NSLog(@"set network mode, error: %ld", (long)ret);
}

- (void)handleVirtualBackgroundCustom:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].customVirtualBackground = isOn;
    [HWMSdk getSdkConfig].virtualBackgroundHandler = isOn ? [GlobalHandlerImpl sharedInstance].defaultVirtualBackgroundImpl : nil;
}

- (void)handleCustomText:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].customText = isOn;
    [HWMSdk getSdkConfig].customUITextHandler = isOn ? [GlobalHandlerImpl sharedInstance] : nil;
}

- (void)handleCustomImage:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].customImage = isOn;
    [HWMSdk getSdkConfig].customImageHandler = isOn ? [GlobalHandlerImpl sharedInstance] : nil;
}

- (void)handleCustomCallOtherNumber:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].customCallOtherNumber = isOn;
    [HWMSdk getSdkConfig].callOtherNumberHandler = isOn ? [GlobalHandlerImpl sharedInstance] : nil;
}

- (void)handleInterruptShare:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].interceptShare = isOn;
    [HWMSdk getSdkConfig].shareInterceptHandler = isOn ? [GlobalHandlerImpl sharedInstance] : nil;
}

- (void)handleQueryContantCustom:(BOOL)isOn {
    [SDKEnvConfig sharedInstance].customQueryContact = isOn;
    [HWMSdk getSdkConfig].contactApiHandler = isOn ? [GlobalHandlerImpl sharedInstance] : nil;
}

@end
