//
//  SetGlobalGuaranteeIpAddrsViewController.m
//  HWMSDKDemo
//
//  Created by lining on 2025/2/10.
//  Copyright © 2025 HuaWei. All rights reserved.
//

#import "SetGlobalGuaranteeIpAddrsViewController.h"
#import <HWMUISDK/HWMBizSdk.h>

@interface SetGlobalGuaranteeIpAddrsViewController ()

/// 域名输入框
@property (nonatomic, strong) UITextField *domainTextField;
/// 保底IP输入框
@property (nonatomic, strong) UITextField *guaranteeIpAddrsTextField;
/// 保底ip
@property (nonatomic, strong) NSMutableArray<HWMSDKGuaranteedIpAddressModel *> *ipAddrs;

@end

@implementation SetGlobalGuaranteeIpAddrsViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"设置(管理面)保底IP";
    self.ipAddrs = [[NSMutableArray alloc] init];
}

- (void)setupViews {
    [super setupViews];
    
    self.domainTextField = [[UITextField alloc] init];
    self.domainTextField.placeholder = @"请输入域名";
    self.domainTextField.backgroundColor = HexColor(0xf2f2f2);
    
    UILabel *contentLabel = [[UILabel alloc] init];
    contentLabel.text = @"保底IP:用分号隔开, 最多支持4个地址";

    self.guaranteeIpAddrsTextField = [[UITextField alloc] init];
    self.guaranteeIpAddrsTextField.placeholder = @"请输入(管理面)保底IP";
    self.guaranteeIpAddrsTextField.backgroundColor = HexColor(0xf2f2f2);
    
    UIButton *nextButton = [UIButton newButtonWithTitle:@"下一组"];
    [nextButton addTarget:self action:@selector(next) forControlEvents:UIControlEventTouchUpInside];
    
    UIButton *setGuaranteeIpAddrsBtn = [UIButton newButtonWithTitle:@"设置(管理面)保底IP"];
    [setGuaranteeIpAddrsBtn addTarget:self action:@selector(handelSetGlobalGuaranteeIpAddrs) forControlEvents:UIControlEventTouchUpInside];
    
    UIStackView *stackView = [[UIStackView alloc] init];
    stackView.spacing = 10.0;
    stackView.axis = UILayoutConstraintAxisVertical;
    stackView.distribution = UIStackViewDistributionFillEqually;

    [stackView addArrangedSubview:self.domainTextField];
    [stackView addArrangedSubview:contentLabel];
    [stackView addArrangedSubview:self.guaranteeIpAddrsTextField];
    [stackView addArrangedSubview:nextButton];
    [stackView addArrangedSubview:setGuaranteeIpAddrsBtn];
    [self.view addSubview:stackView];
    [stackView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.view).mas_offset(150);
        make.left.mas_equalTo(50);
        make.right.mas_equalTo(-50);
        make.height.mas_equalTo(250);
    }];
}

- (void)next {
    if (self.domainTextField.text == 0) {
        [UIUtil showMessage:@"域名不能为空" vc:self];
        return;
    }
    
    if (self.guaranteeIpAddrsTextField.text == 0) {
        [UIUtil showMessage:@"保底ip不能为空" vc:self];
        return;
    }
    
    HWMSDKGuaranteedIpAddressModel *param = [[HWMSDKGuaranteedIpAddressModel alloc] init];
    param.domain = self.domainTextField.text;
    param.guaranteedIps = self.guaranteeIpAddrsTextField.text;
    [self.ipAddrs addObject:param];
    
    self.domainTextField.text = @"";
    self.guaranteeIpAddrsTextField.text = @"";
}

/// 设置保底IP
- (void)handelSetGlobalGuaranteeIpAddrs {
    if (self.domainTextField.text == 0) {
        [UIUtil showMessage:@"域名不能为空" vc:self];
        return;
    }
    
    if (self.guaranteeIpAddrsTextField.text == 0) {
        [UIUtil showMessage:@"保底ip不能为空" vc:self];
        return;
    }
    HWMSDKGuaranteedIpAddressModel *param = [[HWMSDKGuaranteedIpAddressModel alloc] init];
    param.domain = self.domainTextField.text;
    param.guaranteedIps = self.guaranteeIpAddrsTextField.text;
    [self.ipAddrs addObject:param];
    HWMSDKERR result = [[HWMBizSdk getBizOpenApi] setGlobalGuaranteedIpAddresses:self.ipAddrs];
    NSString *tip = @"设置成功";
    if (result != HWMSDKSdkerrSuccess) {
        tip = [NSString stringWithFormat:@"设置失败[%ld]",result];
    }
    [UIUtil showMessage:tip];
}

@end
