//
//  VoiceViewController.m
//  HWMSDKDemo
//
//  Created by yaolili/ywx577644 on 2022/5/25.
//  Copyright © 2022 HuaWei. All rights reserved.
//

#import "VoiceViewController.h"
#import "HWMSDKVoicePromptsModel.h"

typedef NS_ENUM(NSInteger, CellType) {
    MuteCell,// 语音提示
    SaveCell
};

@interface VoiceViewController ()

@property (nonatomic, strong) HWMSDKVoicePromptsModel *model;

@end

@implementation VoiceViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupDatas];
    [self setupTableView];
}

- (void)setupDatas{
    self.model = [[HWMSDKVoicePromptsModel alloc] init];
    self.model.disableMutePrompt = NO;
    self.dataArray = @[
        [ActionModel initWithTitle:@"开启静音/取消静音提示语" type:MuteCell],
        [ActionModel initWithTitle:@"保存" type:SaveCell]
    ];
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath{
    TableViewCell * cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    [cell setSelectionStyle:UITableViewCellSelectionStyleDefault];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.titleLabel.text = model.title;
    switch (model.type) {
        case MuteCell:
        {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = NO;
            [cell.selectTypeSwitch setOn:!self.model.disableMutePrompt];
            cell.selectSwitchBlock = ^(BOOL isSelect) {
                self.model.disableMutePrompt = !isSelect;
            };
        }
            break;
        case SaveCell: {
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            cell.selectTypeSwitch.hidden = YES;
        }
            break;
        default:
            break;
    }
    return cell;
}
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    ActionModel *model = self.dataArray[indexPath.row];
    switch (model.type) {
        case SaveCell:{
            [self save];
        }
            break;
            
        default:
            break;
    }
}

- (void)save {
    HWMSDKERR ret = [[HWMBizSdk getBizOpenApi] disableVoicePrompts:self.model];
    NSString *string = @"设置成功";
    if (ret != HWMSDKSdkerrSuccess) {
        string = [NSString stringWithFormat:@"设置失败：%ld", ret];
    }
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"提示" message:string preferredStyle:UIAlertControllerStyleAlert];
    UIAlertAction *okAction = [UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleDefault handler:nil];
    [alertController addAction:okAction];
    [self presentViewController:alertController animated:YES completion:nil];
}

@end
