//
//  SetLogPathViewController.m
//  HWMSDKDemo
//
//  Created by 204053 on 2023/7/26.
//  Copyright © 2023 HuaWei. All rights reserved.
//

#import "SetLogPathViewController.h"
#import "SDKEnvConfig.h"

@interface SetLogPathViewController ()

@property (weak, nonatomic) IBOutlet UITextField *logPathTextField;
@property (weak, nonatomic) IBOutlet UIButton *saveBtn;
@property (weak, nonatomic) IBOutlet UILabel *sandboxPathTextLabel;

@end

@implementation SetLogPathViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    if (![HWMSdk hasInit]) {
        [UIUtil showMessage:@"请先初始化SDK"];
    } else {
        if ([HWMSdk getSdkConfig].logPath.length > 0) {
            self.sandboxPathTextLabel.text = [HWMSdk getSdkConfig].logPath;
        } else {
            self.sandboxPathTextLabel.text = [[NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES) firstObject] stringByAppendingPathComponent:@"log"];
        }
    }
}
- (IBAction)saveLogPath:(UIButton *)sender {
    NSString *logPath = self.logPathTextField.text;
    if ([HWMSdk hasInit]) {
        logPath = [[NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES) firstObject] stringByAppendingPathComponent:logPath];
        [HWMSdk setLogPath:logPath];
        [SDKEnvConfig sharedInstance].logPath = logPath;
        self.sandboxPathTextLabel.text = logPath;
        [UIUtil showMessage:@"保存成功"];
    } else {
        [UIUtil showMessage:@"请先初始化SDK"];
    }
}

@end
