//
//  SDKEnvConfig.m
//  HWMSDKDemo
//
//  Created by y00450113 on 2020/7/4.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "SDKEnvConfig.h"

@implementation SDKEnvConfig
+ (instancetype)sharedInstance
{
    static SDKEnvConfig *instance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        instance = [[self alloc] init];
        instance.isChinaSite = YES;
        instance.isHideExternalLabel = NO;
        NSString * path = [[NSBundle bundleForClass:[self class]] pathForResource:@"HWMUISDKDemoConfig" ofType:@"plist"];
        NSMutableDictionary * dic = [[NSMutableDictionary alloc] initWithContentsOfFile:path];
        // 请将AppID替换为您已申请到的AppID
        instance.appId = [dic valueForKey:@"AppId"];
        instance.enableScreenSharePermission = YES;
        instance.supportBreakoutConf = YES;
        instance.supportVirtualBackground = YES;
    });
    return instance;
}

- (void)setLogPath:(NSString *)logPath {
    if (logPath && logPath.length > 0) {
        [[NSUserDefaults standardUserDefaults] setObject:logPath forKey:@"logPath"];
    } else {
        NSLog(@"logPath is nil or empty string");
    }
}

- (NSString *)logPath {
    // 按天
//    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
//    formatter.dateFormat = @"YYYYMMdd";
//    NSDate *today = [NSDate date];
//    NSString *logPath = [formatter stringFromDate:today];
//    logPath = [[NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES) firstObject] stringByAppendingPathComponent:logPath];

    // 或配置文件
    return [[NSUserDefaults standardUserDefaults] objectForKey:@"logPath"];
}

@end
