//
//  SchemeLinkChooseViewController.m
//  HWMSDKDemo
//
//  Created by guoyongliang/gwx917154 on 2021/6/7.
//  Copyright © 2021 HuaWei. All rights reserved.
//

#import "SchemeLinkChooseViewController.h"
#import "SchemeLinkViewController.h"
#import "APPIDLoginViewController.h"

@interface SchemeLinkChooseViewController ()

@end

@implementation SchemeLinkChooseViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupDatas];
    [self setupTableView];
}

- (void)setupDatas {
    self.dataArray = @[
        [ActionModel initWithTitle:@"链接拉起入会" action:@selector(pushSchemeLinkNotNeedNonce)],
        [ActionModel initWithTitle:@"链接拉起入会(nonce)" action:@selector(pushSchemeLinkNeedNonce)],
    ];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    TableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"TableViewCell"];
    [cell setSelectionStyle:UITableViewCellSelectionStyleDefault];
    ActionModel *model = self.dataArray[indexPath.row];
    cell.titleLabel.text = model.title;
    cell.selectTypeSwitch.hidden = YES;
    return cell;
}

- (void)pushSchemeLinkNotNeedNonce {
    SchemeLinkViewController * vc = [[SchemeLinkViewController alloc] init];
    [self.navigationController pushViewController:vc animated:YES];
}

- (void)pushSchemeLinkNeedNonce {
    APPIDLoginViewController * vc = [[APPIDLoginViewController alloc] init];
    vc.isGetNonce = YES;
    [self.navigationController pushViewController:vc animated:YES];
}

@end
