//
//  ShowError.m
//  HWMSDKDemo
//
//  Created by adminstrator on 2020/4/1.
//  Copyright © 2020 HuaWei. All rights reserved.
//

#import "UIUtil.h"
#import "AlertView.h"

@implementation UIUtil
+(void)showMessage:(NSString *)message vc:(UIViewController *)vc {
    [AlertView alertViewWithMessage:message];
}
+ (UIWindow *)findTopWindow {
    NSArray *windows = [UIApplication sharedApplication].windows;
     for (UIWindow * window in [windows reverseObjectEnumerator]) {
         if ([window isMemberOfClass:[UIWindow class]] && CGRectEqualToRect(window.bounds, [UIScreen mainScreen].bounds)) {
             return window;
         }
     }
     return [UIApplication sharedApplication].keyWindow;
}

+ (UIViewController *)findTopViewController {
    
    UIViewController *topViewController = [[self findTopWindow] rootViewController];
    while (true)
    {
        if (topViewController.presentedViewController)
        {
            topViewController = topViewController.presentedViewController;
        }
        else if ([topViewController isKindOfClass:[UINavigationController class]] && [(UINavigationController*)topViewController topViewController])
        {
            topViewController = [(UINavigationController *)topViewController topViewController];
        }
        else if ([topViewController isKindOfClass:[UITabBarController class]])
        {
            UITabBarController *tab = (UITabBarController *)topViewController;
            topViewController = tab.selectedViewController;
        }
        else
        {
            break;
        }
    }
    return topViewController;
}

+ (void)showMessage:(NSString *)message {
    [self showMessage:message error:nil];
}

+ (void)showMessageWithError:(NSError * _Nullable)error {
    [self showMessage:@"" error:error];
}

+ (void)showMessage:(NSString *)message error:(NSError * _Nullable)error {
    message = error == nil ? message : [self getErrMsg:error];
    [self showMessage:message vc:[self findTopViewController]];
}

+ (NSString *)getErrMsg:(NSError *)error {
    NSMutableString *errorMsg = [[NSMutableString alloc] init];
    NSString *errorLocalizedString = [[HWMBizSdk getBizOpenApi] getErrorMessage:error.code];
    if (errorLocalizedString && errorLocalizedString.length > 0) {
        [errorMsg appendFormat:@"%@\n", errorLocalizedString];
    }
    [errorMsg appendFormat:@"错误码:%lu\n", error.code];
    [errorMsg appendFormat:@"错误描述:%@", error.localizedDescription];
    return errorMsg;
}


+ (HWMUISDKLaunchType)getLaunchType{
    return [[[NSUserDefaults standardUserDefaults] objectForKey:@"HWMMeetingSdkLaunchType"] unsignedIntegerValue];
}

+ (void)setLaunchType:(HWMUISDKLaunchType)type{
    [[NSUserDefaults standardUserDefaults] setObject:@(type) forKey:@"HWMMeetingSdkLaunchType"];
}

+ (UIViewController *)findTopPresentViewController:(UIViewController *)vc{
    UIViewController *presentedCtrl = vc.presentedViewController;
    if ([presentedCtrl isKindOfClass:[UIAlertController class]]) {
        return nil;
    }
    while (true){
        if (presentedCtrl.presentedViewController){
            presentedCtrl = presentedCtrl.presentedViewController;
        }else{
            break;
        }
    }
    return presentedCtrl;
}

+ (UIViewController *)findCurrentViewController{
    UIWindow *mainWindow = [self findMainWindow];
    if (!mainWindow) {
        NSLog(@"not found main window");
        return nil;
    }
    return [self findVCInWindow:mainWindow];
}
+ (UIWindow *)findMainWindow{
    UIWindow  *delegateWindow = [[UIApplication sharedApplication].delegate window];
    if (delegateWindow) {
        return delegateWindow;
    }else{
        NSArray *windows = [UIApplication sharedApplication].windows;
        if ([windows count] == 1) {
            return [windows firstObject];
        } else {
            for (UIWindow *window in windows) {
                if (window.windowLevel == UIWindowLevelNormal) {
                return window;
                }
            }
        }
        return nil;
    }

}

+ (UIViewController *)findVCInWindow:(UIWindow *)mainWindow {
    UIViewController *topViewController = [mainWindow rootViewController];
    while (true)
    {
        if (topViewController.presentedViewController)
        {
            topViewController = topViewController.presentedViewController;
        }
        else if ([topViewController isKindOfClass:[UINavigationController class]] && [(UINavigationController*)topViewController topViewController])
        {
            topViewController = [(UINavigationController *)topViewController topViewController];
        }
        else if ([topViewController isKindOfClass:[UITabBarController class]])
        {
            UITabBarController *tab = (UITabBarController *)topViewController;
            topViewController = tab.selectedViewController;
        }
        else
        {
            break;
        }
    }
    NSLog(@"find current VC:%@", NSStringFromClass([topViewController class]));
    return topViewController;
}

+ (UINavigationController *)findCurrentNavigationController{
    UIViewController *currentVC = [self findCurrentViewController];
    if (currentVC) {
        return currentVC.navigationController;
    }
    return nil;
}
+ (UIColor *)colorWithHex:(NSUInteger)rgb{
    NSUInteger r = (rgb >> 16) & 0xFF;
    NSUInteger g = (rgb >> 8 ) & 0xFF;
    NSUInteger b = rgb & 0xFF;
    return [UIColor colorWithRed:r / 255.0f green:g / 255.0f blue:b / 255.0f alpha:1.f];
    
}
@end
