//
//  HWMBroadcastScreenShare.h
//  HWMConf
//
//  Created by luqiang/00465337 on 2019/12/24.
//  Copyright © 2019年 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMExtensionDefine.h"

NS_ASSUME_NONNULL_BEGIN
@protocol HWMBroadcastScreenShareDelegate <NSObject>
- (void)screenShareStateChange:(HWM_EXTENSION_STATE)state;
- (void)screenshareData:(NSDictionary *)data;
/**
 *  打印ScreenShareExtension 日志信息
 *
 *  @param logMessage    日志信息
 */
- (void)screenShareLogMessage:(NSString *)logMessage;
/// 接收音频共享数据
- (void)onReceiveAudioShareData:(NSDictionary *)data;
@end
API_AVAILABLE(ios(12.0))
@interface HWMBroadcastScreenShare : NSObject
+ (void)startSharingScreenWithExtension:(NSString *)extension;
+ (void)stopSharingScreenWithMessage:(NSString *)message;
/// 数据会议重协商切换站点停止共享
+ (void)stopSharingForTransferSite;
+ (void)setScreenShareFrame:(NSUInteger)frame;
+ (void)setScreenShareDelegate:(nullable id<HWMBroadcastScreenShareDelegate>)delegate;
+ (void)startAudioShare;
+ (void)stopAudioShare;
/// 更新最大分辨率限制
+ (void)updateScreenShareResolutionLimit:(NSInteger)limit;
@end

NS_ASSUME_NONNULL_END
