//
//  ScreenShareManager.h
//  ScreenShareExtension
//
//  Created by 融合软终端01 on 2019/3/25.
//
#import <Foundation/Foundation.h>
#import <ReplayKit/ReplayKit.h>

NS_ASSUME_NONNULL_BEGIN

static NSString * const kHWMAudioShareObjectKey = @"kHWMAudioShareObjectKey";
static NSString * const kHWMAudioShareID = @"kHWMAudioShareID";
static NSString * const kHWMScreenShareResolutionChangeID = @"kHWMScreenShareResolutionChangeID";
static NSString * const kHWMScreenShareResolutionChangedObjectKey = @"kHWMScreenShareResolutionChangedObjectKey";

@protocol ScreenShareManagerDelegate <NSObject>

@required
- (void)screenShareManagerFinishBroadcastWithError:(NSError *_Nullable)error;
@end


@interface HWMExensionDataManager : NSObject
@property (weak, nonatomic) id<ScreenShareManagerDelegate> _Nullable delegate;
@property (nonatomic, strong, readonly) dispatch_queue_t queue;

- (void)broadcastStartedWithSetupInfo:(nullable NSDictionary <NSString *, NSObject *> *)setupInfo;

- (void)broadcastPaused;

- (void)broadcastResumed;

- (void)broadcastFinished;

- (void)processSampleBuffer:(CMSampleBufferRef _Nullable )sampleBuffer withType:(RPSampleBufferType)sampleBufferType;

- (void)listenForMessageWithIdentifier:(nullable NSString *)identifier
                              listener:(nullable void (^)(__nullable id messageObject))listener;

- (void)stopListeningForMessageWithIdentifier:(nullable NSString *)identifier;

- (void)passMessageObject:(nullable id <NSCoding>)messageObject
               identifier:(nullable NSString *)identifier;

- (void)clearAllMessageContents;

- (NSUInteger)getMaxScreenShareFrame;
@end

NS_ASSUME_NONNULL_END
