//
//  HWMCalleeInfo.h
//  HWMUISDK
//
//  Created by yaolili/ywx577644 on 2023/6/12.
//  Copyright © 2023 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMEnterpriseDepartmentConstant.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMCalleeInfo : NSObject

/// 被叫姓名
@property (nonatomic, strong) NSString *nickName;

/// 被叫号码，与thirdUserId二选一，优先级number > thirdUserId
@property (nonatomic, strong) NSString *number;

/// APPID 登录场景下的第三方账号，与number二选一
@property (nonatomic, copy) NSString *thirdUserId;

/// 中文别名
@property (nullable, nonatomic, copy) NSString *aliasCN;

/// 英文别名
@property (nullable, nonatomic, copy) NSString *aliasEN;

/// 三方自定义字段
@property (nullable, nonatomic, copy) NSString *extendedField;

/// 用户类型
@property (nonatomic, assign) HWMConfAttendeeType type;

/// 企业id
@property (nullable, nonatomic, copy) NSString *orgId;

@end

NS_ASSUME_NONNULL_END
