//
//  HWMConfContactModel.h
//  HWMBaseUI
//
//  Created by fuxihua on 2020/4/20.
//

#import <Foundation/Foundation.h>
#import "HWMEnterpriseDepartmentConstant.h"
#import "HWMSDKCommonDefine.h"

@interface HWMConfContactModel : NSObject
/// (必填)名字
@property (nonatomic, copy) NSString *name;
/// (number/thirdUserId 二选一)SIP呼叫号码或者电话号码
@property (nonatomic, copy) NSString *number;
/// (number/thirdUserId 二选一)对于appid登录场景, 需要传第三方的userid
@property (nonatomic, copy) NSString *thirdUserId;
/// (可选)用户帐号唯一id, 企业通讯录的id
@property (nonatomic, copy) NSString *accountId;
/// (可选)邮箱
@property (nonatomic, copy) NSString *email;
/// (可选)是否是硬终端
@property (nonatomic, assign) BOOL isHardTerminal;
/// (可选)联系人类型
@property (nonatomic, assign) HWMContactType contactType;
/// (可选)是否是匿名入会(涉及与会者列表和观众列表)
@property (nonatomic, assign) BOOL isAnonymous;
/// (可选)会议时间到了是否自动呼叫
@property (nonatomic, assign) BOOL isAutoInvite;
/// (可选)入会是否静音
@property (nonatomic, assign) BOOL isMute;
/// (可选)与会者角色
@property (nonatomic, assign) HWMConfRole role;
/// (可选)与会者类型
@property (nonatomic, assign) HWMAttendeeType type;
/// (可选)手机号码
@property (nonatomic, copy) NSString *sms;
/// (可选)用户的企业id
@property (nonatomic, copy) NSString *orgId;
/// (可选)与会者唯一标识uuid
@property (nonatomic, copy) NSString *userUuid;
/// (可选)会中状态
@property (nonatomic, assign) HWMConfAttendeeState state;
/// (可选)平台类型
@property (nonatomic, assign) HWMClientDeviceType clientDeviceType;
/// (可选)对于appid登录场景, 需要传申请的appid, 应用id
@property (nonatomic, copy) NSString *appId;

@end

@interface HWMConfQueryAvatarModel : NSObject
@property (nonatomic, copy) NSString *account;
@property (nonatomic, copy) NSString *thirdUserId;
@property (nonatomic, copy) NSString *number;
@property (nonatomic, copy) NSString *extendedField;
@property (nonatomic, copy) NSString *realNameAccount;
@property (nonatomic, copy) NSString *orgId;

@end

@interface HWMConfQueryContactModel : NSObject
@property (nonatomic, copy) NSString *account;
@property (nonatomic, copy) NSString *thirdUserId;
@property (nonatomic, copy) NSString *number;
@property (nonatomic, copy) NSString *extendedField;
@property (nonatomic, copy) NSString *orgId;

@end
