//
//  HWMConfSettingItem.h
//  HWMConfUI
//
//  Created by y00450113 on 2020/7/6.
//  Copyright © 2020 huawei. All rights reserved.
//

#import "HWMConfMenuItem.h"

NS_ASSUME_NONNULL_BEGIN
typedef NS_OPTIONS (NSUInteger, HWMConfSettingViewType) {
    /*****************
     -------------------------
     text              |on|off|
     -------------------------
     ******************/
    HWMConfSettingViewTypeSwitch = 2,    // 左边文字 + 右边开关
    /*****************
    --------------------------
     text                    >
    --------------------------
    ******************/
    HWMConfSettingViewTypeEnter  =  3,    // 左文字 + 右箭头
    /*****************
    --------------------------
     text                  text  >
    --------------------------
    ******************/
    HWMConfSettingViewTypeEnterWithRightText = 4, // 带右边文本的可进入按钮
    /*****************
     -------------------------
     text image               |on|off|
     -------------------------
     ******************/
    HWMConfSettingViewTypeSwitchWithLeftImage = 5, // 左文字+左图片+右开关
    /*****************
     -------------------------
     text              |on|off|
     text
     -------------------------
     ******************/
    HWMConfSettingViewTypeSwitchWithBottomText = 6, // 左文字+右开关+下文字
    /*****************
     -------------------------
     text              text  >
     text
     -------------------------
     ******************/
    HWMConfSettingViewTypeEnterWithRightAndBottomText = 7, // 左文字+有文字+右箭头+下文字
};

typedef NS_ENUM(NSInteger, HWMConfSettingViewState) {
    HWMConfSettingViewStateNormal,  // 默认状态,可交互
    HWMConfSettingViewStateDisable  // 禁用状态,不可交互
};

@interface HWMConfSettingItem : HWMConfMenuItem

@property (nonatomic, assign) HWMConfSettingViewType viewType;
@property (nonatomic, strong) UIImage *leftImage;
/// 开关切换的事件回调,只有 HWMConfSettingItemTypeSwitch 类型会回调
/// isSelected ,表示switch是否开启，YES，开启，NO ，关闭
@property (nonatomic, copy) void (^ switchEvent)(HWMConfCtrlType type, UISwitch *actionSwitch);
/// 状态
@property (nonatomic, assign) HWMConfSettingViewState viewState;

- (instancetype)init NS_UNAVAILABLE;
- (instancetype)initItemWithType:(HWMConfCtrlType)type
                            text:(NSString *)text
                        viewType:(HWMConfSettingViewType)viewType;

- (instancetype)initSwitchItemWithType:(HWMConfCtrlType)type
                                  text:(NSString *)text;

- (instancetype)initEnterItemWithType:(HWMConfCtrlType)type text:(NSString *)text;

- (instancetype)initEnterItemWithRightTextType:(HWMConfCtrlType)type text:(NSString *)text rightText:(NSString *)rightText;

- (instancetype)initEnterItemWithType:(HWMConfCtrlType)type text:(NSString *)text rightText:(NSString *)rightText bottomText:(NSString *)bottomText;

// 啸叫检测开关
+ (HWMConfSettingItem *)defaultHowlDetection;

// 美颜开关
+ (HWMConfSettingItem *)defaultBeautyItem;


//锁定会议开关
+ (HWMConfSettingItem *)defaultLockItem;

//允许与会者
+ (HWMConfSettingItem *)defaultAllowAttendeeUnmuteItem;

// 锁定共享
+ (HWMConfSettingItem *)defaultLockShareItem;

// 本地录制权限
+ (HWMConfSettingItem *)defaultLocalRecordRights;

// 网络检测
+ (HWMConfSettingItem *)defaultNetworkDetectItem;

/// 反馈
+ (HWMConfSettingItem *)defaultFeedbackItem;

/// 默认 隐藏小画面
+ (HWMConfSettingItem *)defaultHideSmallVideoItem;

/// 允许入会
+ (HWMConfSettingItem *)defaultAllowJoinConf;

///开启等候室
+ (HWMConfSettingItem *)defaultWaitingRoom;

/// 允许入会
+ (HWMConfSettingItem *)defaultAllowChat;

/// 聊天消息提醒
+ (HWMConfSettingItem *)defaultChatRemindItem;

/// 视频镜像
+ (HWMConfSettingItem *)defaultMirror;

/// 允许启动视频
+ (HWMConfSettingItem *)defaultAllowAttendeeOpenCameraItem;

/// 允许改名
+ (HWMConfSettingItem *)defaultAllowRenameItem;

/// 隐藏 悬浮静音视图
+ (HWMConfSettingItem *)defaultHideFloatMicroButtonItem;

/// 高清视频优先
+ (HWMConfSettingItem *)defaultHDPreferred;

/// 画面比例
+ (HWMConfSettingItem *)defaultPictureRatio;

/// 音频降噪
+ (HWMConfSettingItem *)defaultNoiseReductionItem;

/// 暗场景增强
+ (HWMConfSettingItem *)defaultEnhanceVideoQuality;

/// 会中抢共享权限
+ (HWMConfSettingItem *)defaultPreemptSharePermissionItem;

/// 字幕翻译语言设置
+ (HWMConfSettingItem *)defaultSubtitleLanguageSettingItem;

/// 我正在说
+ (HWMConfSettingItem *)defaultSpeakingLanguageItem;

/// 字幕翻译语言
+ (HWMConfSettingItem *)defaultSubtitleLanguageItem;

/// 视频权限
+ (HWMConfSettingItem *)defaultCameraPermission;

/// 允许其他与会者标注
+ (HWMConfSettingItem *)defaultAllowAttendeeAnnotate;

/// 入会自动静音
+ (HWMConfSettingItem *)defaultAutoMuteItem;

/// 多人同时共享
+ (HWMConfSettingItem *)defaultShareAtSameTimeItem;

/// 会议水印
+ (HWMConfSettingItem *)defaultWatermarkItem;

@end

NS_ASSUME_NONNULL_END
