//
//  HWMErrorDefine.h
//  HWMBaseUI
//
//  Created by y00450113 on 2023/9/27.
//  Copyright © 2023 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>
#ifndef HWMErrorDefine_h
#define HWMErrorDefine_h

#define HWMConfVmrConflictErrorKey @"com.welink.huawei.vmrConflict"
#define HWMConfDomin @"com.huawei.welink"

typedef enum : NSUInteger {
    HWM_CONF_ERR_CODE_ARGS = 5001,              /**< 参数错误 */
    HWM_CONF_ERR_CODE_NET = 5002,               /**< 网络错误 */
    HWM_CONF_ERR_CONF_DUPLICATE = 5003,         /**< 会议已存在 */
    HWM_CONF_ERR_CODE_COMMON = 5004,            /**< 接口调用失败 */
    HWM_CONF_ERR_CODE_RECALLING = 5005,         /**< 重呼中 */
    HWM_CONF_ERR_CODE_NOT_EXIST = 5006,         /**< 会议不存在 */
} HWM_CONF_ERR_CODE;

typedef NS_ENUM(NSUInteger, HWMSettingModifyPWDErrorCode)
{
    HWMSettingModifyPWDErrorCodeParamWrong = 2, //参数错误
    HWMSettingModifyPWDErrorCodeTimeout = 412100003, // 网络超时
    HWMSettingModifyPWDErrorCodeNetworkError = 412100006, // 断网
    HWMSettingModifyPWDErrorCodeOldPWDWrong = 206030006, // 原密码错误
    HWMSettingVmrPwdErrorCodeNewPWDLengthIllegal = 206030007, // 新密码长度非法
    HWMSettingVmrPwdErrorCodeNewPWDLowComplexity = 206030008, // 新密发复杂度不够
    HWMSettingVmrPwdErrorCodeSameOldPassword = 206030009, // 新密码和最近密码不能相同
    HWMSettingVmrPwdErrorCodeNewHasSameCharMore = 206030010, // 新密码不能包含3个以上重复代码
    HWMSettingVmrPwdErrorCodeLowTimeInterval = 206030011, // 上次修改密码5分钟内不能更新密码
    HWMSettingVmrPwdErrorCodeLowCannotContainAccount = 206030012, // 密码不能包含账号或逆序账号
    HWMSettingVmrPwdErrorCodeNewPWDHasTooManySameCharWithOldPWD = 206030013, // 新密码相较老密码至少要有两个不同字符
    HWMSettingVmrPwdErrorCodeAccountOrPWDError = 29, // 用户名或者密码错误(不会产生)
    HWMSettingVmrPwdErrorCodeAccountIsLocked = 206030015, // 用户被锁定
    HWMSettingVmrPwdErrorCodeBadAccessDuringUpgrade = 200000005, // 升级期间禁止访问
    HWMSettingVmrPwdErrorCodeBadAccountNotExist = 206030000, // 用户不存在
    HWMSettingVmrPwdErrorCodeBadFindVercodeFailedByAccount = 206030001, // 通过账号查询验证码错误
    HWMSettingVmrPwdErrorCodeVercodeError = 206030002, // 验证码错误
    HWMSettingVmrPwdErrorAccountIsNotPhoneOrEmail = 206030003, // 账号既非电话号码亦非邮箱
    HWMSettingVmrPwdErrorCodeResendCodeWithinThreeMinNotAllowed = 206030004, // 3分钟之内不允许重复发送验证码
    HWMSettingVmrPwdErrorCodeNoRightToChangePWD = 206030016, // 无修改密码权限
    HWMSettingVmrPwdErrorCodeContainsInvalidChar = 206030014, // 新密码包含无效字符
    HWMSettingVmrPwdErrorLowPWDSecurity = 201040016, // 密码安全性低
    HWMSettingVmrPwdErrorTokenInvalid = 206020000, // 无效token
};
typedef NS_ENUM(NSUInteger, HWMConfSdkErrorCode) {
    HWMConfSdkErrorCodeOperationTimeout                      = 68, // 网络不佳，发起/加入会议超时
    HWMConfSdkErrorCodeRoleAuthenticationFailed              = 91, // 会议不存在或者无权限访问
    HWMConfSdkErrorCodeVMROnlyAllowChairStartConf            = 95, // 会议不允许提前入会，请联系主持人
    HWMConfSdkErrorCodeNotAllowedGuestFirstJoin              = 103, // 会议不允许提前入会，请联系主持人
    HWMConfSdkErrorCodeConfSizeOverCommunalVMRMaxNum         = 104, // 云会议室与会人数已达上限，请联系管理员
    HWMConfSdkErrorCodeConfClosedRecently                    = 112, // 会议已结束
    HWMConfSdkErrorCodeConfDataNotFound
    DEPRECATED_ATTRIBUTE                                     = 127, // 会议ID不存在或密码错误
    HWMConfSdkErrorCodeCorpConfResourceHasBeenRunout
    DEPRECATED_ATTRIBUTE                                     = 514, // 企业购买的会议资源（人数限制）已达上限
    HWMConfSdkErrorCodeReasonSessionTimerTimeout             = 836, // 会话心跳超时挂断
    HWMConfSdkErrorCodeReasonNostreamHangup                  = 837, // 无码流挂断
    HWMConfSdkErrorCodeReasonChairHangup                     = 838, // 主席挂断
    HWMConfSdkErrorCodeReasonStopConfHangup                  = 839, // 结束会议挂断
    HWMConfSdkErrorCodeReasonConfLocked                      = 842, // 会议已锁定
    HWMConfSdkErrorCodeConfDataNotFound2
    DEPRECATED_ATTRIBUTE                                     = 11070005, // 会议不存在
    HWMConfSdkErrorCodeVMRDataNotFound                       = 11070006, // VMR会议室不存在
    HWMConfSdkErrorCodeVMRConfConflict                       = 11071005, // 创会时间冲突
    HWMConfSdkErrorCodeConfStartTimeOverMaxScheduleTime      = 11071014, // 会议开始时长超出最大可预定时间范围
    HWMConfSdkErrorCodeConfSMSIllegal                        = 11071025, // 请检查与会人手机号是否正确
    HWMConfSdkErrorCodeNotAllowedGuestFirstJoin2
    DEPRECATED_ATTRIBUTE                                     = 11071058, // 当前会议还未召开，请耐心等待
    HWMConfSdkErrorCodeConfSizeOverCommunalVMRMaxNum2
    DEPRECATED_ATTRIBUTE                                     = 11071059, // 云会议室与会人数已达上限，请联系管理员
    HWMConfSdkErrorCodeOrgConcurrentParticipantsNumberIsZero = 11071060, // 企业未购买并发与会方资源，无法创建会议
    HWMConfSdkErrorCodeConfModifyFailAsConfAlreadyStarted
    DEPRECATED_ATTRIBUTE                                     = 11071065, // 正在召开会议，无法编辑会议详情
    HWMConfSdkErrorCodeConfCancelFailAsConfStarted           = 11071067, // 当前会议正在召开，无法取消
    HWMConfSdkErrorCodeConfNotAllowAnonymous                 = 11071073, // 您呼叫的会议不允许匿名用户呼入，请联系会议预订者
    HWMConfSdkErrorCodeConfOnlyAllowUserInOrg                = 11071074, // 您呼叫的会议只允许企业内用户呼入，请联系会议预订者
    HWMConfSdkErrorCodeConfOnlyAllowUserInvited              = 11071075, // 您呼叫的会议只允许被邀请用户呼入，请联系会议预订者
    HWMConfSdkErrorCodeSiteCallNumberIsEmpty                 = 11072031, // 请检查与会人手机号是否为空
    HWMConfSdkErrorCodeSiteCallNumberIllegalUri              = 11072033, // 请检查与会人入会号码是否正确
    HWMConfSdkErrorCodeConfLocked                            = 11072050, // 会议已经被锁定
    HWMConfSdkErrorCodeConfNotFoundOrAuthFailed
    DEPRECATED_ATTRIBUTE                                     = 11072065, // 会议不存在或密码错误
    HWMConfSdkErrorCodeConfPortalParticipantVMRLogicResourceNotEnough
    DEPRECATED_ATTRIBUTE                                     = 11076003, // 云会议室同时在线人数已达上限，请联系会议主持人或管理员
    HWMConfSdkErrorCodeParticipantAuthenticationFailed       = 11081006, // 密码错误，请重新输入
    HWMConfSdkErrorCodeCorpConferenceResourceHasBeenRunout   = 15022001, // 企业购买的会议资源（人数限制）已达上限，请联系管理员
    HWMConfSdkErrorCodeAnonyConfIdOrPwdError
    DEPRECATED_ATTRIBUTE                                     = 90000001, // 会议id或者密码错误
    HWMConfSdkErrorCodeAnonyConfRandomError
    DEPRECATED_ATTRIBUTE                                     = 90000002, // 随机数错误导致会议结束或不存在
    HWMConfSdkErrorCodeAnonyConfEnded
    DEPRECATED_ATTRIBUTE                                     = 90000003, // 会议已结束
    HWMConfSdkErrorCodeAnonyConfIpLocked
    DEPRECATED_ATTRIBUTE                                     = 90000004, // 密码输入错误次数太多导致IP锁定
    HWMConfSdkErrorCodeAnonyConfNetworkError
    DEPRECATED_ATTRIBUTE                                     = 90000005, // 网络错误
    HWMConfSdkErrorCodeAnonyConfNotStart
    DEPRECATED_ATTRIBUTE                                     = 90000006, // 会议未开始
    HWMConfSdkErrorCodeAnonyConfLocked
    DEPRECATED_ATTRIBUTE                                     = 90000007, // 会议已锁定
    HWMConfSdkErrorCodeAnonyCertificateVerifyFailed
    DEPRECATED_ATTRIBUTE                                     = 90000008, // 证书校验失败
    HWMConfSdkErrorCodeAnonyConfNotAllowed
    DEPRECATED_ATTRIBUTE                                     = 90000009, // 不允许匿名用户入会
    HWMConfSdkErrorCodeCreateConfFailedReason1
    DEPRECATED_ATTRIBUTE                                     = 285212898, // 会议创建失败，可能原因：1.会议所需的MCU或录播服务器资源不足；2.MCU不能满足会议预设的多画面模式等其他会议设置；3.MCU不具有多通道能力；请联系管理员解决。
    HWMConfSdkErrorCodeCreateConfFailedReason2
    DEPRECATED_ATTRIBUTE                                     = 285212899, // 会议创建失败(会议演示速率低于录播演示的最低速率：带宽384K或者视频格式H264 CIF)
    HWMConfSdkErrorCodeCreateConfFailedReason3
    DEPRECATED_ATTRIBUTE                                     = 285212900, // 会议创建失败(会议的视频格式不能低于录播的视频格式)
    HWMConfSdkErrorCodeCreateConfFailedReason4
    DEPRECATED_ATTRIBUTE                                     = 285212901, // 会议创建失败(会议的带宽不能低于录播的带宽)
    HWMConfSdkErrorCodeLowVersionNotSetCohost                = 111072106, // 对方版本过低，不能设联席
};

typedef NS_ENUM(NSUInteger, HWMUISDKErrorCode
                ) {
// 40000 为通用错误码
    HWMUISDKErrorCodeContactNotFound         = 40000,
    HWMUISDKErrorCodeNumberAndAccountEmpty   = 40001,
    HWMUISDKErrorCodeArgsError               = 40002,
    HWMUISDKErrorCodeRepeatRequest           = 40003,
    HWMUISDKErrorCodeTimeOut                 = 40004,     /**< 超时 40004*/
    HWMUISDKErrorCodeUnInit                  = 40005,     /**< 未初始化 40005*/
    HWMUISDKErrorCodeArgsLengthOverrun       = 40006, /**< 参数长度超限 40006*/
    HWMUISDKErrorCodePasswordOrAccountEmpty  = 40007,
    HWMUISDKErrorCodeConfIdEmpty             = 40008,
    HWMUISDKErrorCodeUnLogin                 = 40009,     /**< 未登录 40009*/
    HWMUISDKErrorCodeLoginIng                = 40010,     /**< 登录中 40010*/
    HWMUISDKErrorCodeSubjectTooLong          = 40011,
    HWMUISDKErrorCodeConfIdTooLong           = 40012,
    HWMUISDKErrorCodeConfOrCallExit          = 40013,     /**< 正在会议或呼叫中 40013*/
    HWMUISDKErrorCodeAPPIDInfoIllegal        = 40014,     /**< APPID 信息入参不合法 40014*/
    HWMUISDKErrorCodeNetworkUnreachable      = 40015, /**< 网络不可用 40015*/
    HWMUISDKErrorCodeFilePathEmpty           = 40016,     /**< 图片路径为空 40016*/
    HWMUISDKErrorCodeNotInMeeting            = 40017,     /**< 没有在会议中 40017*/
    HWMUISDKErrorCodeNoPermissionAddAttendee = 40018, /**< 没有权限添加与会者 40018*/
    HWMUISDKErrorCodeNoPermissionEndConf     = 40019, /**< 没有权限结束会议 40019*/
    HWMUISDKErrorCodeLeaveConfFail           = 40020,     /**< 离开会议失败 40020*/
    HWMUISDKErrorCodeLogined                 = 40021,     /**< 已登录 40021*/
    HWMUISDKErrorCodeVMRHostPasswordLengthlegal = 40022,  /**< 主持人密码长度合法*/
    HWMUISDKErrorCodeVMRNameEmpty               = 40023, /**< VMR名字为空*/
    
    HWMUISDKErrorCodeCallInterfaceError         = 40110, /**< 底层调用会议的接口失败*/
    HWMUISDKErrorCodeConfStartTimeEarly         = 40115, /**< 会议的开始时间早于当前时间*/
    HWMUISDKErrorCodeNotInConf                  = 40116, /**< 不在会议中*/
    HWMUISDKErrorCodeCallAccountEmpty           = 430300001, /**< 点对点呼叫账号为空*/

    HWMUISDKErrorCodeGuestPwdLegal              = 430400007, /**< 来宾密码不合法*/
    HWMUISDKErrorCodeCallResourceNoEnough       = 115022001,/**< 企业并发资源不足*/
};
typedef NS_ENUM(NSUInteger, HWMSettingVmrPwdErrorCode) {
    HWMErrorCodeGuestPwdError                = 430400007, /**< 来宾密码长度错误*/
    HWMErrorCodeTimeZoneError                = 430400002, /**< 时区错误*/
    HWMErrorCodeConfDurationEqualToZero      = 430400003, /**< 会议时等于0*/
    HWMUISDKErrorCodeJoinConfInterruptedFail = 430400004, /**< 入会被中断*/
    HWMErrorCodePermissionReject             = 50000,
    HWMErrorCodeUserCancel                   = 50001,
    HWMErrorCodeMultiDeviceOnline            = 50002,
    HWMErrorCodeSipDisable                   = 50003,
    HWMErrorCodeConfIdError                  = 50004,
    HWMErrorCodeNickEmpty                    = 50005,
    HWMErrorCodeNickTooLong                  = 50006,
    HWMErrorCodeConfOrCallExist              = 50007,
    HWMErrorCodeConfNeedPassword             = 50008,
    HWMErrorCodeConfUnLogin                  = 50009,
    HWMErrorCodeConfLoginIng                 = 50010,
    HWMErrorCodeQRCodeNotSupported           = 50011,
    HWMErrorCodeNetworkUnReachable           = 50012,
    HWMErrorCodeUserCancelPhoneVerify        = 50013,
    HWMErrorCodeSeesionExpired               = 50014,
    HWMErrorCodeOuterInject                  = 50015, //因为外界拦截注入，产生的error
    HWMErrorCodeFeedbackParamError = 60000,
    HWMErrorCodeFeedbackZipPathEmpty = 60001,
    HWMErrorCodeFeedbackZipInfoError = 60002,
    HWMErrorCodeFeedbackZipSizeExceedLimit = 60003,
    HWMErrorCodeFeedbackGetUploadInfoFail = 60004,
    HWMErrorCodeFeedbackUploadInfoEmpty = 60005,
    HWMErrorCodeFeedbackTimesIsMax = 60006,
    HWMErrorCodeFeedbackRedirectFail = 60007,
    HWMErrorCodeFeedbackFolderPathEmpty = 60008,
    HWMErrorCodeFeedbackNetError = 60009,
    HWMErrorCodeFeedbackOPSTimesIsMax = 231000005,
    HWMErrorCodeFeedbackUploadTimesExceed = 211060003,
    HWMErrorCodeReportOPSTimesIsMax = 231000008,
};
typedef NS_ENUM(NSUInteger, HWMConfUIErrorCode
                ){
    HWMSettingVmrPwdErrorCodeIllegalParameters = 000000003, // 非法参数
    HWMSettingVmrPwdErrorCodeWeakPassword = 201040016, // 新密码是弱密码
    HWMSettingVmrPwdErrorCodePaddwordWrong = 206030006, // 老密码错误
    HWMSettingVmrPwdErrorCodeIllegalLength = 206030007, // 新密码长度非法
    HWMSettingVmrPwdErrorCodeLowComplexity = 206030008, // 新密码复杂度不满足要求
    HWMSettingVmrPwdErrorCodeSameNewPassword = 206030009 // 新密码不能与最近旧密码相同
    , // 上次修改密码后5分钟内不能更新密码
    HWMSettingVmrPwdErrorCodePasswordRepeat = 201080006, // 来宾密码不能与主席密码相同
    HWMSettingVmrPwdErrorCodeContainAccount = 201080017, // 来宾密码不能与会议ID（或逆序）相同
};

typedef NS_ENUM(NSInteger, HWMShiMoDocumentErrorCode) {
    HWMShiMoDocumentErrorCodeApplicationNotFound              = 111113001, // 找不到应用信息,会议未绑定文件夹,申请权限失败
    HWMShiMoDocumentErrorCodeApplicationExist                 = 111113002, // 应用已存在,目前一个会议只能关联一种应用
    HWMShiMoDocumentErrorCodeExternalCreateFolderFailed       = 111113003, // 企业外部人员,激活文档失败
    HWMShiMoDocumentErrorCodeNeedVerifyIdCard                 = 111113004, // 应用操作需要实名认证
    HWMShiMoDocumentErrorCodeGetUserTokenError                = 111113005, // 获取应用用户token失败
    HWMShiMoDocumentErrorCodeUrlIllegal                       = 111113006, // 应用服务url地址非法
    HWMShiMoDocumentErrorCodeShiMoServerError                 = 111113102, // 调用石墨文档服务失败
    HWMShiMoDocumentErrorCodeGetShiMoTokenError               = 111113103, // 获取石墨应用级token失败
    HWMShiMoDocumentErrorCodeRequestDocPermissionOutConf      = 111113104, // 用户不在会议中,无权限申请文档权限
    HWMShiMoDocumentErrorCodeConfNotFound                     = 411000003, // 会议不存在
    HWMShiMoDocumentErrorCodeAuthError                        = 411000007, // 认证失败
};


/// 登录错误码，枚举注释的错误码为老错误码(后面需要删除2021-02-25)，对应的值为新的
typedef NS_ENUM(NSInteger,HWMLoginErrorID) {
    HWMLoginErrorBegin = 10000,            /**< 起始错误 10000*/
    HWMLoginErrorGeneral,                  /**< 内部错误 10001(TODO : 凡事使用该错误的，需要修改)*/
    HWMLoginErrorParamError,               /**< 参数错误 10002*/
    HWMLoginErrorRequestTimeout = 412100003,                /**< 网络超时 10003*/
    HWMLoginErrorSdkRequestTimeout = 412200003,             /**< 网络超时 10003*/
    HWMLoginErrorNetworkError = 412100013,                  /**< 网络错误(DNS解析异常) 10004*/
    HWMLoginErrorSdkRequestFailed = 412100007,              /**< 网络错误(请求消息异常) 10004*/
    HWMLoginErrorDnsError = 412100006,                      /**< 网络错误(网络异常) 10004*/
    HWMLoginErrorLogicError = 412200004,                    /**< 网络错误(网络错误) 10004*/
    HWMLoginErrorCertificateVerifyFail = 412100012,         /**< 校验服务器证书证失败 10005*/
    HWMLoginErrorAccountOrPassowrdError = 206010000,        /**< 帐号或密码错误 10006*/
    HWMLoginErrorUsgUserNotExist = 206030000,               /**< 帐号或密码错误 10006*/
    HWMLoginErrorUsgAppidAuthFailed = 206010025,            /**< 帐号或密码错误 10006*/
    HWMLoginErrorAccountLocked = 412100010,                 /**< 帐号被锁定 10007*/
    HWMLoginErrorUsgUserLocked = 206030015,                 /**< 帐号被锁定(含义不同：这里是http返回423错误码) 10007*/
    HWMLoginErrorIpOrDeviceForbidden = 10008,               /**< IP或设备被禁止接入 10008*/
    HWMLoginErrorCorpOrAccountDiactive = 412100015,         /**< 帐号或企业未激活 10009*/
    HWMLoginErrorCurleCoulentTesolveHost = 412100025,       /**< 认证鉴权过程失败，无法解析主机 412100025*/
    HWMLoginErrorServerUpgrade = 200000005,                 /**< 服务器升级中 10010*/
    HWMLoginErrorneedModifyPassord = 412200010,             /**< 首次登录，提示用户修改密码 10011*/
    HWMLoginErrorServerError = 10012,                       /**< 服务器错误 10012*/
    HWMLoginErrorNeedReauth,                                /**< 认证信息发生变化，请重新登录 10013*/
    HWMLoginErrorAccountUnbound,                            /**< 联邦认证未绑定welink帐号 10014*/
    HWMLoginErrorServerBusy,                                /**< 系统繁忙，请稍候再试 10015*/
    HWMLoginErrorAccountDestroyed,                          /**< 该帐号已注销，无法登录 10016*/
    HWMLoginErrorAuthTypeChange,                            /**< 企业认证类型变化 10017*/
    HWMLoginErrorAccountForbidden,                          /**< 该帐号禁止登录 10018*/
    HWMLoginErrorNormalUserCannotLogin = 206010036,         /**< 大屏转商后不允许普通用户登陆 10019*/
    HWMLoginErrorAppidNotAllowAutoRegister = 206010030,     /**< 企业不支持自动开户 10020*/
    HWMLoginErrorAppidAccountDisabled = 206010007,          /**< 帐号被停用 10021*/
    HWMLoginErrorAppidAutoRegisterFailed = 206010031,       /**< 自动开户失败 10022*/
    HWMLoginErrorAppidAuthExpire = 206010057,               /**< 应用鉴权信息已过期 10023*/
    HWMLoginErrorRequsetParamsError = 206060011,            /**< 发送用户验证码失败，输入的手机或邮箱不满足格式要求 10024*/
    HWMLoginErrorNeedSliderVerify = 206060009,              /**< 发送用户验证码需要滑块验证 10025*/
    HWMLoginErrorSliderTokenInvaild = 206060010,            /**< 发送用户验证码失败，输入的手机或邮箱不满足格式要求 10026*/
    HWMLoginErrorNotSupportSendSMS = 206060012,             /**不支持通过该手机号发送用户验证码 10027*/
    HWMLoginErrorNotAllowRepeatSend = 206060013,            /**不允许再次发送用户验证码 注册60秒 忘记密码180秒 10028*/
    HWMLoginErrorUsgResendNotAllow = 206030004,             /**不允许再次发送用户验证码 注册60秒 忘记密码180秒 10028*/
    HWMLoginErrorSendVerifyCodeIsLocked = 206060008,        /**用户验证码发送被锁定 10029*/
    HWMLoginErrorSendVerifyCodeFailed = 206030023,          /**发送验证码失败 10030*/
    HWMLoginErrorSendSliderFalied = 206010010,              /**发送滑块失败 10031*/
    HWMLoginErrorPreVerifyExpire = 201040042,               /**前置校验已过期，请返回上一步 10032*/
    HWMLoginErrorOtherCorpOwner = 201020023,                /**该用户已经是其他企业的所有者，无法为其创建新的企业 10033*/
    HWMLoginErrorNoInviteOtherCorpOwner = 201040043,        /**该用户是其他企业的所有者，暂无法邀请  10034*/
    HWMLoginErrorInviteLinkInvalid = 201040044,             /** 邀请链接已失效  10035*/
    HWMLoginErrorUserInWaitList = 201040045,                /** 该用户已在待定列表 10036*/
    HWMLoginErrorUserExist = 201040046,                     /** 该用户已存在  10037*/
    HWMLoginErrorNotAllowModAccount = 201040047,            /** 该用户不支持修改手机、邮箱 10038*/
    HWMLoginErrorVerifyCodeInvaild = 206060014,             /** 验证码非法或过期 10039*/
    HWMLoginErrorUsgVerifyCodeError = 206030002,            /** 验证码非法或过期 10039*/
    HWMLoginErrorVerifyCodeCheckExceedMax = 206030019,      /** 验证码输入次数超过最大值 10040 */
    HWMLoginErrorUsgVerifyCodeCheckExceedMax = 206060015,   /** 验证码输入次数超过最大值 10040 */
    HWMLoginErrorBindUserInfoFailedBindTokenInvalid = 206060017,                  /**< bindToken过期 */
    HWMLoginErrorCheckSliderFailed = 206010012,             /** 滑块校验失败  10041*/
    HWMLoginErrorAutoUserNotAllowModPwd = 206030028,        /** 自动开户用户不支持修改密码  10042*/
    HWMLoginErrorForgetPwdOverMaxTime = 206030018,          /** 一天内忘记密码密码超过最大次数  10043*/
    HWMLoginErrorPasswordSecurityLow = 201040016,           /** 密码安全性低  10044*/
    HWMLoginErrorInvaildNewPwdLen = 206030007,              /** 密码长度非法  10045*/
    HWMLoginErrorInvaildNewPwdLevel = 206030008,            /** 新密码复杂度不满足要求 10046*/
    HWMLoginErrorNewPwdCannotSameWithHistroyPwd = 206030009,/** 新密码不能与最近旧密码相同  10047*/
    HWMLoginErrorModPwdTooFrequently = 206030011,           /** 上次修改密码后5分钟内不能更新密码 10048*/
    HWMLoginErrorNewPwdCannotContainAccount = 206030012,    /** 密码不能包含账号或其逆序账号  10049*/
    HWMLoginErrorNeedMobileBind = 412200005,                /** 需要绑定手机 10050 */
    HWMLoginErrorNeedMailBind = 412200006,                  /** 需要绑定邮箱  10051*/
    HWMLoginErrorAccountIsNotExist = 206010058,             /** 验证码登录，该用户不存在(跳转完善信息界面 ) 10052*/
    HWMLoginErrorInvalidToken = 206020000,                  /** token失效  10053*/
    HWMLoginErrorIlleaglRequest = 200000004,                /** token失效  */
    HWMLoginErrorButt,                                      /**< 错误结束位置，无实际意义*/
};
#pragma mark - sdk自定义错误码
static NSInteger const HWMErrorCodeSipDisenable = 14;        // sip 断开，sdk上报
static NSInteger const HWMErrorCodeSVNDetectFailed = 411000017; // svn端口探测失败
static NSInteger const HWMErrorCodeRTCLibLoadFailed = 411000020; // rtc库加载失败，不支持rtc会议
static NSInteger const HWMErrorCodeSwitchRoleConfPause = 411000021; // 转角色的时候会议正处于观众暂停观看状态
static NSInteger const HWMErrorCodeJoinPairConfBusy = 411000029; // 大屏已在会议中
static NSInteger const HWMErrorCodeLoginJsonError = 412100016;
static NSInteger const HWMErrorCodeLoginCaVerifyFailed = 412100012;
static NSInteger const HWMErrorCodeConfCtrlTimeout = 414100003; // 匿名入会网络不佳
static NSInteger const HWMErrorCodeConfCtrlDnsError = 414100005; // 匿名入会网络不佳
static NSInteger const HWMErrorCodeConfCtrlRequestFailed = 414100006; // 匿名入会网络不佳
static NSInteger const HWMErrorCodeConfCtrlAuthFailed = 414100007; // 匿名入会网络不佳
static NSInteger const HWMErrorCodeSessionTimerTimeout = 414100041; // 会话心跳超时挂断
static NSInteger const HWMErrorCodeNostreamHangup = 414100042; // 无码流挂断
static NSInteger const HWMErrorCodeChairHangup = 414100043; // 主席挂断
static NSInteger const HWMErrorCodeStopConfHangup = 414100044; // 结束会议挂断
static NSInteger const HWMErrorCodeConfEndSelfEnd = 414100049; // 自己结束会议

#pragma mark - sdk透传服务端错误码
static NSInteger const HWMConfCtrlSystemFailCode = 111070003; // 系统处理失败 84
static NSInteger const HWMConfDataNotFound = 111070005; // 会议不存在 127
static NSInteger const HWMConfVMRDataNotFound = 111070006; // VMR会议室不存在
static NSInteger const HWMConfAuthenNeedPwd = 111070009; //需要输入会议密码 169
static NSInteger const HWMConfRoleAuthenticationFailed = 111070010; // 用户无权查看会议 91
static NSInteger const HWMConfVMROnlyAllowChairStartConf = 111071004; // VMR会议不允许来宾在主席入会前入会 95
static NSInteger const HWMConfVMRConfConflict = 111071005; // 创会时间冲突
static NSInteger const HWMConfStartTimeOverMaxScheduleTime = 111071014; // 会议开始时长超出最大可预定时间范围
static NSInteger const HWMConfSMSIllegal = 111071025; // 请检查与会人手机号是否正确
static NSInteger const HWMNotifyAnonyJoinConfMsgPwdTooMuch = 111071052; // 密码输入次数过多，已被锁定 170
static NSInteger const CRET_LINK_LOGIN_LOCK = 111071053; // 链接登录锁定 102
static NSInteger const HWMNotifyAnonyJoinConfMsgNotAllowAdvance = 111071058; // 会议不允许来宾提前入会 103 171
static NSInteger const HWMConfSizeOverCommunalVMRMaxNum = 111071059; // 与会方超出专用VMR套餐的最大与会人数 104
static NSInteger const HWMConfOrgConcurrentParticipantsNumberIsZero = 111071060; // 企业未购买并发与会方资源，无法创建会议
static NSInteger const HWMConfModifyFailAsConfAlreadyStarted = 111071065; // 正在召开会议，无法编辑会议详情
static NSInteger const HWMConfCancelFailAsConfStarted = 111071067; // 当前会议正在召开，无法取消
static NSInteger const HWMNotifyAnonyJoinConfMsgConfEnded = 111071072; // 会议已结束 112
static NSInteger const HWMConfNotAllowAnonymous = 111071073; // 您呼叫的会议不允许匿名用户呼入，请联系会议预订者
static NSInteger const HWMConfOnlyAllowUserInOrg = 111071074; // 您呼叫的会议只允许企业内用户呼入，请联系会议预订者
static NSInteger const HWMConfOnlyAllowUserInvited = 111071075; // 您呼叫的会议只允许被邀请用户呼入，请联系会议预订者
static NSInteger const HWMErrorCodeVMRConfConflict = 111071106; // VMR会议冲突 192
static NSInteger const HWMConfCtrlAddAttendFailedDueToMediaResourceLimit = 111072019; // 添加联系人时，媒体资源不足导致失败 191
static NSInteger const HWMRecordTypeErrorTypeResourceNotEnough = 111072022; // 录播资源不足
static NSInteger const HWMConfSiteCallNumberIsEmpty = 111072031; // 请检查与会人手机号是否为空
static NSInteger const HWMConfSiteCallNumberIllegalUri = 111072033; // 请检查与会人入会号码是否正确
static NSInteger const HWMConfLocked = 111072050; // 会议已经被锁定
static NSInteger const HWMNotifyAnonyJoinConfMsgConfNotExist = 111072065; // 会议不存在或者密码错误 127
static NSInteger const HWMRecordTypeErrorTypeSpaceReached = 111072067; // 录播空间不足 123
// 已经有主持人的情况下,来宾没有再次申请主持人权限的错误码
//(场景: 输入主持人密码,点击申请前,有其他普通用户申请到了主席身份,此时再点击申请返回179)
static NSInteger const HWMConfCtrlGuestNoPermissionErrorCode = 111072070;
static NSInteger const HWMErrorCodeOverMaxParticipantNumber = 111072101; // 会议人数超过上限
static NSInteger const HWMErrorCodeMaxAttendeesHandReached = 111072102; // 观众超过最大允许举手数 187
static NSInteger const HWMErrorCodeMaxAttendeesSpeakReached = 111072103; // 观众超过最大允许发言数 188
static NSInteger const HWMErrorCodeNoInviteScreenShareCapability = 111072111; // 被转方版本太低，没有邀请共享的能力
static NSInteger const HWMErrorCodeMaxAttendeesReached = 111072202; // 观众已满，无法加入 186
static NSInteger const HWMErrorCodeMaxPanelistsReached = 111072203; // 嘉宾已满，无法加入 185
static NSInteger const HWMErrorCodeWebinarInUse = 111072204; // 网络研讨会功能正在被使用 190
static NSInteger const HWMErrorCodeNoSwitchRoleCapability = 111072207; // 被转方版本太低，没有转换角色的能力 193
static NSInteger const HWMErrorCodeNoLocalRecordCapability = 111072208;// 客户端不支持本地录制
static NSInteger const HWMErrorCodeVmrMeetingRoomIsNotAvailable = 111073007; // 专用VMR会议室状态不可用 133
static NSInteger const HWMErrorCodeWebinarVmrMeetingRoomIsNotAvailable = 111073013; //  网络研讨会VMR会议室状态不可用
static NSInteger const HWMConfParticipantVMRResourceNotEnough = 111076003; // 云会议室同时在线人数已达上限
static NSInteger const HWMConfCtrlAddAttendFailedDueToNumResourceLimit = 111076004; // 添加联系人时，企业资源不足导致失败 156
static NSInteger const HWMConfParticipantApplyResourceFailed = 111081003; /**< 申请会场资源失败 */
static NSInteger const HWMConfParticipantAuthenticationFailed = 111081006; // 认证失败
static NSInteger const HWMConfParticipantConfIsLocked = 111081007; // 会议已经被锁定
static NSInteger const HWMConfWaitingRoomResourcesLimit = 111081010; // 等候室资源不足
static NSInteger const HWMNotifyAnonyJoinConfMsgGetSliderFailed = 111100001; // 获取滑块图片失败 158
static NSInteger const HWMNotifyAnonyJoinConfMsgSliderVerifyFailed = 111100002; // 滑块验证失败 159
static NSInteger const HWMNotifyAnonyJoinConfMsgRandomInvaild = 111100003; // random无效，需要重新获取random 160
static NSInteger const HWMNotifyAnonyJoinConfMsgSliderInvaild = 111100004; // 无效的滑块，需要重新进行滑块验证 161
static NSInteger const HWMNotifyAnonyJoinConfMsgNeedSlider = 111100005; // 需要滑块验证 162
static NSInteger const HWMNotifyAnonyJoinConfMsgPhoneNumberInvaild = 111100006; // 手机号不合法 163
static NSInteger const HWMNotifyAnonyJoinConfMsgSendSmsFailed = 111100007; // 发送验证码失败 164
static NSInteger const HWMNotifyAnonyJoinConfMsgSmsInvaild = 111100008; // 验证码已失效，需要重新申请验证码(重新滑块验证) 165
static NSInteger const HWMNotifyAnonyJoinConfMsgSmsError = 111100009; // 验证码错误，请重新输入验证码 166
static NSInteger const HWMNotifyAnonyJoinConfMsgSmsTooMuch = 111100010; // 验证码输入次数过多，需要重新滑块验证 167
static NSInteger const HWMNotifyAnonyJoinConfMsgUuidInvaild = 111100011; // uuid无效，需要验证手机号 168
static NSInteger const HWMErrorCodeJoinMismatchedSite = 111100012; // 加入的会议所属站点不匹配 175
static NSInteger const HWMNotifyAnonyJoinConfMsgAuthNeedMobileVerify = 111100013; // 需要验证手机号，海外接入国内，免费企业需要进行手机验证码校验
static NSInteger const HWMConfNotSupportWaitingRoom = 111112008; // 终端能力不支持等候室
static NSInteger const HWMConfCorpConferenceResourceHasBeenRunout = 115022001; // 企业购买的会议资源（人数限制）已达上限 15022001
static NSInteger const HWMConfUserAuthenticationFailed = 118000000; // random入会，用户鉴权失败

static NSInteger const HWMErrorCodeDisableShiMoAndApplyOperateFail = 111113101; // 未开启石墨，并且申请临时权限失败

#pragma mark - 终端自定义错误码
static NSInteger const HWMRejectReasonNotSupportAbility = 420000001; // 邀请操作时终端不支持该操作
static NSInteger const HWMRejectReasonUserReject = 420000002; // 邀请操作时用户点击拒绝
static NSInteger const HWMRejectReasonUnknown = 420000003; // 邀请操作时位置原因拒绝

#pragma mark - 呼叫相关错误码
static NSInteger const HWMErrorCodeCalleeAnswerTimeOut = 510000480;  /**< 被叫接听超时（未接通） */
static NSInteger const HWMErrorCodeCalleeBusy = 510000486;  /**< 被叫正忙（未接通） */
static NSInteger const HWMErrorCodeCallerHangUp = 510000487;  /**< 主叫挂断（未接通） */
static NSInteger const HWMErrorCodeCalleeHangUp = 510000603;  /**< 被叫挂断 （未接通） */

static NSString *const HWMErrorMsgContactNotFound = @"联系人不存在";
static NSString *const HWMErrorMsgContactArgsEmpty = @"账号和号码不能都为空";
static NSString *const HWMErrorMsgArgsError = @"参数错误";
static NSString *const HWMErrorMsgRepeatRequest = @"重复调用方法";
static NSString *const HWMErrorMsgTimeOut = @"调用方法超时";
static NSString *const HWMErrorMsgUnInit = @"sdk 未初始化";
static NSString *const HWMErrorMsgArgsLengthOverrun = @"参数长度超限";
static NSString *const HWMErrorMsgContactPasswordOrAccountEmpty = @"账号或密码不能都为空";
static NSString *const HWMErrorMsgConfIdEmpty = @"会议id不能为空";
static NSString *const HWMErrorMsgUnLogin = @"未登录";
static NSString *const HWMErrorMsgLoginIng = @"登录中";
static NSString *const HWMErrorMsgSubjectTooLong = @"会议主题长度不能超过50";
static NSString *const HWMErrorMsgConfIdTooLong = @"会议ID长度不能超过16";
static NSString *const HWMErrorMsgConfOrCallExit = @"您正处在会议或者呼叫中";
static NSString *const HWMErrorMsgContactAPPIDInfoIllegal = @"APPID登录参数错误";
static NSString *const HWMErrorMsgNetworkUnreachable = @"网络不可用，请检查网络设置";
static NSString *const HWMErrorMsgImageArgsEmpty = @"图片路径不能为空";
static NSString *const HWMErrorMsgNotInMeeting = @"没有在会议中";
static NSString *const HWMErrorMsgNoPermissionAddAttendee = @"没有权限添加与会者";
static NSString *const HWMErrorMsgNoPermissionEndConf = @"没有权限结束会议";
static NSString *const HWMErrorMsgLeaveConfFail = @"离开会议失败";
static NSString *const HWMErrorMsgLogined = @"已登录";
static NSString *const HWMErrorMsgCustomInfoTooLong = @"自定义信息长度不能超过64";
static NSString * const HWMErrorMsgStartTimeInvalidFormat = @"开始时间格式不对";
static NSString * const HWMErrorMsgStartTimeEarlierThanNow = @"开始时间早于当前时间";
static NSString * const HWMErrorMsgTimeZoneError = @"时区错误";
static NSString * const HWMErrorMsgConfDurationEqualToZero = @"会议时长错误";
static NSString * const HWMErrorMsgGuestPwdError = @"会议密码长度不符（4-16位）";
static NSString * const HWMErrorMsgScanCodeExpired = @"二维码过期";
static NSString * const HWMErrorMsgScanCodeNotSupported = @"不支持的二维码";
static NSString * const HWMErrorMsgScanCodeEarlierVersion = @"大屏版本低";
static NSString * const HWMErrorMsgPermission = @"没有权限";
static NSString * const HWMErrorMsgCancel = @"用户取消";
static NSString * const HWMErrorMsgMultiDeviceOnline = @"多终端登录";
static NSString * const HWMErrorMsgSipDisable = @"呼叫不可用";
static NSString * const HWMErrorMsgConfIdError = @"会议ID不可为空";
static NSString * const HWMErrorMsgNickEmpty = @"昵称不可为空";
static NSString * const HWMErrorMsgNickTooLong= @"昵称不能超过64";
static NSString * const HWMErrorMsgCallOrCallExist= @"已经存在一路会议/呼叫";
static NSString * const HWMErrorMsgConfNeedPassword = @"匿名会议需要密码";
static NSString * const HWMErrorMsgConfUnLogin = @"未登录";
static NSString * const HWMErrorMsgConfLoginIng = @"登录中";
static NSString * const HWMErrorMsgQRCodeNotSupported = @"不支持的二维码";
static NSString * const HWMErrorMsgNetworkUnReachable = @"网络异常";
static NSString * const HWMErrorMsgUserCancelPhoneVerify = @"用户取消手机验证";
static NSString * const HWMErrorMsgSeesionExpired = @"会话已过期";
static NSString * const HWMErrorMsgOuterInject = @"外界拦截注入";
static NSString * const HWMErrorMsgNotSupportCapability = @"不支持该能力";

static NSString * const HWMErrorMsgFeedbackParamError = @"参数错误";
static NSString * const HWMErrorMsgFeedbackZipPathEmpty = @"待上传的zip文件路径是空";
static NSString * const HWMErrorMsgFeedbackZipInfoError = @"获取zip文件信息失败";
static NSString * const HWMErrorMsgFeedbackZipSizeExceedLimit = @"zip文件大小超出限制";
static NSString * const HWMErrorMsgFeedbackGetUploadInfoFail = @"获取上传信息失败";
static NSString * const HWMErrorMsgFeedbackUploadInfoEmpty = @"获取到的上传信息是空";
static NSString * const HWMErrorMsgFeedbackTimesIsMax = @"反馈文件次数已达上限";
static NSString * const HWMErrorMsgFeedbackRedirectFail = @"重定向失败";
static NSString * const HWMErrorMsgFeedbackFolderPathEmpty = @"反馈文件夹路径是空";
static NSString * const HWMErrorMsgFeedbackNetError = @"网络不可用";
#endif /* HWMErrorDefine_h */
