//
//  HWMP2PConfRecordInfoModel.h
//  HWMUISDK
//
//  Created by lining on 2023/9/21.
//  Copyright © 2023 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMCallMemberInfo.h"
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMP2PConfRecordInfoModel : NSObject

/// 主叫方信息
@property (nonatomic, strong) HWMCallMemberInfo *callerInfo;
/// 被叫方信息
@property (nonatomic, strong) HWMCallMemberInfo *calleeInfo;
/// 呼叫开始时间
@property (nonatomic, assign) NSInteger startTime DEPRECATED_MSG_ATTRIBUTE("Use 'startTimeStamp' instead");
/// 呼叫结束时间
@property (nonatomic, assign) NSInteger endTime DEPRECATED_MSG_ATTRIBUTE("Use 'endTimeStamp' instead");
/// 呼叫开始时间戳
@property (nonatomic, assign) NSTimeInterval startTimeStamp;
/// 呼叫结束时间戳
@property (nonatomic, assign) NSTimeInterval endTimeStamp;
/// 媒体类型
@property (nonatomic, assign) HWMMediaType mediaType;
/// 是否为主动呼出
@property (nonatomic, assign) BOOL isCallOut;
/// 呼叫是否建立
@property (nonatomic, assign) BOOL isCallEstablished;
/// 呼叫结束原因码
@property (nonatomic, assign) HWMSDKERR resultCode;
/// 呼叫结束原因描述
@property (nonatomic, copy) NSString *resultMsg;

@end

NS_ASSUME_NONNULL_END
