//
//  HWMPrivateApi.h
//  HWMUISDK
//
//  Created by 融合软终端02 on 2020/4/9.
//  Copyright © 2020 huawei. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMContactSelectedModel.h"
#import "HWMControllerConfig.h"
#import "HWMConfDetail.h"
#import "HWMInternalStartCallParam.h"
#import "HWMConfContactModel.h"
#import "HWMGlobalUIConfig.h"
#import "HWMLinkJoinConfParam.h"
#import "HWMSocialShareHandler.h"
#import "HWMConfUIDefine.h"
#import "HWMSDKVmrInfoListModel.h"
#import "HWMLeaveConfMenuHandler.h"
#import "HWMPrivateConfUIHandler.h"
#import "HWMVirtualBackgroundImageConfig.h"
#import "HWMPrivacyAgreementHandler.h"
#import "HWMConfUIPrivateDefine.h"
#import "HWMAnonymousJoinConfBySignatureInfo.h"
#import "HWMSDKDeployInfoModel.h"
#import "HWMStartCTDCallParam.h"
#import "HWMSdkDefine.h"

@class HWMHardTerminalViewParam;
@class HWMLoginInfo;
@class HWMPrivateNotifyHandler;
@class HWMConfInfo;
@class HWMSDKCallRecordInfoModel, HWMSDKMeetingInfoModel;
@class HWMSDKModifyVmrParamModel;
@class HWMSDKInviteHardTerminalParamModel;

NS_ASSUME_NONNULL_BEGIN

// 保密通话加解密函数
typedef uint32_t (*HWMVoipEncryptHandler)(int8_t *pcIn, int32_t iInLength, int8_t *pcOut, int32_t *piOutLength);
typedef uint32_t (*HWMVoipDecryptHandler)(int8_t *pcIn, int32_t iInLength, int8_t *pcOut, int32_t *piOutLength);

@interface HWMPrivateApi : NSObject

/// 设置全局配置
- (void)setGlobalUIConfig:(HWMGlobalUIConfig *)config;

/// 获取全局配置
- (HWMGlobalUIConfig *)getGlobalUIConfig;

/// 显示会议列表界面
/// @param config 导航栏样式配置
/// @param animated 是否需要动画
- (void)openConfListWitConfig:(HWMControllerConfig * _Nullable)config animated:(BOOL)animated;

- (void)feedbackLogByEMail;

/// 反馈日志
- (void)feedbackLog:(void (^)(NSError *error))callback;

/// 链接入会
- (void)joinConfByLink:(HWMLinkJoinConfParam *)param callback:(void (^)(NSError *error))callback;

/// 快速匿名安全入会
- (void)anonymousJoinConfBySignatureInfo:(HWMAnonymousJoinConfBySignatureInfo *)anonymousJoinConfBySignatureInfo passwordAlertEvent:(void(^)(HWMJionConfPasswordAlertEventType pwdEventType))event callback:(void (^)(NSError * error))callback;

/// 邀请硬终端入会
- (void)inviteHardTerminal:(HWMSDKInviteHardTerminalParamModel *)param callabck:(void(^)(NSError *error))callback;

/// 显示会议二维码界面
- (void)openConfQRCodeWithConfInfo:(HWMConfDetail *)confInfo shareType:(HWMShareConfType)shareType;

/// 获取登录信息
- (HWMLoginInfo *)getMyInfo;

/// 通过account token登录
- (void)loginWithAccount:(NSString *)account token:(NSString *)token completeHandler:(void (^_Nonnull)(NSError *_Nullable error))handler;

- (void)sipDeregister;

/// 是否存在通话
- (BOOL)isCallExist DEPRECATED_ATTRIBUTE;

/// 是否为视频通话
- (BOOL)isVideoCall DEPRECATED_ATTRIBUTE;

/// 是否存在会议
- (BOOL)isConfExist;

/// 是否为视频会议
- (BOOL)isVideoConf;

/// Pstn权限是否开启(只能会前使用)
- (BOOL)isPstnEnable;

/// 录制功能是否开启
- (BOOL)isRecordOn;

/// 设备是否支持硬编码
- (BOOL)isSupportVideoHdEncoder;

/// 设置高清视频优先 成功返回YES
- (BOOL)setHDPref:(BOOL)isHDPref;

/// 设置显示引导类提示类型
- (void)setShowGuideTips:(HWMGuideTips)guideTips;

/// 是否为免费个人
- (BOOL)isPublicRegister;

/// 显示匿名入会界面
- (void)openAnonymousJoinPage:(HWMControllerConfig * _Nullable)config animated:(BOOL)animated;

/// 显示 已登录用户入会界面
- (void)openJoinConfPage:(HWMControllerConfig * _Nullable)config animated:(BOOL)animated;

/// 设置屏幕共享插件名称（bundle尾缀名称）
- (void)setShareExtensionName:(NSString *)extensionName;

/// 发起呼叫
/// @param param 呼叫参数
/// @param isEncrypt 是否保密
/// @param callback 结果回调
- (void)startCallWithParam:(HWMInternalStartCallParam *)param isEncrypt:(BOOL)isEncrypt callback:(void(^)(NSError *error))callback;

/// 是否是保密通话
- (void)setEncryptCall:(BOOL)isEncryptCall;

/// 设置通话芯片加密开关
/// @param isEncrypt 是否加密
- (void)switchAudioChipEncrypt:(BOOL)isEncrypt;

/// 设置通话加解密函数
/// @param encryptHnadler 加密函数
/// @param decryptHandler 解密函数
- (HWMSDKERR)setVoipEncryptDecryptHandler:(HWMVoipEncryptHandler)encryptHnadler decryptHandler:(HWMVoipDecryptHandler)decryptHandler;

- (void)openContactSelectPage:(NSArray<HWMConfContactModel *> *)param
         scene:(HWMSelectedContactScene)scene
completeHander:(void(^)(NSArray<HWMContactSelectedModel *> *result, NSError *error))handler;



/// 获取当前会议列表
- (NSArray<HWMConfDetail *> *)getConfList;

/// 打开预订会议页面 并设置预置参数
/// @param isVideo 是否是视频会议
/// @param startTime 会议开始时间 格式：YYYY-MM-DD HH:MM 北京时间
/// @param confLen 会议持续时长，单位分钟
/// @param animated 是否使用动画
- (void)openBookConfWithIsVideo:(BOOL)isVideo startTime:(NSString *)startTime confLen:(NSUInteger)confLen animated:(BOOL)animated;


/// 打开发起会议页面 并设置预置参数
/// @param isVideo 是否是视频会议
/// @param animated 是否使用动画
- (void)openCreateConfWithIsVideo:(BOOL)isVideo animated:(BOOL)animated;


/// 配置打点信息的租户Id
/// @param tenantId 租户ID
- (void)configTrackerTenantId:(NSString *)tenantId;

/// 获取会中信息
- (HWMSDKMeetingInfoModel *)getConfInfo;

/// 获取通话信息
- (HWMSDKCallRecordInfoModel *)getCallInfo DEPRECATED_ATTRIBUTE;

/// 获取vmr信息
- (void)fetchVmrInfoSuccessCallback:(void(^)(HWMSDKVmrInfoModel *personalVmrInfo, HWMSDKVmrInfoListModel * cloudVmrList))successBlock failedCallback:(void(^)(NSError * _Nullable error))failedBlock;

/// 会中改变vmr信息
-(void)changeVmrInfo:(HWMSDKModifyVmrParamModel *)param completeHandler:(void (^)(NSError *error))completeHandler;

/// 转换错误码
/// @paramerrorCode 原错误码
- (NSInteger)transformErrorCode:(NSInteger)errorCode;

/// 匿名入会是否显示悬浮窗按钮
- (void)setShowFloatButtonWhenAnonymousJoinConf:(BOOL)isShow;

/// 离开会议按钮
- (void)setLeaveConfMenuHandler:(id <HWMLeaveConfMenuHandler>)handler;

/// 私有会议UI定制代理
- (void)setPrivateConfUIHandler:(id<HWMPrivateConfUIHandler>)handler;

/// 设置虚拟背景默认图片(图片格式: jpg/jpeg, 图片尺寸: 最大4096*4096, 最小160*160)
- (void)setVirtualBackgroundDefaultImages:(HWMVirtualBackgroundImageConfig *)defaultImageConfig DEPRECATED_ATTRIBUTE;

- (NSString *)queryNickNameFromCache;

/// 隐私声明和服务协议注入(当前涉及: 手机号验证页面)
- (void)setPrivacyAgreementHandler:(id<HWMPrivacyAgreementHandler>)handler;

/// 设置证书校验模式
- (void)setTLSVerifyMode:(HWMVerifyMode)mode;

/// MaxHub扫码配对入会
/// @param pairCode 配对码
- (void)maxhubPairWithPairCode:(NSString *)pairCode callback:(void (^)(NSError *error))callback DEPRECATED_ATTRIBUTE;

/// 大屏是否已配对
- (BOOL)isPaired DEPRECATED_ATTRIBUTE;

/// 结束配对
- (void)endQrCodePair DEPRECATED_ATTRIBUTE;

/// 加入配对会议
/// @param confId 会议ID
/// @param handler 回调
- (void)joinPairConf:(NSString *)confId callback:(void (^_Nonnull)(NSError  * _Nullable error))handler DEPRECATED_ATTRIBUTE;

/// 开启/关闭扬声器
/// @param isSpeakerOn 开/关
/// @return 修改成功/失败
- (BOOL)setSpeakerOn:(BOOL)isSpeakerOn;

/// 获取扬声器开关
/// @return 开/关
- (BOOL)isSpeakerOn;

/// 会中切换音频状态
/// @param isConnected 是否连接音频
- (void)setAudioState:(BOOL)isConnected;

/// 获取音频状态
- (BOOL)isAudioStateConnected;

/// 设置部署模式及对应地址和端口
- (HWMSDKERR)setDeployInfo:(HWMSDKDeployInfoModel *)deployInfo;

/// 发起回呼
- (void)startCTDCall:(HWMStartCTDCallParam *_Nonnull)param callback:(HWMSDKCreateConfCompleteHandler)callback;

/// 获取本地鉴权token
- (NSString *)getJwtToken;

/// 设置自定义信息
/// @param customInfo  自定义信息
/// @param callback 回调
- (void)setMeetingCustomInfo:(NSString *)customInfo callback:(HWMSDKCompleteHandler _Nonnull)callback;

@end

NS_ASSUME_NONNULL_END
