﻿/**
* @file HwmDataBaseDef.h
*
* Copyright(C), 2024-2025, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
*
* @brief Xxxxxx.
*/

#ifndef __HWM_DATA_BASE_DEF_H__
#define __HWM_DATA_BASE_DEF_H__

#import "HwmSdkCommonDef.h"

BEGIN_HWM_SDK_NAMESPACE

#define DB_MAX_KEY_LEN      128
#define DB_MAX_VAL_LEN      1960
#define DB_MAX_ACCOUNT      129
#define DB_MAX_PASSWD       256
#define DB_MAX_RANDOM       256
#define DB_MAX_TIMESTAMP    32
#define DB_MAX_TENANTCN     151
#define DB_MAX_TENANTEN     128
#define DB_MAX_TENANTID     128
#define DB_MAX_TOKEN        512
#define DB_MAX_AUTHTYPE     4
#define DB_MAX_LOGINURL     512
#define DB_MAX_USERIV       289
#define DB_MAX_CONTACTID    129
#define DB_MAX_FAX          33
#define DB_MAX_EMAIL        257
#define DB_MAX_ZIP          33
#define DB_MAX_TITLE        256
#define DB_MAX_IMAGEID      64
#define DB_MAX_WEBSITE      64
#define DB_MAX_BINDNO       33
#define DB_MAX_STAFFNO      33
#define DB_MAX_CORPNAME     256
#define DB_MAX_DEPTID       33
#define DB_MAX_IMNO         33
#define DB_MAX_SYNCTIME     64
#define DB_MAX_NAME         33     
#define DB_MAX_PINYIN       33
#define DB_MAX_PHONE        33
#define DB_MAX_ESPACE       33
#define DB_MAX_ADDRESS      256
#define DB_MAX_DEPTNAME     512
#define DB_MAX_SIGNATURE    256
#define DB_MAX_NATIVENAME   64
#define DB_MAX_DESC         33
#define DB_MAX_FORENAME     64
#define DB_MAX_NICKNAME     64
#define DB_MAX_NODIFYTIME   64  
#define DB_MAX_ETAGS        64
#define DB_MAX_TIMESTAMP    32
#define DB_MAX_VMRID        32
#define DB_MAX_DEPTLNAME    512
#define DB_MAX_EMPLOYEET    8
#define DB_MAX_WORKID       101
#define DB_MAX_ASSIST       551
#define DB_MAX_EXTINFO
#define DB_MAX_DEPTIDLIST   512
#define DB_MAX_CONTACTYPE   64
#define DB_MAX_COUNTRYINFO  32
#define DB_MAX_DEPTCODE     64
#define DB_MAX_FULLNAME     512
#define DB_MAX_CALLNUM      32
#define DB_MAX_CONFID       32
#define DB_MAX_CONFPWD      64
#define DB_MAX_GROUPID      64
#define DB_MAX_EXPARAMS     256
#define DB_MAX_ETAG         128
#define DB_MAX_SALT         512
#define DB_MAX_FULL_DEPT_NAME     2550

typedef struct tagDBSysKeyValue
{
    HWM_INT32 id;
    HWM_CHAR strkey[DB_MAX_KEY_LEN];
    HWM_CHAR strvalue[DB_MAX_VAL_LEN];
}DBSysKeyValue;

typedef struct tagDBMatchInfo
{
    HWM_CHAR match_value[DB_MAX_VAL_LEN];
    HWM_UINT32 keytype;
}DBMatchInfo;

typedef struct tagDBLoginInfo
{
    HWM_INT32 id;
    HWM_CHAR account[DB_MAX_ACCOUNT];
    HWM_CHAR displayaccount[DB_MAX_ACCOUNT];
    HWM_CHAR userpwd[DB_MAX_PASSWD];
    HWM_BOOL isautologin;
    HWM_BOOL isrememberpwd;
    HWM_CHAR userrandom[DB_MAX_RANDOM];
    HWM_CHAR timestamp[DB_MAX_TIMESTAMP];
    HWM_CHAR tenantcn[DB_MAX_TENANTCN];
    HWM_CHAR tenanten[DB_MAX_TENANTEN];
    HWM_CHAR tenantid[DB_MAX_TENANTID];
    HWM_BOOL thirdcertype;
    HWM_BOOL isMaxhubWorkplace;
    HWM_CHAR thirdaccount[DB_MAX_ACCOUNT];
    HWM_CHAR maxhubMiddleEndAddress[DB_MAX_ADDRESS];
    HWM_CHAR setPasswordToken[DB_MAX_TOKEN];
    HWM_CHAR thirdAuthType[DB_MAX_AUTHTYPE];
    HWM_CHAR thirdLoginUrl[DB_MAX_LOGINURL];
    HWM_INT32  realNameAuth;
    HWM_CHAR useriv[DB_MAX_USERIV];
    HWM_INT32  sitetype;
    HWM_CHAR refreshToken[DB_MAX_TOKEN];
}DBLoginInfo;

typedef struct tagDBContactInfo
{
    HWM_INT32  id;
    HWM_CHAR contactid[DB_MAX_CONTACTID];
    HWM_INT32 staffid;
    HWM_CHAR account[DB_MAX_ACCOUNT];
    HWM_CHAR showaccount[DB_MAX_ACCOUNT];
    HWM_CHAR name[DB_MAX_NAME];
    HWM_CHAR qpinyin[DB_MAX_PINYIN];
    HWM_INT32 gender;
    HWM_CHAR mobilephone[DB_MAX_PHONE];
    HWM_CHAR officephone[DB_MAX_PHONE];
    HWM_CHAR officephone2[DB_MAX_PHONE];
    HWM_CHAR espacenumber[DB_MAX_PHONE];
    HWM_CHAR otherphone[DB_MAX_PHONE];
    HWM_CHAR fax[DB_MAX_FAX];
    HWM_CHAR email[DB_MAX_EMAIL];
    HWM_CHAR zip[DB_MAX_ZIP];
    HWM_CHAR address[DB_MAX_ADDRESS];
    HWM_CHAR title[DB_MAX_TITLE];
    HWM_CHAR deptname[DB_MAX_DEPTNAME];
    HWM_CHAR imageid[DB_MAX_IMAGEID];
    HWM_CHAR signature[DB_MAX_SIGNATURE];
    HWM_CHAR website[DB_MAX_WEBSITE];
    HWM_CHAR bindno[DB_MAX_BINDNO];
    HWM_CHAR nativename[DB_MAX_NATIVENAME];
    HWM_CHAR staffno[DB_MAX_STAFFNO];
    HWM_CHAR corpname[DB_MAX_CORPNAME];
    HWM_CHAR deptid[DB_MAX_DEPTID];
    HWM_CHAR deptnamecn[DB_MAX_DEPTNAME];
    HWM_CHAR deptnameen[DB_MAX_DEPTNAME];
    HWM_CHAR desc[DB_MAX_DESC];
    HWM_CHAR foreignname[DB_MAX_FORENAME];
    HWM_CHAR imno[DB_MAX_IMNO];
    HWM_CHAR imagesynctime[DB_MAX_SYNCTIME];
    HWM_CHAR ipphone[DB_MAX_PHONE];
    HWM_INT32 issecurity;

    HWM_CHAR nickname[DB_MAX_NICKNAME];
    HWM_CHAR oldaccount[DB_MAX_ACCOUNT];
    HWM_CHAR shortphone[DB_MAX_PHONE];
    HWM_CHAR voip[DB_MAX_PHONE];
    HWM_CHAR modifytime[DB_MAX_NODIFYTIME];
    HWM_CHAR homephone[DB_MAX_PHONE];
    HWM_CHAR otherphone2[DB_MAX_PHONE];
    HWM_CHAR etag[DB_MAX_ETAGS];
    HWM_CHAR exparam[DB_MAX_EXPARAMS];
    HWM_CHAR timestamp[DB_MAX_TIMESTAMP];
    HWM_INT32 isExternalContact;
    HWM_CHAR vmrid[DB_MAX_VMRID];
    HWM_INT32 externalType;
    HWM_INT32 isHardTerminal;
    HWM_INT32 mobileCountry;
    HWM_INT32 officePhoneCountry;
    HWM_UINT32 isRestrictedUser;
    HWM_CHAR deptL1Name[DB_MAX_DEPTLNAME];
    HWM_CHAR display_dept[DB_MAX_DEPTLNAME];
    HWM_CHAR deptInfoList[DB_MAX_DEPTLNAME];
    HWM_CHAR employeeType[DB_MAX_EMPLOYEET];
    HWM_CHAR workId[DB_MAX_WORKID];
    HWM_CHAR personAssistantAll[DB_MAX_ASSIST];
    HWM_CHAR extInfo[DB_MAX_EXPARAMS];
    HWM_BOOL isCollect;
    HWM_CHAR deptIdList[DB_MAX_DEPTIDLIST];
    HWM_CHAR contactType[DB_MAX_CONTACTYPE];
    HWM_CHAR countryInfo[DB_MAX_COUNTRYINFO];
    HWM_CHAR deptCodes[DB_MAX_DEPTCODE];
    HWM_CHAR deptFullName[DB_MAX_FULL_DEPT_NAME];
}DBContactInfo;

typedef struct tagDBKeyValue
{
    HWM_INT32 id;
    HWM_CHAR strkey[DB_MAX_KEY_LEN];
    HWM_CHAR strvalue[HWM_MAX_DB_VALUE_LEN];
}DBKeyValue;

typedef struct tagDBCallRecord
{
    HWM_INT32 id;
    HWM_CHAR peeraccount[DB_MAX_ACCOUNT];
    HWM_INT32  iscallout;
    HWM_CHAR callernumber[DB_MAX_CALLNUM];
    HWM_CHAR calleenumber[DB_MAX_CALLNUM];
    HWM_INT32  callstate;
    HWM_INT32  calltype;
    HWM_CHAR confid[DB_MAX_CONFID];
    HWM_CHAR confpasscode[DB_MAX_CONFPWD];
    HWM_CHAR confmembers[DB_MAX_EXPARAMS];
    HWM_CHAR groupid[DB_MAX_GROUPID];
    HWM_INT64 starttime;
    HWM_INT32  duration;
    HWM_INT32  limitcount;
    HWM_CHAR exparams[DB_MAX_EXPARAMS];
}DBCallRecord;

typedef struct tagDBAvatarTag
{
  HWM_INT32 id;                                
  HWM_CHAR account[DB_MAX_ACCOUNT];                    
  HWM_CHAR etag_small[DB_MAX_ETAG];                    
  HWM_CHAR etag_medium[DB_MAX_ETAG];                    
  HWM_CHAR etag_large[DB_MAX_ETAG];                    
}DBAvatarTag;

typedef struct tagDBSalt
{
    HWM_CHAR strvalue[DB_MAX_SALT];
}DBSalt;

END_HWM_SDK_NAMESPACE

#endif  /* __HWM_DATA_BASE_DEF_H__ */