﻿/**
 * @file HwmNetworkService.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief Xxxxxx.
 */


#ifndef __HWM_PRIVATE_NETWORK_SERVICE_H__
#define __HWM_PRIVATE_NETWORK_SERVICE_H__

#import "HwmPrivateNetworkServiceDef.h"
#import "HwmGlobalErrorCodeDef.h"

BEGIN_HWM_SDK_NAMESPACE
/**
    * @brief
    * [en]This class is about xxxx.
    * [cn]网络服务管理对象
    * @GetInstance HWM_SDK_NAMESPACE::HwmPrivateNativeSDK::GetPrivateNetworkApi()
    */
class IHwmPrivateNetwork
{
public:

    /**
    * @brief
    * [en]This class is about xxxx.
    * [cn]设置服务器地址，usg地址和中台地址
    * @private
    * @mobile:disable
    */
    virtual SDKERR SetServerAddressExt(IN const HWM_SDK_NAMESPACE::ServerInfo* serverInfo, IN const HWM_SDK_NAMESPACE::ServerInfo* middleGroundInfo) = 0;

    /**
    * @brief
    * [en]This class is about xxxx.
    * [cn]获取svn url
    * @synchronized
    * @paramOut
    * @private
    */
    virtual HWM_VOID GetSvnUrl(OUT UrlInfo* svnUrl) = 0;

    /**
    * @brief
    * [en]This class is about xxxx.
    * [cn]获取ms url
    * @private
    * @paramOut
    * @synchronized
    */
    virtual HWM_VOID GetMsUrl(OUT UrlInfo* msUrl) = 0;

    /**
    * @brief
    * [en]This class is about xxxx.
    * [cn]设置Tls认证
    *
    * @param verifyParam [type:VerifyParam][cs_allowNull:N]
    * [en]
    * [cn]认证参数
    * @see VerifyParam
    *
    * @return [type:SDKERR]
    * 
    * @UTInterface:disable
    *
    * @since:v1.0
    *
    */
    virtual SDKERR SetTlsVerify(IN const HWM_SDK_NAMESPACE::VerifyParam* verifyParam) = 0;

    /**
    * @brief
    * [en]This class is about xxxx.
    * [cn]设置本地ip
    *
    * @param localIp [cs_allowNull:Y]
    * [en]
    * [cn]IP地址
    *
    * @UTInterface:disable
    * 
    * @since:v1.0
    */
    virtual SDKERR SetLocalIp(IN const HWM_CHAR* localIp) = 0;

    /**
    * @brief
    * [en]This class is about xxxx.
    * [cn]更新Access描述
    *
    * @param paramList [cs_allowNull:Y]
    * [en]Access description
    * [cn]Access描述
    * 
    * @UTInterface:disable
    *
    * @since:v1.0  
    */
    virtual SDKERR UpdateAccessDesc(IN HwmList<AccessInfo>* paramList) = 0;

    /**
    * @brief
    * [en]set signal proxy
    * [cn]设置信令代理地址
    *
    * @param urlAndPort [cs_allowNull:N]
    * [en]Access description
    * [cn]Access描述
    *
    * @since:v1.0
    */
    virtual SDKERR SetSignalProxy(IN const HWM_CHAR* urlAndPort) = 0;

    /**
    * @brief
    * [en]Set guaranteed IP address
    * [cn]设置(会控)保底ip地址
    *
    * @param addrs [cs_allowNull:N]
    * [cn]多个地址中间用分号隔开, 最多支持4个地址
    * @since:v1.0
    */
    virtual SDKERR SetGuaranteedIpAddresses(IN const HWM_CHAR* pAddresses) = 0;

    /**
    * @brief
    * [en]This interface is used to set guaranteed ip addresses.
    * [cn]设置(管理面)保底ip地址
    *
    * @param guaranteedIpAddressesParam [cs_allowNull:N]
    * @since:v1.0
    */
    virtual SDKERR SetGlobalGuaranteedIpAddresses(IN HwmList<HwmGuaranteedIpAddress>* guaranteedIpAddressesParam) { return SDKERR_SUCCESS; }
 
    /**
    * @brief
    * [en]get audio send socket dscp value
    * [cn]获取音频发送媒体流的dscp值，用于在一些设备上让音频码流能获得优先转发权
    *
	* @pc:disable
	* @ios:disable
	* @synchronized
    */
    virtual HWM_INT32 GetPriorityDscp() = 0;

    /**
    * @brief
    * [en]get media send buf high threshold threshold value
    * [cn]获取媒体发送缓存高阈值，用于一些设备上感知链路层发送缓冲区超大或者恢复事件，单位ms
    *
	* @pc:disable
	* @ios:disable
	* @synchronized
    */
    virtual HWM_INT32 GetModemThresholdHigh() = 0;

    /**
    * @brief
    * [en]get media send buf restore threshold value
    * [cn]获取媒体发送缓存恢复阈值，用于一些设备上感知链路层发送缓冲区超大或者恢复事件，单位ms
    *
	* @pc:disable
	* @ios:disable
	* @synchronized
    */
    virtual HWM_INT32 GetModemThresholdLow() = 0;

    /**
    * @brief
    * [en]report modem buf threshold event
    * [cn]modem buf上报高于高门限/低于低门限事件
    *
    * @param rate [cs_allowNull:N]
    * [en]modem send rate byte/s
    * @param lowBufferTime [cs_allowNull:N]
    * [en]low send queue buf time ms
    * @param highBufferTime [cs_allowNull:N]
    * [en]high send queue buf time ms
	* @pc:disable
	* @ios:disable
	* @synchronized
    */
    virtual SDKERR ModemThresholdEvent(IN HWM_INT32 rate, IN HWM_INT32 lowBufferTime, IN HWM_INT32 highBufferTime) = 0;

    /**
    * @brief
    * [en]notify app get modem bufsize
    * [cn]通知app向kit获取modem buf大小
    *
	* @pc:disable
	* @ios:disable
	* @synchronized
    */
    virtual SDKERR NotifyGetModemBuf() = 0;

    /**
    * @brief
    * [en]for responsing ModemThresholdEvent, app tells sdk modem buf size
    * [cn]响应ModemThresholdEvent消息，app告知sdk modem buf大小
    *
    * @param rate [cs_allowNull:N]
    * [en]modem send rate byte/s
    * @param lowBufferTime [cs_allowNull:N]
    * [en]low send queue buf time ms
    * @param highBufferTime [cs_allowNull:N]
    * [en]high send queue buf time ms
	* @pc:disable
	* @ios:disable
	* @synchronized
    */
    virtual SDKERR ResponseModemBuf(IN HWM_INT32 rate, IN HWM_INT32 lowBufferTime, IN HWM_INT32 highBufferTime) = 0;

    /**
    * @brief
    * [en]get tcp/udp mode
    * [cn]获取tcp/udp 模式
    *
    * @synchronized
    */
    virtual HWM_UINT32 GetMediaTransMode() = 0;

    /**
    * @brief
    * [en]This class is about set inner http proxy.
    * [cn]设置代理
    *
    * @mobile:disable
    *
    * @param proxyInfo [type:ProxyInfo][cs_allowNull:N]
    * [en]
    * [cn]代理信息
    * @see ProxyInfo
    *
    * @return [type:SDKERR]
    *
    * @UTInterface:disable
    *
    * @since:v1.0
    *
    */
    virtual SDKERR SetInnerHttpProxy(IN const HWM_SDK_NAMESPACE::ProxyInfo* proxyInfo) = 0;
};
END_HWM_SDK_NAMESPACE

#endif /* __HWM_NETWORK_SERVICE_H__ */