﻿/**
 * @file HwmLoginServiceDef.h
 *
 * Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
 *
 * @brief Xxxxxx.
 */


#ifndef __HWM_PRIVATE_NETWORK_SERVICE_DEF_H__
#define __HWM_PRIVATE_NETWORK_SERVICE_DEF_H__
#import "HwmNetworkServiceDef.h"
#import "HwmSdkCommonDef.h"

BEGIN_HWM_SDK_NAMESPACE

/**
* [en]This structure is used to describe url parameters.
* [cn]url信息参数
*/
typedef struct tagUrlInfo
{
    HWM_CHAR url[HWM_MAX_URL_LEN];           /**< [en]Indicates the url.
                                             [cn]地址 */
}UrlInfo;

/**
* [en]This structure is used to describe the access info.
* [cn]Access参数
*/
typedef struct tagAccessInfo
{
    HWM_CHAR ip[HWM_MAX_IP_ADDRESS_LEN];
    HWM_CHAR access[HWM_MAX_ACCESS_LEN];
} AccessInfo;

/**
* [en]modem buf report the above high threshold or lower low threshold event.
* [cn]modem buf上报高于高门限/低于低门限事件
*/
typedef enum tagModemBufThresholdEvent
{
    HWM_MODEM_ABOVE_HIGH_THRESHOLD,
    HWM_MODEM_LOWER_LOW_THRESHOLD,
    HWM_MODEM_BUF_BUTT
} ModemBufThresholdEvent;

/**
* [en]Basic IP address information of the domain name.
* [cn]域名保底ip信息
*/
typedef struct tagHwmGuaranteedIpAddress
{
    HWM_CHAR domain[HWM_MAX_URL_LEN];                                     /**< [en]
                                                                          [cn]域名 */
    HWM_CHAR guaranteedIps[HWM_MAX_GURARTEENED_IP_ADDRESS_LEN];           /**< [en] 
                                                                          [cn]保底ip列表，多个地址中间用分号隔开，最多支持4个地址 */
}HwmGuaranteedIpAddress;


/**
* [en]Basic IP address information of the domain name.
* [cn]域名保底ip信息
*/
typedef struct tagHwmGuaranteedIpAddressesParam
{
    HWM_UINT32 addressListSize;                        /**< [en]
                                                            [cn]保底ip信息list长度
                                                            [cs_allowNull:N][length for addressList] */
    HwmGuaranteedIpAddress* addressList;               /**< [en]
                                                            [cn]保底ip信息列表
                                                            [cs_allowNull:N] */
}HwmGuaranteedIpAddressesParam;

END_HWM_SDK_NAMESPACE
#endif /* __HWM_NETWORK_SERVICE_DEF_H__ */

