//
//  HWMConfStateInfo.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/11/16.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMConfStateInfo : NSObject
/// 会议id
@property (nonatomic, copy) NSString *confId;

/// 会议主题
@property (nonatomic, copy) NSString *confSubject;

/// 主持人密码
@property (nonatomic, copy) NSString *chairmanPwd;

/// 来宾密码
@property (nonatomic, copy) NSString *generalPwd;

/// 会议开始时间，UTC时间戳，精度秒
@property (nonatomic, assign) NSTimeInterval startTime DEPRECATED_MSG_ATTRIBUTE("Use 'startTimeStamp' instead");

/// 会议结束时间，UTC时间戳，精度秒
@property (nonatomic, assign) NSTimeInterval endTime DEPRECATED_MSG_ATTRIBUTE("Use 'endTimeStamp' instead");

/// 会议开始时间戳，精度秒
@property (nonatomic, assign) NSInteger startTimeStamp;

/// 会议结束时间戳，精度秒
@property (nonatomic, assign) NSInteger endTimeStamp;

/// 是否是视频会议
@property (nonatomic, assign) BOOL videoConf;

/// 预订者姓名
@property (nonatomic, copy) NSString *confScheduledName;

/// 主持人加入会议uri链接
@property (nonatomic, copy) NSString *chairJoinUri;

/// 普通与会者加入会议uri链接
@property (nonatomic, copy) NSString *guestJoinUri;

/// VMR会议显示ID
@property (nonatomic, copy) NSString *vmrConferenceId;

/// 角色
@property (nonatomic, assign) HWMConfRoleType role;

///  别的公司的会议
@property (nonatomic, assign) BOOL isOtherCorpConf;

/// 会议所属的企业id  用户判断是否是外部人员入会 登录结果中有个corpId上报  登录的企业ID与会议的企业ID不是一个，说明为外部
@property (nonatomic, copy) NSString *orgId;

/// 是否在讨论组中
@property (nonatomic, assign) BOOL isInBreakoutSubConf;

/// 自定义信息
@property (nonatomic, copy) NSString *customInfo;

- (BOOL)isContentSame:(HWMConfStateInfo *)otherObject;

@end

NS_ASSUME_NONNULL_END
