//
//  HWMOpenSDKConfig+HWMPrivateConfig.h
//  HWMUISDK
//
//  Created by guomeng on 2021/9/17.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMUISDK.h"
#import "HWMTokenNotifyHandler.h"
NS_ASSUME_NONNULL_BEGIN

@interface HWMOpenSDKConfig (HWMPrivateConfig)

/// 是否显示会议助手
@property (nonatomic, assign) BOOL showMeetingAssistant;

/// 是否显示反馈
@property (nonatomic, assign) BOOL enableFeedback;

/// 是否显示新特性”new“标签
@property (nonatomic, assign) BOOL showNewFeatureLabel;

/// 会场列表等地方是否显示查看详情
@property (nonatomic, assign) BOOL enableViewContactDetail;

/// 是否显示 "会中改名，在以后的会与中使用此名字"
@property (nonatomic, assign) BOOL showChangeNameForFutureUse;

/// 是否隐藏邀请与会者气泡提示
@property (nonatomic, assign) BOOL hideInviteBubbleTips;

/// 是否可以获取设备信息
@property (nonatomic, assign) BOOL disableGetDeviceInfo;

/// 客户端类型 cloudlink-mac
@property (nonatomic, copy) NSString *cfgClientType;

/// 是否支持spartRtc会议(UISDK默认NO, 云会议YES)
@property (nonatomic, assign) BOOL enableRtc;

/// 是否显示传译设置
@property (nonatomic, assign) BOOL showInterpretSetting;

/// 客户端类型
@property (nonatomic, assign) NSInteger clientType;

/// 是否会中全屏
@property (nonatomic, assign) BOOL isHUDWindowStyle;

// 可选， 若多个对象订阅，每个对象都会收到消息通知回调
- (void)subscribeTokenNotificationHandler:(id<HWMTokenNotifyHandler>)handler;

// 可选， 取消订阅消息通知回调 优选不调用。内部为弱引用，当对象不存在就会自动取消
- (void)unsubscribeTokenNotificationHandler:(id<HWMTokenNotifyHandler>)handler;

@end

NS_ASSUME_NONNULL_END
