//
//  HWMBizOpenApi.h
//  HWMUISDK
//
//  Created by HuLinjie on 2020/10/14.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "HWMSdkDefine.h"
#import "HWMOrderConfParam.h"
#import "HWMModifyVMRParam.h"
#import "HWMConfListItemInfo.h"
#import "HWMAttendeeInfo.h"
#import "HWMOpenHwndInfoModel.h"
#import "HWMBookCycleConfParam.h"
#import "HWMUISDKShowSettingWindowInfoModel.h"
#import "HWMSDKModifySubCycleConfParamModel.h"
#import "HWMSDKCancelSubCycleConfParamModel.h"
#import "HWMConfIMWindowConfigModel.h"
#import "HWMConfAnnotationConfigModel.h"
#import "HWMUISDKDeviceStateInfoModel.h"
#import "HWMUISDKWatchListInfoModel.h"
#import "HWMUISDKToastInfoModel.h"
#import "HWMUISDKMainWindowInfoModel.h"
#import "HWMUISDKAvatarStyleModel.h"
#import "HWMUISDKTargetLanguageTypeListModel.h"

NS_ASSUME_NONNULL_BEGIN

@interface HWMBizOpenApi : NSObject

/// 预约会议
/// @param param 预约会议信息
/// @param callback 结果回调
/// 第一个参数为返回错误信息，第二个参数为预约会议成功返回的HWMConfDetail; 存在一张场景error有值，但第二个参数HWMConfDetail也非空，
/// 但除confId外其他字段没值，外部可通过HWMConfDetail中的confId重新获取一次详情
- (void)bookConf:(HWMOrderConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 编辑会议
/// @param param 编辑会议信息
/// @param callback 结果回调
- (void)editConf:(HWMOrderConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 取消会议
/// @param confId 会议id
/// @param callback 结果回调
- (void)cancelConf:(NSString *_Nonnull)confId callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 取消会议（带强制结束参数）
/// @param confId 会议id
/// @param isForceCancel 是否强制结束
/// @param callback 结果回调
- (void)cancelConf:(NSString *_Nonnull)confId
     isForceCancel:(BOOL)isForceCancel
          callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 预约周期会议
/// @param param 预约周期会议信息
/// @param callback 结果回调
/// 第一个参数为返回错误信息，第二个参数为预约会议成功返回的HWMConfDetail; 存在一张场景error有值，但第二个参数HWMConfDetail也非空，
/// 但除confId外其他字段没值，外部可通过HWMConfDetail中的confId重新获取一次详情
- (void)bookCycleConf:(HWMBookCycleConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 编辑周期会议
/// @param param 编辑周期会议信息
/// @param callback 结果回调
- (void)editCycleConf:(HWMBookCycleConfParam *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 编辑周期子会议
/// @param param 编辑周期子会议参数
/// @param callback 结果回调
- (void)editSubCycleConf:(HWMSDKModifySubCycleConfParamModel *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 取消周期会议
/// @param param 取消周期会议参数
/// @param callback 结果回调
- (void)cancelCycleConf:(HWMSDKCancelCycleConfParamModel *)param callback:(HWMSDKCompleteHandler)callback;

/// 取消周期子会议
/// @param param 取消会议参数
/// @param callback 结果回调
- (void)cancelSubCycleConf:(HWMSDKCancelSubCycleConfParamModel *_Nonnull)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 获取VMR ID列表，预约会议时可从次列表中选取固定会议ID进行预约（该接口已废弃）
/// @param callback 结果回调
- (void)getVmrList:(_Nonnull HWMSDKVmrListCompleteHandler)callback DEPRECATED_ATTRIBUTE;

/// 获取VMR列表
/// @param callback 结果回调
- (void)getVmrInfoList:(_Nonnull HWMSDKVmrInfoListCompleteHandler)callback;

/// 获取会议详情
/// @param confId 会议ID
/// @param handler 结果回调，错误信息和会议信息
- (void)getConfDetail:(NSString *)confId completeHandler:(HWMSDKConfInfoCompleteHandler)handler;

/// 修改vmr会议室信息
/// @param param vmr会议信息
/// @param callback 结果回调
- (void)changeVmrInfo:(HWMModifyVMRParam *)param callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 获取会议列表
- (NSArray<HWMConfListItemInfo *> *)getConfList;

/// 自己是否是主持人
- (BOOL)selfIsChairMan;

/// 会议中设置自己的会场名
/// @param nickName 会场名
/// @param callback 结果回调
- (void)renameSelfNameInConf:(NSString *)nickName callback:(_Nonnull HWMSDKCompleteHandler)callback;  

/// 离开会议接口
/// @param callback 结果回调
- (void)leaveConf:(_Nonnull HWMSDKCompleteHandler)callback;


/// 结束会议接口
/// @param callback 结果回调
- (void)endConf:(_Nonnull HWMSDKCompleteHandler)callback;


/// 头像上传接口
/// @param path 图片的全路径
/// @param success 成功的回调
/// @param fail 失败回调
- (void)uploadSelfAvatar:(NSString *)path
                 success:(void (^)(void))success
                    fail:(void (^)(NSError *error))fail;

/// 会中呼叫功能
/// @param attendees 要呼叫的联系人信息
/// @param callback 结果回调
- (void)addAttendee:(NSArray<HWMAttendeeInfo *> *) attendees callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 获取与会者列表
- (NSArray <HWMAttendeeInfo *> *)getAttendeeList;

/// 获取观众列表
- (NSArray <HWMAttendeeInfo *> *)getAudienceList;

/// 显示会议主窗口
- (void)showMeetingWindow;

- (NSArray <HWMOpenHwndInfoModel *> *)getRenderWindowInfoList;

/// 开启获取音频流
- (void)setAudioRawDataOutputConfig:(BOOL)enable;

/// 根据企业域名获取鉴权中心url
/// @param domain 企业域名
/// @param callback 结果回调
- (void)getSsoAuthUrl:(NSString *)domain callback:(_Nonnull HWMSDKCompleteHandler)callback;

/// 显示设置窗口信息
- (void)showSettingWindowWithInfo:(HWMUISDKShowSettingWindowInfoModel *)info;

/// 开启特性支持
/// @param type 特性类型
- (void)enableSDKCapability:(HWMSDKCapabilitySuport)type;

/// 关闭特性支持
/// @param type 特性类型
- (void)disableSDKCapability:(HWMSDKCapabilitySuport)type;

/// 禁用声音
/// @param voicePromptsModel 声音类型
- (HWMSDKERR)disableVoicePrompts:(HWMSDKVoicePromptsModel *)voicePromptsModel;

/// 音视频设备操作接口
/// @param stateInfo 设备配置信息
- (void)AVDeviceCtrlWithStateInfo:(HWMUISDKDeviceStateInfoModel *)stateInfo;

/// 选看
/// @param watchInfo 选看列表
- (HWMSDKERR)generalWatchWithWatchInfo:(HWMUISDKWatchListInfoModel *)watchInfo;

/// 显示toast提示
/// @param info 提示信息
- (void)showToast:(HWMUISDKToastInfoModel *)info;

/// 获取主窗口大小
- (HWMUISDKMainWindowInfoModel *)getMainWindowInfo;

/// 根据错误码获取错误提示
- (NSString *)getErrorMessage:(NSUInteger)code;

/// 设置(会控)保底ip地址
/// @param pAddresses  保底ip地址列表 多个地址中间用分号隔开, 最多支持4个地址
- (HWMSDKERR)setGuaranteedIpAddresses:(NSString *)pAddresses;

/// 设置(管理面)保底ip地址
- (HWMSDKERR)setGlobalGuaranteedIpAddresses:(NSArray<HWMSDKGuaranteedIpAddressModel *> *)param;

/// 是否允许收集打点信息
- (void)setAllowMeetingUt:(BOOL)allowMeetingUt;

/// 查询自己共享状态
- (BOOL)getSelfShareState;

/// 停止共享
- (void)stopShare:(NSString *)stopShareDes;

/// 获取登录状态
- (HWMLoginState)getLoginState;

/// 获取登录token
- (NSString *)getLoginToken;

/// 设置头像风格
- (HWMSDKERR)setAvatarStyle:(HWMUISDKAvatarStyleModel *)avatarStyle;

/// 开启/关闭字幕
- (void)openSubtitle:(BOOL)isOpen callback:(HWMSDKCompleteHandler)callback;

/// 是否已经开启字幕
- (BOOL)subtitlePageOpened;

/// 开启/关闭等候室
- (void)openWaitingRoom:(BOOL)isOpen callback:(HWMSDKCompleteHandler)callback;

/// 是否已经开启等候室
- (BOOL)waitingRoomOpened;

/// 操作本地录制
- (void)operateLocalRecordWithType:(HWMUISDKLocalRecordOperateType)type callback:(HWMSDKCompleteHandler)callback;

/// 获取本地录制状态
- (HWMUISDKLocalRecordStatus)getConfLocalRecordStatus;

/// 是否有本地录制权限
- (BOOL)getSelfHasLocalRecordPermission;

/// 申请本地录制权限
- (void)requestLocalRecordPermissionWithCallback:(HWMSDKCompleteHandler)callback;

/// 申请主持人
- (void)applyHostRoleWithPassword:(NSString *)password callback:(HWMSDKCompleteHandler)callback;

/// 打开虚拟背景设置
- (void)openVirtualBackgroundSettingPageWithCallback:(HWMSDKCompleteHandler)callback;

/// 是否已经打开虚拟背景设置
- (BOOL)virtualBackgroundSettingPageOpened;

/// 订阅/取消订阅字幕
- (void)subscribeSubtitle:(BOOL)isSubscribe callback:(HWMSDKCompleteHandler)callback;

/// 订阅字幕语言
- (void)subscribeSubtitleLanguageWithType:(HWMUISDKTargetLanguageType)type callback:(HWMSDKCompleteHandler)callback;

/// 获取字幕支持的语言
- (HWMUISDKTargetLanguageTypeListModel *)getSubtitleSupportLanguage;

@end

NS_ASSUME_NONNULL_END
