//
//  HWMFilePathManager.h
//  UpdateService
//
//  Created by CloudLinkCI on 2022/4/20.
//  Copyright © 2022 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM (NSUInteger, HWMFilePermissionType) {
    HWMFilePermissionTypeHomeDirectory = 0750,  //  用户主目录
    HWMFilePermissionTypeExecutableFile = 0550,  //  程序文件
    HWMFilePermissionTypeExecutableDirectory = 0550,  //  程序目录
    HWMFilePermissionTypeConfigFile = 0640,  //  配置文件
    HWMFilePermissionTypeConfigDirectory = 0750,  //  配置文件目录
    HWMFilePermissionTypeLogedFile = 0440,  //  日志文件，记录完毕
    HWMFilePermissionTypeLogingFile = 0640,  //  日志文件，正在记录
    HWMFilePermissionTypeLogDirectory = 0750, //  日志目录
    HWMFilePermissionTypeDebugFile = 0640, //  Debug文件
    HWMFilePermissionTypeDebugDirectory = 0750, //  Debug目录
    HWMFilePermissionTypeTemporaryDirectory = 0750, //  Debug目录
    HWMFilePermissionTypeUpdateDirectory = 0770, //  升级目录
    HWMFilePermissionTypeBusinessFile = 0640, //  业务数据文件
    HWMFilePermissionTypeBusinessDirectory = 0750, //  业务数据目录
    HWMFilePermissionTypeSecretKeyFile = 0600, //  秘钥/证书/密文
    HWMFilePermissionTypeSecretKeyDirectory = 0700, //  秘钥/证书/密文目录
    HWMFilePermissionTypeEncrypeScript = 0500, //  解密加密脚本
};

@interface HWMFilePathManager : NSObject

+(NSString *)logPath;

/// 会议相关的日志路径(文件夹）
+ (NSString *)XPCLogPathWithMainProjectLogPath:(NSString *)mainLogPath;

/**
 @permission 权限 可以设置为如HWMFilePermissionType
 @filePath 文件/目录 路径
 @return 更新结果信息 
 */
+ (NSError *)updateHWMFilePermission:(HWMFilePermissionType)permission filePath:(NSString *)filePath;



@end

NS_ASSUME_NONNULL_END
