//
//  HWMUISDKConfService.h
//  HWMSDKSDK
//
//  Automatically generated file. DO NOT MODIFY!!!
//

#import <Foundation/Foundation.h>
#import "HWMUISDKCommonDefine.h"
#import "HWMUISDKAllModelIndex.h"

#import "HWMUISDKPrivateMeetingService.h"

NS_ASSUME_NONNULL_BEGIN

typedef void(^HWMSDKCreateConfHandler) (NSError * _Nullable error, HWMUISDKCreateConfResultModel * createConfResult);

typedef void(^HWMSDKStartP2pConfHandler) (NSError * _Nullable error, HWMUISDKCreateConfResultModel * createConfResult);

typedef void(^HWMSDKJoinConfByIdHandler) (NSError * _Nullable error);

typedef void(^HWMSDKJoinConfByRandomHandler) (NSError * _Nullable error);

typedef void(^HWMSDKAddAttendeeHandler) (NSError * _Nullable error);

typedef void(^HWMSDKLeaveConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKEndConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKStartShareHandler) (NSError * _Nullable error);

typedef void(^HWMSDKRenameSelfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKStartProjectionHandler) (NSError * _Nullable error, HWMUISDKStartProjectionResultModel * startProjectionResult);

typedef void(^HWMSDKAcceptConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKRejectConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKOpenSubtitleHandler) (NSError * _Nullable error, BOOL isOpen);

typedef void(^HWMSDKOpenWaitingRoomHandler) (NSError * _Nullable error, BOOL isOpen);

typedef void(^HWMSDKOperateLocalRecordHandler) (NSError * _Nullable error, HWMUISDKLocalRecordOperateType type);

typedef void(^HWMSDKOpenVirtualBackgroundSettingPageHandler) (NSError * _Nullable error);

typedef void(^HWMSDKGetConfLocalRecordStatusHandler) (NSError * _Nullable error, HWMUISDKLocalRecordStatusInfoModel * state);

typedef void(^HWMSDKGetSelfHasLocalRecordPermissionHandler) (NSError * _Nullable error, HWMUISDKLocalRecordPermissionInfoModel * permission);

typedef void(^HWMSDKRequestLocalRecordPermissionHandler) (NSError * _Nullable error);

typedef void(^HWMSDKApplyHostRoleHandler) (NSError * _Nullable error);

typedef void(^HWMSDKSubscribeSubtitleLanguageHandler) (NSError * _Nullable error, HWMUISDKTargetLanguageType targetLanguageType);

typedef void(^HWMSDKSubscribeSubtitleHandler) (NSError * _Nullable error, BOOL isSubscirbe);

typedef void(^HWMSDKBookConfHandler) (NSError * _Nullable error, HWMUISDKConfDetailModel * confDetail);

typedef void(^HWMSDKCancelConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKEditConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKGetVmrListHandler) (NSError * _Nullable error, HWMUISDKVmrListInfoModel * vmrListInfo);

typedef void(^HWMSDKGetConfDetailHandler) (NSError * _Nullable error, HWMUISDKConfDetailModel * confDetail);

typedef void(^HWMSDKChangeVmrInfoHandler) (NSError * _Nullable error);

typedef void(^HWMSDKBookCycleConfHandler) (NSError * _Nullable error, HWMUISDKConfDetailModel * confDetail);

typedef void(^HWMSDKModifyCycleConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKModifySubCycleConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKCancelCycleConfHandler) (NSError * _Nullable error);

typedef void(^HWMSDKCancelSubCycleConfHandler) (NSError * _Nullable error);


@protocol HWMUISDKConfCtrlNotify <NSObject>

@optional
/// [en] Notify of conf state. [cn] 会议状态通知
- (void)onConfStateChanged:(HWMUISDKConfStateInfoModel *)confStateInfo;
/// [en] This class is about the notification of an ended conference. [cn] 会议结束通知
- (void)onConfEndedNotify:(HWMUISDKConfEndInfoModel *)confEndInfo;
/// [en] This class is about the callback of transfering point to point call to conference. [cn] 立即会议记录回调
- (void)onP2PConfRecordNotify:(HWMUISDKP2PConfRecordInfoModel *)recordInfo;
/// [en] Notify of conf info. [cn] 会议信息通知
- (void)onConfInfoNotify:(HWMUISDKConfInfoModel *)confInfo;
/// [en] Notify of share state. [cn] 共享状态通知
- (void)onShareStateChanged:(HWMUISDKShareStateInfoModel *)shareStateInfo;
/// [en] Self role changed. [cn] 个人角色变化通知
- (void)onSelfRoleChanged:(HWMUISDKConfRole)role;
/// [en] This class is about the notification of low quality network. [cn] 弱网提示通知
- (void)onPoorNetworkQualityInfoNotify:(HWMUISDKPoorNetWorkQualityInfoModel *)poorNetWorkInfo;
/// [en]Notify of speaker list [cn]发言人变更的通知
- (void)onSpeakerListChanged:(HWMUISDKSpeakerListModel *)speakerList;
/// [en]Notify of video stream type info [cn]视频流类型的变化通知
- (void)onVideoStreamTypeChanged:(HWMUISDKVideoStreamTypeInfoModel *)videoStreamTypeInfo;
/// [en]Notify of video attendee list change [cn]视频与会者列表变更的通知
- (void)onVideoAttendeeListChanged;
/// [en]Notify of annotation state change [cn]标注状态变化通知
- (void)onAnnotationStateChanged:(HWMUISDKAnnotationStateInfoModel *)stateInfo;
/// [en]Notify of conf info [cn]会中信息更新通知
- (void)onMeetingInfoChanged:(HWMUISDKMeetingInfoModel *)meetingInfo;
/// [en] Notify of the waiting list [cn] 等候室成员列表变更的通知
- (void)onWaitingListChanged:(HWMUISDKAttendeeListInfoModel *)waitingList;
/// [en] Notify of the add attendee [cn] 添加与会者结果通知
- (void)onAddAttendeeNotify:(HWMUISDKAddAttendeeResultListModel *)addAttendeeResultList;
/// [en] Notify of local record state [cn] 本地录制状态通知
- (void)onSelfLocalRecordStateNotify:(HWMUISDKLocalRecordStateInfoModel *)localRecordStateInfo;
/// [en] Notify of the attendee list [cn] 与会者列表变更的通知
- (void)onAttendeeListChanged:(HWMUISDKAttendeeListInfoModel *)attendeeList;
/// [en] Notify of the real time subtitle info [cn] 实时字幕信息的通知
- (void)onRealTimeSubtitleInfoNotify:(HWMUISDKRealTimeSubtitleInfoModel *)realTimeSubtitleInfo;
/// [en] Notify of the subtitle record info [cn] 字幕记录消息的通知
- (void)onSubtitleRecordNotify:(HWMUISDKSubtitleRecordInfoModel *)subtitleRecordInfo;
/// [en] Notify of subtitle state change [cn] 字幕状态变更通知
- (void)onSubtitleStateChanged:(BOOL)isOpen;
/// [en] Notify of waiting room state change [cn] 等候室状态变更通知
- (void)onWaitingRoomStateChanged:(BOOL)isOpen;
/// [en] Notify of local record operation interrupt notify [cn] 本地录制操作中断通知
- (void)onStartLocalRecordOperationInterruptNotify:(HWMUISDKInterruptInfoModel *)info;

@end

@interface HWMUISDKConfCtrlService : NSObject

+ (instancetype)shareInstance;
+ (void)releaseInstance;
- (void)addConfCtrlNotifyCallback:(id<HWMUISDKConfCtrlNotify>)callback;
- (void)removeConfCtrlNotifyCallback:(id<HWMUISDKConfCtrlNotify>)callback;
/// [en] This interface is used to create conf. [cn] 创建会议
- (void)createConfWithInfo:(HWMUISDKCreateConfInfoModel *)info callback:(HWMSDKCreateConfHandler)callback;

/// [en] This interface is used to start p2p conf. [cn] 发起立即会议
- (void)startP2pConfWithInfo:(HWMUISDKStartCallInfoModel *)info callback:(HWMSDKStartP2pConfHandler)callback;

/// [en] This interface is used to join conf by id. [cn] 加入会议
- (void)joinConfByIdWithInfo:(HWMUISDKJoinConfByIdInfoModel *)info callback:(HWMSDKJoinConfByIdHandler)callback;

/// [en] This interface is used to join conf by random. [cn] Random入会
- (void)joinConfByRandomWithInfo:(HWMUISDKJoinConfByRandomInfoModel *)info callback:(HWMSDKJoinConfByRandomHandler)callback;

/// [en] This interface is used to add attendee. [cn] 添加与会者
- (void)addAttendeeWithInfo:(HWMUISDKAddAttendeeInfoModel *)info callback:(HWMSDKAddAttendeeHandler)callback;

/// [en] This interface is used to leave conf. [cn] 离开会议
- (void)leaveConfWithCallback:(HWMSDKLeaveConfHandler)callback;

/// [en] This interface is used to end conf. [cn] 结束会议
- (void)endConfWithCallback:(HWMSDKEndConfHandler)callback;

/// [en] This interface is used to start share. [cn] 开启共享
- (void)startShareWithInfo:(HWMUISDKStartShareInfoModel *)info callback:(HWMSDKStartShareHandler)callback;

/// [en] This interface is used to stop share. [cn] 结束共享
- (void)stopShare;

/// [en] This interface is used to get attendee List. [cn] 获取与会者列表
- (HWMUISDKAttendeeListInfoModel *)getAttendeeList;

/// [en] This interface is used to get audience List. [cn] 获取观众列表
- (HWMUISDKAttendeeListInfoModel *)getAudienceList;

/// [en] This interface is used to get user state. [cn] 获取用户状态
- (HWMUISDKUserState)getUserState;

/// [en] This interface is used to get self role. [cn] 获取自己会中角色
- (HWMUISDKConfRole)getSelfRole;

/// [en] This interface is used to rename self. [cn] 设置会场名
- (void)renameSelfWithInfo:(HWMUISDKRenameSelfInfoModel *)info callback:(HWMSDKRenameSelfHandler)callback;

/// [en]This interface is about general watch [cn]选看
- (void)generalWatchWithInfo:(HWMUISDKWatchListInfoModel *)info;

/// [en]This interface is about set annotation window [cn]设置标注窗口
- (void)setAnnotationWindowWithInfo:(HWMUISDKAnnotationWndInfoModel *)info;

/// [en]This interface is about start annotation [cn]开启标注
- (void)startAnnotationWithInfo:(HWMUISDKAnnotationWndInfoModel *)info;

/// [en]This interface is about save annotation [cn]保存标注
- (void)saveAnnotationWithInfo:(HWMUISDKAnnotationSaveConfigInfoModel *)info;

/// [en] This interface is used to start projection. [cn] 发起投屏
- (void)startProjectionWithParam:(HWMUISDKStartProjectionParamModel *)param callback:(HWMSDKStartProjectionHandler)callback;

/// [en] This interface is used to accept conf. [cn] 接受会议邀请
- (void)acceptConfWithParam:(HWMUISDKAcceptConfParamModel *)param callback:(HWMSDKAcceptConfHandler)callback;

/// [en] This interface is used to reject conf. [cn] 拒绝会议邀请
- (void)rejectConfWithCallback:(HWMSDKRejectConfHandler)callback;

/// [en] This interface is used to get self share state. [cn] 获取自己的开启共享状态
- (HWMUISDKSelfShareStateInfoModel *)getSelfShareState;

/// [en] This interface is used to operate subtitle. [cn] 开启/关闭字幕
- (void)openSubtitle:(BOOL)isOpen callback:(HWMSDKOpenSubtitleHandler)callback;

/// [en] This interface is used to operate waiting room. [cn] 开启/关闭等候室
- (void)openWaitingRoom:(BOOL)isOpen callback:(HWMSDKOpenWaitingRoomHandler)callback;

/// [en] This interface is used to operate local record. [cn] 操作本地录制
- (void)operateLocalRecordWithType:(HWMUISDKLocalRecordOperateType)type callback:(HWMSDKOperateLocalRecordHandler)callback;

/// [en] This interface is used to open virtual background setting page. [cn] 打开虚拟背景设置
- (void)openVirtualBackgroundSettingPageWithCallback:(HWMSDKOpenVirtualBackgroundSettingPageHandler)callback;

/// [en] This interface is used to get local record status. [cn] 获取本地录制状态
- (void)getConfLocalRecordStatusWithCallback:(HWMSDKGetConfLocalRecordStatusHandler)callback;

/// [en] This interface is used to get local record permission. [cn] 获取本地录制权限
- (void)getSelfHasLocalRecordPermissionWithCallback:(HWMSDKGetSelfHasLocalRecordPermissionHandler)callback;

/// [en] This interface is used to request local record permission. [cn] 申请本地录制权限
- (void)requestLocalRecordPermissionWithCallback:(HWMSDKRequestLocalRecordPermissionHandler)callback;

/// [en] This interface is used to request host role. [cn] 申请主持人
- (void)applyHostRoleWithPassword:(NSString *)password callback:(HWMSDKApplyHostRoleHandler)callback;

/// [en] This interface is used to get subtitle state. [cn] 获取字幕状态
- (BOOL)getSubtitlePageOpened;

/// [en] This interface is used to get waiting room state. [cn] 获取等候室状态
- (BOOL)getWaitingRoomOpened;

/// [en] This interface is used to get virtual background setting page state. [cn] 获取是否已经打开虚拟背景设置
- (BOOL)getVirtualBackgroundSettingPageOpened;

/// [en] This interface is used to subscribe subtitle language. [cn] 订阅字幕语言
- (void)subscribeSubtitleLanguageWithType:(HWMUISDKTargetLanguageType)type callback:(HWMSDKSubscribeSubtitleLanguageHandler)callback;

/// [en] This interface is used to subscribe subtitle. [cn] 订阅/取消订阅字幕
- (void)subscribeSubtitle:(BOOL)isSubscribe callback:(HWMSDKSubscribeSubtitleHandler)callback;

/// [en] This interface is used to get subtitle support languagues. [cn] 获取字幕支持的语言
- (HWMUISDKTargetLanguageTypeListModel *)getSubtitleSupportLanguage;

@end


@protocol HWMUISDKConfMgrNotify <NSObject>

@optional
/// [en] Notify of the conf incoming [cn] 会议来电通知
- (void)onConfIncomingNotify:(HWMUISDKConfIncomingInfoModel *)confIncomingInfo;
/// [en] Conf list notify. when login/bookconf/cancelconf, will receive this notify [cn] 会议列表通知
- (void)onConfListChanged:(HWMUISDKConfListInfoModel *)confListInfo;

@end

@interface HWMUISDKConfMgrService : NSObject

+ (instancetype)shareInstance;
+ (void)releaseInstance;
- (void)addConfMgrNotifyCallback:(id<HWMUISDKConfMgrNotify>)callback;
- (void)removeConfMgrNotifyCallback:(id<HWMUISDKConfMgrNotify>)callback;
/// [en] This interface is book a conference. [cn] 预定会议
- (void)bookConfWithParam:(HWMUISDKBookConfParamModel *)param callback:(HWMSDKBookConfHandler)callback;

/// [en] This interface is used to cancel a conference booked before. [cn] 取消会议
- (void)cancelConfWithParam:(HWMUISDKCancelConfParamModel *)param callback:(HWMSDKCancelConfHandler)callback;

/// [en] This interface is used to modify a conf booked before. [cn] 编辑会议
- (void)editConfWithParam:(HWMUISDKEditConfParamModel *)param callback:(HWMSDKEditConfHandler)callback;

/// [en] This interface is used to get vmr list. [cn] 获取VMR列表
- (void)getVmrListWithCallback:(HWMSDKGetVmrListHandler)callback;

/// [en] This interface is used to get conf detail. [cn] 获取会议详情
- (void)getConfDetailWithParam:(HWMUISDKGetConfDetailParamModel *)param callback:(HWMSDKGetConfDetailHandler)callback;

/// [en] This interface is used to change virtual meeting room information. [cn] 修改云会议室信息
- (void)changeVmrInfoWithParam:(HWMUISDKChangeVmrInfoParamModel *)param callback:(HWMSDKChangeVmrInfoHandler)callback;

/// [en]This interface is used to get conf list [cn]获取会议列表
- (HWMUISDKConfListInfoModel *)getConfList;

/// [en] [cn]预约周期会议
- (void)bookCycleConfWithParam:(HWMUISDKBookCycleConfParamModel *)param callback:(HWMSDKBookCycleConfHandler)callback;

/// [en] [cn]编辑周期会议
- (void)modifyCycleConfWithParam:(HWMUISDKModifyCycleConfParamModel *)param callback:(HWMSDKModifyCycleConfHandler)callback;

/// [en] [cn]编辑周期子会议
- (void)modifySubCycleConfWithParam:(HWMUISDKModifySubCycleConfParamModel *)param callback:(HWMSDKModifySubCycleConfHandler)callback;

/// [en] [cn]取消周期会议
- (void)cancelCycleConfWithParam:(HWMUISDKCancelCycleConfParamModel *)param callback:(HWMSDKCancelCycleConfHandler)callback;

/// [en] [cn]取消周期子会议
- (void)cancelSubCycleConfWithParam:(HWMUISDKCancelSubCycleConfParamModel *)param callback:(HWMSDKCancelSubCycleConfHandler)callback;

@end



NS_ASSUME_NONNULL_END

