//
//  HWMNavigationController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/11/2.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMNavigationController.h"
#import "NSViewController+HWMNavigation.h"
#import "HWMNavigationItem.h"
#import "HWMNavigationBar.h"

@interface HWMNavigationController ()
@property (nonatomic, assign) BOOL animating;
@end

@implementation HWMNavigationController

- (instancetype)initWithRootViewController:(nonnull NSViewController *)rootViewController {
    if (self = [super init]) {
        _rootVC = rootViewController;
        _viewControllers = @[rootViewController];
        [self addChildViewController:rootViewController];
    }
    return self;
}

- (void)loadView {
    self.view = [[NSView alloc] initWithFrame:self.rootVC.view.bounds];
    self.view.wantsLayer = YES;
    self.view.layer.backgroundColor = [NSColor whiteColor].CGColor;
    [self.view addSubview:self.rootVC.view];
    [self.rootVC.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.view);
    }];
}

- (void)viewDidLoad {
    [super viewDidLoad];
}

- (void)pushViewController:(nullable NSViewController *)viewController animated:(BOOL)animated {
    [self pushViewController:viewController animated:animated completeBlock:^{
        
    }];
}

- (void)pushViewController:(nullable NSViewController *)viewController animated:(BOOL)animated completeBlock:(void (^)(void))block
{
    if (self.animating) {
        return;
    }
    self.animating = YES;
    if (!viewController.backItem) {
        NSImage *image;
        if (@available(macOS 10.12, *)) {
            image = [NSImage imageNamed:NSImageNameGoBackTemplate];
        }
        viewController.backItem = [HWMNavigationItem itemWithTitle:@"返回" color:[NSColor colorWithRGB:0x333333] image:image target:self action:@selector(popViewController)];
    }
    HWMNavigationBar *navBar = [HWMNavigationBar new];
    navBar.backItem = viewController.backItem;
    [viewController.view addSubview:navBar];

    navBar.hidden = viewController.hideNavBarWhenPush;

    [navBar mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.top.trailing.equalTo(viewController.view);
        make.height.equalTo(@44);
    }];

    [self addChildViewController:viewController];
    NSMutableArray *arr = self.viewControllers.mutableCopy;
    [arr addObject:viewController];
    _viewControllers = arr;
    [self.view addSubview:viewController.view];
    viewController.view.frame = NSMakeRect(self.view.frame.size.width, 0, self.view.frame.size.width, self.view.frame.size.height);

    //    __weak NSViewController *weakVC = self;
    [NSAnimationContext runAnimationGroup:^(NSAnimationContext *_Nonnull context) {
        context.duration = animated ? 0.25 : 0;
        [viewController.view.animator setFrameOrigin:NSZeroPoint];
    } completionHandler:^{
        [viewController.view mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self.view);
        }];
        for (NSViewController *vc in self.viewControllers) {
            if (vc != viewController) {
                vc.view.hidden = YES;
            }
        }
        self.animating = NO;
        if (block) {
            block();
        }
    }];
}

- (void)popViewControllerAnimated:(BOOL)animated {
    if (self.viewControllers.count < 2) {
        return;
    }
    NSViewController *viewController = self.viewControllers.lastObject;
    NSViewController *pre = self.viewControllers[self.viewControllers.count - 2];
    pre.view.hidden = NO;
    __block NSViewController *bvc = viewController;
    [NSAnimationContext runAnimationGroup:^(NSAnimationContext *_Nonnull context) {
        context.duration = animated ? 0.25 : 0;
        [viewController.view.animator setFrameOrigin:NSMakePoint(self.view.frame.size.width, 0)];
    } completionHandler:^{
        NSMutableArray *arr = self.viewControllers.mutableCopy;
        [arr removeObject:viewController];
        self->_viewControllers = arr;
        [viewController.view removeFromSuperview];
        [viewController removeFromParentViewController];
        bvc = nil;
    }];
}

- (void)popToViewController:(NSViewController *)destinationViewController animated:(BOOL)animated {
    if (self.viewControllers.count < 2) {
        return;
    }
    if (destinationViewController && [self.viewControllers containsObject:destinationViewController]) {
        NSViewController *fromViewController = self.viewControllers.lastObject;
        NSInteger idx = [self.viewControllers indexOfObject:destinationViewController];

        NSMutableArray *viewControllersMu = [NSMutableArray arrayWithArray:self.viewControllers];
        //移除 目标controller与当前controller之间所有的controller
        for (NSInteger i = idx + 1; i < self.viewControllers.count - 1; i++) {
            NSViewController *viewController = self.viewControllers[i];
            [viewControllersMu removeObject:viewController];
            [viewController.view removeFromSuperview];
            [viewController removeFromParentViewController];
        }
        _viewControllers = viewControllersMu.copy;
        destinationViewController.view.hidden = NO;
        [NSAnimationContext runAnimationGroup:^(NSAnimationContext *_Nonnull context) {
            context.duration = animated ? 0.25 : 0;
            [fromViewController.view.animator setFrameOrigin:NSMakePoint(self.view.frame.size.width, 0)];
        } completionHandler:^{
            NSMutableArray *arr = self.viewControllers.mutableCopy;
            [arr removeObject:fromViewController];
            self->_viewControllers = arr;
            [fromViewController.view removeFromSuperview];
            [fromViewController removeFromParentViewController];
        }];
    }
}

- (void)popToRootViewControllerAnimated:(BOOL)animated {
    if (self.viewControllers.count < 2) {
        return;
    }
    NSViewController *last = self.viewControllers.lastObject;
    NSViewController *first = self.viewControllers.firstObject;
    NSArray *arr = [self.viewControllers subarrayWithRange:NSMakeRange(1, self.viewControllers.count - 2)];
    for (NSViewController *vc in arr) {
        [vc.view removeFromSuperview];
        [vc removeFromParentViewController];
    }
    _viewControllers = @[_rootVC];
    first.view.hidden = NO;
    [NSAnimationContext runAnimationGroup:^(NSAnimationContext *_Nonnull context) {
        context.duration = animated ? 0.25 : 0;
        [last.view.animator setFrameOrigin:NSMakePoint(self.view.frame.size.width, 0)];
    } completionHandler:^{
        [last.view removeFromSuperview];
        [last removeFromParentViewController];
    }];
}

- (void)popViewController {
    NSViewController *vc = self.viewControllers.lastObject;
    HWMNavigationItem *back = vc.backItem;
    if (back.target && back.action) {
        #pragma clang diagnostic push
        #pragma clang diagnostic ignored "-Warc-performSelector-leaks"
        [back.target performSelector:back.action];
        #pragma clang diagnostic pop
    } else {
        [self popViewControllerAnimated:YES];
    }
}

@end
