//
//  HWMTableCellArrowView.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/2/19.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMTableCellArrowView.h"

@interface HWMTableCellArrowView ()
/// 标题
@property (nonatomic, strong) NSTextField *titleLabel;
/// 范围
@property (nonatomic, strong) NSButton *arrowBtn;

@end

@implementation HWMTableCellArrowView

+ (instancetype)tableViewArrowCell:(NSTableView *)tableView ower:(id)ower {
    HWMTableCellArrowView *cell = [tableView makeViewWithIdentifier:NSStringFromClass([HWMTableCellArrowView class]) owner:ower];
    if (!cell) {
        cell = [[HWMTableCellArrowView alloc] initWithFrame:NSZeroRect];
        cell.identifier = NSStringFromClass([HWMTableCellArrowView class]);
    }
    return cell;
}

- (instancetype)initWithFrame:(NSRect)frameRect {
    if (self = [super initWithFrame:frameRect]) {
        self.wantsLayer = YES;
        self.layer.backgroundColor = [NSColor whiteColor].CGColor;
        [self setupUI];
        [self addTrackingArea];
    }
    return self;
}

- (void)drawRect:(NSRect)dirtyRect {
    [super drawRect:dirtyRect];

    // Drawing code here.
}

#pragma mark - UI
- (void)setupUI {
    [self addSubview:self.titleLabel];
    [self addSubview:self.arrowBtn];

    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self).offset(120);
        make.centerY.equalTo(self);
        make.trailing.mas_equalTo(self.arrowBtn.mas_leading).offset(-10);
    }];

    [self.arrowBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.trailing.equalTo(self).offset(-120);
        make.centerY.equalTo(self);
    }];
}

#pragma mark - Event
- (void)limitBtnClick {
    
}

- (void)mouseDown:(NSEvent *)event {
    if (self.arrowCellViewClickHandler) {
        self.arrowCellViewClickHandler(self.index);
    }
}

#pragma mark - Setter

- (void)setTitle:(NSString *)title {
    _title = title;
    self.titleLabel.stringValue = title;
}

#pragma mark - Lazy
- (NSTextField *)titleLabel {
    if (!_titleLabel) {
        _titleLabel = [NSTextField hwm_fieldWithTitle:@"服务器设置" titleColor:[NSColor colorWithRGB:0x666666] font:[NSFont systemFontOfSize:13]];
    }
    return _titleLabel;
}

- (NSButton *)arrowBtn {
    if (!_arrowBtn) {
        _arrowBtn = [NSButton buttonWithTitle:@"" font:[NSFont systemFontOfSize:13] fontColor:[NSColor blackColor] target:self action:@selector(limitBtnClick)];
        _arrowBtn.layer.backgroundColor = [NSColor whiteColor].CGColor;
        _arrowBtn.image = [NSImage imageNamed:@"arrow_right"];
        _arrowBtn.imagePosition = NSImageRight;
    }
    return _arrowBtn;
}

@end
