//
//  HWMAttendeeListInjectCallOtherNumberController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2025/2/12.
//  Copyright © 2025 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMAttendeeListInjectCallOtherNumberController.h"
#import "HWMSwitchCell.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMAttendeeListInjectCallOtherNumberController () <HWMSwitchCellDelegate, HWMInputViewDelegate, HWMParticipantListItemCallOtherNumberHandler>

@property (nonatomic, strong) HWMSwitchCell *callOtherNumberSwitchCell;
@property (nonatomic, assign) BOOL callOtherNumberSwitchState;
@property (nonatomic, strong) HWMInputView *numberInputView;
@property (nonatomic, strong) HWMInputView *hideTypeInputView;
@property (nonatomic, strong) HWMInputView *callbackInputView;
@property (nonatomic, strong) NSArray<NSString *> *numberArray;
@property (nonatomic, strong) NSArray<NSString *> *hideTypeArray;
@property (nonatomic, strong) NSArray<NSString *> *callbackArray;

@end

@implementation HWMAttendeeListInjectCallOtherNumberController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - HWMParticipantListItemCallOtherNumberHandler

- (void)buildCallOtherNumberList:(HWMAttendeeInfo *)participantInfo
                 completionBlock:(void (^)(NSArray<HWMCallOtherNumberItem *> *items))completionBlock {
    NSMutableArray *callOtherNumberList = @[].mutableCopy;
    [self.numberArray enumerateObjectsUsingBlock:^(NSString * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        HWMCallOtherNumberItem *item = [[HWMCallOtherNumberItem alloc] init];
        item.number = obj;
        if (self.hideTypeArray.count > idx) {
            item.hideType = [self.hideTypeArray objectAtIndex:idx].integerValue;
        }
        if (self.callbackArray.count > idx) {
            BOOL injectCallback = [self.callbackArray objectAtIndex:idx].integerValue == 1;
            if (injectCallback) {
                item.callback = ^(HWMAttendeeInfo * _Nonnull attendee) {
                    [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"onClickInjectCallOtherNumber, number: %@, name: %@, phone: %@", attendee.number, attendee.name, obj];
                };
            }
        }
        [callOtherNumberList addObject:item];
    }];
    completionBlock(callOtherNumberList);
}

#pragma mark - UI

- (void)setupUI {
    [self.view addSubview:self.callOtherNumberSwitchCell];
    [self.callOtherNumberSwitchCell mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(600);
    }];
    
    [self.view addSubview:self.numberInputView];
    [self.numberInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.callOtherNumberSwitchCell.mas_bottom).offset(20);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(360);
    }];
    
    [self.view addSubview:self.hideTypeInputView];
    [self.hideTypeInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.numberInputView.mas_bottom).offset(20);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(360);
    }];
    
    [self.view addSubview:self.callbackInputView];
    [self.callbackInputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.hideTypeInputView.mas_bottom).offset(20);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(360);
    }];
}

#pragma mark - HWMSwitchCellDelegate

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    self.callOtherNumberSwitchState = state;
    self.numberInputView.hidden = !state;
    self.hideTypeInputView.hidden = !state;
    self.callbackInputView.hidden = !state;
    if (state) {
        [HWMSdk getSdkConfig].callOtherNumberHandler = self;
    } else {
        [HWMSdk getSdkConfig].callOtherNumberHandler = nil;
    }
}

#pragma mark - HWMInputViewDelegate

- (void)textFieldDidChanged:(NSTextField *)field {
    NSArray *array = nil;
    if (field.stringValue.length > 0) {
        array = [field.stringValue componentsSeparatedByCharactersInSet:[NSCharacterSet characterSetWithCharactersInString:@","]];
    }
    if (field == self.numberInputView.textField) {
        self.numberArray = array;
    } else if (field == self.hideTypeInputView.textField) {
        self.hideTypeArray = array;
    } else if (field == self.callbackInputView.textField) {
        self.callbackArray = array;
    }
}

#pragma mark - Lazy

- (HWMSwitchCell *)callOtherNumberSwitchCell {
    if (!_callOtherNumberSwitchCell) {
        _callOtherNumberSwitchCell = [[HWMSwitchCell alloc] init];
        _callOtherNumberSwitchCell.title = @"开启与会者列表呼叫其他号码注入";
        _callOtherNumberSwitchCell.delegate = self;
        _callOtherNumberSwitchCell.state = self.callOtherNumberSwitchState;
    }
    return _callOtherNumberSwitchCell;
}

- (HWMInputView *)numberInputView {
    if (!_numberInputView) {
        _numberInputView = [[HWMInputView alloc] init];
        _numberInputView.title = @"注入号码";
        _numberInputView.placeholder = @"多个号码使用,分隔";
        _numberInputView.delegate = self;
        _numberInputView.hidden = YES;
    }
    return _numberInputView;
}

- (HWMInputView *)hideTypeInputView {
    if (!_hideTypeInputView) {
        _hideTypeInputView = [[HWMInputView alloc] init];
        _hideTypeInputView.title = @"隐藏类型";
        _hideTypeInputView.placeholder = @"1显示，3打码，多个号码使用,分隔";
        _hideTypeInputView.delegate = self;
        _hideTypeInputView.hidden = YES;
    }
    return _hideTypeInputView;
}

- (HWMInputView *)callbackInputView {
    if (!_callbackInputView) {
        _callbackInputView = [[HWMInputView alloc] init];
        _callbackInputView.title = @"点击回调";
        _callbackInputView.placeholder = @"0不注入，1注入，多个号码使用,分隔";
        _callbackInputView.delegate = self;
        _callbackInputView.hidden = YES;
    }
    return _callbackInputView;
}

@end
