//
//  HWMAttendeeListInjectController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2025/2/12.
//  Copyright © 2025 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMAttendeeListInjectController.h"
#import "NSViewController+HWMNavigation.h"
#import "HWMSDKTableView.h"
#import "HWMTableCellArrowView.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMAttendeeListInjectClickItemController.h"
#import "HWMAttendeeListInjectCallOtherNumberController.h"

typedef NS_ENUM (NSInteger, HWMAttendeeListInjectCellType) {
    HWMAttendeeListInjectCellTypeClickItem = 0,     // 与会者列表按钮点击注入
    HWMAttendeeListInjectCellTypeCallOtherNumber,   // 与会者列表呼叫其他号码注入
};

@interface HWMAttendeeListInjectController () <HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate>

@property (nonatomic, copy) NSDictionary<NSNumber *, NSString *> *titleDic;
@property (nonatomic, strong) HWMSDKTableView *listView;
@property (nonatomic, strong) HWMAttendeeListInjectClickItemController *clickItemController;
@property (nonatomic, strong) HWMAttendeeListInjectCallOtherNumberController *callOtherNumberController;

@end

@implementation HWMAttendeeListInjectController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupData];
    [self setupUI];
}

#pragma mark - Data

- (void)setupData {
    self.titleDic = @{
        @(HWMAttendeeListInjectCellTypeClickItem) : @"与会者列表按钮点击注入",
        @(HWMAttendeeListInjectCellTypeCallOtherNumber) : @"与会者列表呼叫其他号码注入",
    };
}

#pragma mark - UI

- (void)setupUI {
    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"attendeeListInject"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.leading.equalTo(self.view).offset(15);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.view).offset(-15);
    }];
}

- (HWMAttendeeListInjectClickItemController *)clickItemController {
    if (!_clickItemController) {
        _clickItemController = [[HWMAttendeeListInjectClickItemController alloc] init];
    }
    return _clickItemController;
}

- (HWMAttendeeListInjectCallOtherNumberController *)callOtherNumberController {
    if (!_callOtherNumberController) {
        _callOtherNumberController = [[HWMAttendeeListInjectCallOtherNumberController alloc] init];
    }
    return _callOtherNumberController;
}

#pragma mark - Delegate

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.titleDic.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    HWMTableCellArrowView *arrow = [HWMTableCellArrowView tableViewArrowCell:tableView ower:self];
    arrow.index = row;
    arrow.title = self.titleDic[@(row)];
    @weakify(self)
    [arrow setArrowCellViewClickHandler:^(NSInteger index) {
        @strongify(self)
        if (index == HWMAttendeeListInjectCellTypeClickItem) {
            [self.customNavigationController pushViewController:self.clickItemController animated:YES];
        } else if (index == HWMAttendeeListInjectCellTypeCallOtherNumber) {
            [self.customNavigationController pushViewController:self.callOtherNumberController animated:YES];
        }
    }];
    return arrow;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 50;
}

@end
