//
//  HWMBookCycleConfViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2021/10/19.
//  Copyright © 2021 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMBookCycleConfViewController.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMInputInfoTitleCell.h"
#import "HWMConfTypeSelectCell.h"
#import "HWMSwitchCell.h"
#import "HWMJoinConfLimitCell.h"
#import "NSViewController+HWMNavigation.h"
#import "HWMSelectContactViewController.h"
#import "HWMSDKTableView.h"
#import "HWMBookCycleTypeCell.h"
#import "HWMContactInfoModel.h"
#import <HWMUISDK/HWMUISDK.h>

typedef NS_ENUM (NSInteger, HWMBookCycleConfCellType) {
    HWMBookCycleConfCellTypeSubject = 0,         // 会议主题
    HWMBookCycleConfCellTypeStartTime,           // 开始时间
    HWMBookCycleConfCellTypeEndTime,             // 结束时间
    HWMBookCycleConfCellTypeDuration,            // 会议时长
    HWMBookCycleConfCellTypeCycleMode,           // 会议周期模式（天，周，月）
    HWMBookCycleConfCellTypeCycleDay,            // 会议周期（天取值范围1-15；周取值范围1-5；月取值范围1-3）
    HWMBookCycleConfCellTypeCycleTime,           // 会议时间（根据周期模式,日无效,周:0-6,月:1-31,使用逗号隔开）
    HWMBookCycleConfCellTypePreRemindDays,       // 提前通知（周期子会议提前通知天数）
    HWMBookCycleConfCellTypeShareVmr,            // 启用共享云会议室
    HWMBookCycleConfCellTypeFixed,               // 使用个人会议ID（是否固定会议ID）
    HWMBookCycleConfCellTypeNeedAttendee,        // 是否需要携带与会者
    HWMBookCycleConfCellTypeAttendeesExcludeSelf,// 与会者列表是否排除自己
    HWMBookCycleConfCellTypeAutoInvite,          // 会议开始自动呼叫与会者
    HWMBookCycleConfCellTypeAllowJoin,           // 允许入会
    HWMBookCycleConfCellTypeAllowRecord,         // 允许录制
    HWMBookCycleConfCellTypeAutoRecord,          // 自动录制
    HWMBookCycleConfCellTypeMail,                // 邮件通知
    HWMBookCycleConfCellTypeSms,                 // 短信通知
    HWMBookCycleConfCellTypeEmailCalender,       // 日历邮件通知
    HWMBookCycleConfCellTypeNeedPassword,        // 是否设置来宾密码
    HWMBookCycleConfCellTypePassword,            // 来宾密码
    HWMBookCycleConfCellTypeWaitingRoom,         // 是否开启等候室
    HWMBookCycleConfCellTypeAutoMute,            // 个人客户端入会自动静音
    HWMBookCycleConfCellTypeHardTerminalAutoMute,// 会议室设备入会自动静音
    HWMBookCycleConfCellTypeSupportWatermark,    // 是否支持水印
    HWMBookCycleConfCellTypeCustomInfo,          // 自定义信息
    HWMBookCycleConfCellTypeParticipants,        // 最大与会人数
    HWMBookCycleConfCellTypeTimeZone             // 时区
};

@interface HWMBookCycleConfViewController ()<HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate, HWMInputInfoTitleCellDelegate, HWMSwitchCellDelegate>

/// 标题
@property (nonatomic, copy) NSDictionary<NSNumber *, NSString *> *titleDic;
/// tableView
@property (nonatomic, strong) HWMSDKTableView *listView;
/// 确定按钮
@property (nonatomic, strong) NSButton *confirmBtn;
/// 数据
@property (nonatomic, strong) HWMBookCycleConfParam *bookParam;
/// 是否使用共享vmr
@property (nonatomic, assign) BOOL useShareVmr;
/// 是否使用个人ID
@property (nonatomic, assign) BOOL usePersonalID;
/// 是否支持共享vmr
@property (nonatomic, assign) BOOL isEnableShareVmr;
/// Vmr
@property (nonatomic, copy) NSArray<HWMVmrInfoModel *> *vmrList;
/// 是否携带与会者
@property (nonatomic, assign) BOOL needAttendee;
/// 是否自动外呼
@property (nonatomic, assign) BOOL isAutoInvite;
/// 与会者
@property (nonatomic, strong) NSMutableArray <HWMAttendeeInfo *> *attenteeArr;

@end

@implementation HWMBookCycleConfViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupData];
    [self setupUI];
}

- (void)viewWillAppear {
    [super viewWillAppear];
    [self getVmrList];
}

#pragma mark - Data

- (void)setupData {
    self.titleDic = @{
        @(HWMBookCycleConfCellTypeSubject) : @"会议主题",
        @(HWMBookCycleConfCellTypeStartTime) : @"开始时间",
        @(HWMBookCycleConfCellTypeEndTime) : @"结束时间",
        @(HWMBookCycleConfCellTypeDuration) : @"会议时长",
        @(HWMBookCycleConfCellTypeCycleMode) : @"会议周期模式",
        @(HWMBookCycleConfCellTypeCycleDay) : @"会议周期",
        @(HWMBookCycleConfCellTypeCycleTime) : @"会议时间",
        @(HWMBookCycleConfCellTypePreRemindDays) : @"提前通知",
        @(HWMBookCycleConfCellTypeShareVmr) : @"启用共享云会议室",
        @(HWMBookCycleConfCellTypeFixed) : @"使用个人会议ID",
        @(HWMBookCycleConfCellTypeNeedAttendee) : @"是否需要携带与会者",
        @(HWMBookCycleConfCellTypeAttendeesExcludeSelf) : @"与会者列表是否排除自己",
        @(HWMBookCycleConfCellTypeAutoInvite) : @"会议开始自动呼叫与会者",
        @(HWMBookCycleConfCellTypeAllowJoin) : @"允许入会",
        @(HWMBookCycleConfCellTypeAllowRecord) : @"允许录制",
        @(HWMBookCycleConfCellTypeAutoRecord) : @"自动录制",
        @(HWMBookCycleConfCellTypeMail) : @"邮件通知",
        @(HWMBookCycleConfCellTypeSms) : @"短信通知",
        @(HWMBookCycleConfCellTypeEmailCalender) : @"日历邮件通知",
        @(HWMBookCycleConfCellTypeNeedPassword) : @"是否设置来宾密码",
        @(HWMBookCycleConfCellTypePassword) : @"来宾密码",
        @(HWMBookCycleConfCellTypeWaitingRoom) : @"是否开启等候室",
        @(HWMBookCycleConfCellTypeAutoMute) : @"个人客户端入会自动静音",
        @(HWMBookCycleConfCellTypeHardTerminalAutoMute) : @"会议室设备入会自动静音",
        @(HWMBookCycleConfCellTypeSupportWatermark) : @"是否支持水印",
        @(HWMBookCycleConfCellTypeCustomInfo) : @"自定义信息",
        @(HWMBookCycleConfCellTypeParticipants) : @"最大与会人数",
        @(HWMBookCycleConfCellTypeTimeZone) : @"时区"
    };
    
    self.bookParam = [[HWMBookCycleConfParam alloc] init];
    HWMOrderConfParam *orderParam = [[HWMOrderConfParam alloc] init];
    HWMCycleConfParam *cycleParam = [[HWMCycleConfParam alloc] init];
    self.bookParam.confParam = orderParam;
    self.bookParam.cycleConfParam = cycleParam;
    self.bookParam.confParam.isVideo = YES;
    
    if (self.detailModel) {

        self.bookParam.confParam.confSubject = self.detailModel.confSubject;
        self.bookParam.confParam.startTimeStamp = self.detailModel.startTimeStamp;
        self.bookParam.cycleConfParam.startTimeStamp = self.detailModel.cycleParam.startTimeStamp;
        self.bookParam.cycleConfParam.endTimeStamp = self.detailModel.cycleParam.endTimeStamp;
        self.bookParam.confParam.confId = self.detailModel.confId;
        
        HWMSDKSubCycleConfParamModel *subCycle = self.detailModel.subConfParam.firstObject;
        self.bookParam.confParam.duration = (subCycle.endTime - subCycle.startTime) / 60;
        self.bookParam.confParam.timeZone = [self.detailModel.timeZone integerValue];
        self.bookParam.cycleConfParam.interval = self.detailModel.cycleParam.interval;
        self.bookParam.cycleConfParam.listPoints = self.detailModel.cycleParam.listPoints;
        self.bookParam.cycleConfParam.preRemindDays = self.detailModel.cycleParam.preRemindDays;
        self.bookParam.cycleConfParam.cycleMode = self.detailModel.cycleParam.cycleMode;
        self.bookParam.confParam.guestPwd = self.detailModel.generalPwd;
        
        self.bookParam.confParam.isSmsOn = self.detailModel.sendSms;
        self.bookParam.confParam.isMailOn = self.detailModel.sendEmailNotify;
        self.bookParam.confParam.isEmailCalenderOn = self.detailModel.sendCalendarNotify;
        
        self.bookParam.confParam.callInRestrictionType = self.detailModel.callInRestriction;
        self.bookParam.confParam.isAutoRecord = self.detailModel.isAutoRecord;
        self.bookParam.confParam.vmrId = self.detailModel.vmrId;
        self.usePersonalID = self.detailModel.vmrFlag;
        self.bookParam.confParam.vmrConfIdType = self.detailModel.vmrConfIdType;
        self.bookParam.confParam.attendee = self.detailModel.attendee;
        self.needAttendee = self.attenteeArr.count > 1 ? YES : NO;
        self.bookParam.confParam.isOpenWaitingRoom = self.detailModel.isOpenWaitingRoom;
        self.bookParam.confParam.autoMuteMode = self.detailModel.autoMuteMode;
        self.bookParam.confParam.hardTerminalAutoMuteMode = self.detailModel.hardTerminalAutoMuteMode;
        self.bookParam.confParam.supportWatermark = self.detailModel.supportWatermark;
        self.bookParam.confParam.customInfo = self.detailModel.customInfo;
        self.bookParam.confParam.concurrentParticipants = self.detailModel.concurrentParticipants;
    }
}

- (HWMSDKAttendeeBaseInfoModel *)convertHwm2WKCFAttendeeBaseInfo:(HWMAttendeeInfo *)attendeeInfo {
    HWMSDKAttendeeBaseInfoModel *attendee = [[HWMSDKAttendeeBaseInfoModel alloc] init];
    attendee.name = attendeeInfo.name;
    attendee.number = attendeeInfo.number;
    if (![attendee.number stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceCharacterSet]].length) {
        attendee.accountId = attendeeInfo.accountId;
    }
    attendee.thirdAccount = attendeeInfo.thirdUserId;
    attendee.isAutoInvite = attendeeInfo.isAutoInvite;
    attendee.role = (HWMConfRole)attendeeInfo.role;
    attendee.type = (HWMAttendeeType)attendeeInfo.type;
    attendee.email = attendeeInfo.email;
    attendee.sms = attendeeInfo.sms;
    attendee.isMute = attendeeInfo.mute;
    return attendee;
}

- (void)getVmrList {
    if (![HWMSdk hasInit]) {
        return;
    }
    @weakify(self)
    [[HWMBizSdk getBizOpenApi] getVmrInfoList:^(NSError * _Nullable error, HWMVmrInfoListModel * _Nullable result) {
        @strongify(self)
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        } else {
            self.isEnableShareVmr = result.isEnableShareVmr;
            if (!self.isEnableShareVmr) {
                self.useShareVmr = NO;
            }
            self.vmrList = result.vmrs;
            [self.listView reloadData];
        }
    }];
}

#pragma mark - UI

- (void)setupUI {
    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"bookConf"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];

    NSString *title = self.detailModel ? @"编辑周期会议" : @"预约周期会议";
    self.confirmBtn = [NSButton buttonWithTitle:title font:nil fontColor:[NSColor whiteColor] target:self action:@selector(confirmBtnClick)];
    self.confirmBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    self.confirmBtn.layer.cornerRadius = 4.0;
    self.confirmBtn.layer.masksToBounds = YES;
    [self.view addSubview:self.confirmBtn];

    [self.confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];

    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.and.top.equalTo(self.view).offset(15);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.confirmBtn.mas_top).offset(-15);
    }];
}

/// 可输入cell
- (HWMInputInfoTitleCell *)inputInfoCell:(NSTableView *)tableView row:(NSInteger)row {
    HWMInputInfoTitleCell *cell = [HWMInputInfoTitleCell inputInfoTitleCell:tableView ower:self];
    cell.delegate = self;
    cell.index = row;
    cell.title = self.titleDic[@(row)];
    if (row == HWMBookCycleConfCellTypeSubject) {
        // 会议主题
        cell.placeholder = @"请输入会议主题";
        cell.content = self.bookParam.confParam.confSubject;
    } else if (row == HWMBookCycleConfCellTypeStartTime) {
        // 开始时间
        cell.placeholder = @"格式：yyyy-MM-dd HH:mm";
        cell.content = [NSString timeStringFromTimeInterval:self.bookParam.confParam.startTimeStamp];
    } else if (row == HWMBookCycleConfCellTypeEndTime) {
        // 结束时间
        cell.placeholder = @"格式：yyyy-MM-dd HH:mm";
        cell.content = [NSString timeStringFromTimeInterval:self.bookParam.cycleConfParam.endTimeStamp];
    } else if (row == HWMBookCycleConfCellTypeDuration) {
        // 会议时长
        cell.placeholder = @"请输入会议时长(单位：分钟)";
        if (self.bookParam.confParam.duration > 0) {
            cell.content = [NSString stringWithFormat:@"%lu", self.bookParam.confParam.duration];
        }
    } else if (row == HWMBookCycleConfCellTypeCycleDay) {
        // 会议周期
        cell.placeholder = @"天取值范围1-15；周取值范围1-5；月取值范围1-3";
        if (self.bookParam.cycleConfParam.interval > 0) {
            cell.content = [NSString stringWithFormat:@"%lu", self.bookParam.cycleConfParam.interval];
        }
    } else if (row == HWMBookCycleConfCellTypeCycleTime) {
        // 会议时间
        cell.placeholder = @"根据周期模式,日无效,周:0-6,月:1-31,使用逗号隔开";
        cell.content = self.bookParam.cycleConfParam.listPoints;
    } else if (row == HWMBookCycleConfCellTypePreRemindDays) {
        // 提前通知
        cell.placeholder = @"周期子会议提前通知天数";
        if (self.bookParam.cycleConfParam.preRemindDays) {
            cell.content = [NSString stringWithFormat:@"%lu", self.bookParam.cycleConfParam.preRemindDays];
        }
    } else if (row == HWMBookCycleConfCellTypePassword) {
        // 来宾密码
        cell.placeholder = @"不填使用随机密码";
        cell.content = self.bookParam.confParam.guestPwd;
        cell.enabled = !self.bookParam.confParam.noPassword && !self.usePersonalID;
    } else if (row == HWMBookCycleConfCellTypeCustomInfo) {
        // 自定义信息
        cell.placeholder = @"请输入自定义信息";
        cell.content = self.bookParam.confParam.customInfo;
    } else if (row == HWMBookCycleConfCellTypeParticipants) {
        // 最大与会人数
        cell.placeholder = @"默认0";
        cell.content = [NSString stringWithFormat:@"%ld", self.bookParam.confParam.concurrentParticipants];
        cell.formatterStyle = HWMFormatterStyleNumber;
    } else if (row == HWMBookCycleConfCellTypeTimeZone) {
        // 时区
        cell.placeholder = @"默认当前时区";
        if (self.bookParam.confParam.timeZone > 0) {
            cell.content = [NSString stringWithFormat:@"%ld", self.bookParam.confParam.timeZone];
        }
        cell.formatterStyle = HWMFormatterStyleNumber;
    }
    return cell;
}

/// switch cell
- (HWMSwitchCell *)switchCell:(NSTableView *)tableView row:(NSInteger)row {
    HWMSwitchCell *cell = [HWMSwitchCell initSwitchCell:tableView ower:self];
    cell.index = row;
    cell.delegate = self;
    cell.title = self.titleDic[@(row)];
    if (row == HWMBookCycleConfCellTypeShareVmr) {
        // 启用共享云会议室
        cell.state = self.useShareVmr;
        cell.enabled = !self.detailModel && self.isEnableShareVmr;
    } else if (row == HWMBookCycleConfCellTypeFixed) {
        // 使用个人会议ID（是否固定会议ID）
        HWMVmrInfoModel *model = self.vmrList.firstObject;
        cell.title = [NSString stringWithFormat:@"使用个人会议ID %@", model.confId.length > 0 ? model.confId : @""];
        if (self.useShareVmr) {
            cell.title = @"使用共享云会议室资源时，会议号会随机生成";
        }
        cell.state = self.usePersonalID;
        cell.enabled = !self.detailModel && !self.useShareVmr;
        HWMSwitchCell *pwdCell = [self.listView.listView viewAtColumn:0 row:HWMBookCycleConfCellTypeNeedPassword makeIfNecessary:YES];
        HWMInputInfoTitleCell *pwdTextCell = [self.listView.listView viewAtColumn:0 row:HWMBookCycleConfCellTypePassword makeIfNecessary:YES];
        if (pwdCell) {
            pwdCell.enabled = !self.usePersonalID;
        }
        if (pwdTextCell) {
            pwdTextCell.enabled = !self.usePersonalID && !self.bookParam.confParam.noPassword;
        }
    } else if (row == HWMBookCycleConfCellTypeNeedAttendee) {
        // 是否需要携带与会者
        cell.state = self.needAttendee;
        cell.enabled = YES;
    } else if (row == HWMBookCycleConfCellTypeAttendeesExcludeSelf) {
        // 与会者列表是否排除自己
        cell.state = self.bookParam.confParam.attendeesExcludeSelf;
        cell.enabled = YES;
    } else if (row == HWMBookCycleConfCellTypeAutoInvite) {
        // 会议开始自动呼叫与会者
        cell.state = self.isAutoInvite;
    } else if (row == HWMBookCycleConfCellTypeAllowRecord) {
        // 允许录制
        cell.state = self.bookParam.confParam.isRecordOn;
        cell.enabled = YES;
    } else if (row == HWMBookCycleConfCellTypeAutoRecord) {
        // 自动录制
        cell.state = self.bookParam.confParam.isAutoRecord;
        cell.enabled = YES;
    } else if (row == HWMBookCycleConfCellTypeMail) {
        // 邮件通知
        cell.state = self.bookParam.confParam.isMailOn;
        cell.enabled = YES;
    } else if (row == HWMBookCycleConfCellTypeSms) {
        // 短信通知
        cell.state = self.bookParam.confParam.isSmsOn;
        cell.enabled = YES;
    } else if (row == HWMBookCycleConfCellTypeEmailCalender) {
        // 日历邮件通知
        cell.state = self.bookParam.confParam.isEmailCalenderOn;
        cell.enabled = YES;
    } else if (row == HWMBookCycleConfCellTypeNeedPassword) {
        // 是否设置来宾密码
        cell.state = !self.bookParam.confParam.noPassword;
    } else if (row == HWMBookCycleConfCellTypeWaitingRoom) {
        // 是否开启等候室
        cell.state = self.bookParam.confParam.isOpenWaitingRoom;
    } else if (row == HWMBookCycleConfCellTypeSupportWatermark) {
        // 是否支持水印
        cell.state = self.bookParam.confParam.supportWatermark;
        cell.enabled = YES;
    }
    return cell;
}

- (HWMJoinConfLimitCell *)menuCell:(NSTableView *)tableView row:(NSInteger)row {
    HWMJoinConfLimitCell *cell = [HWMJoinConfLimitCell joinConfLimitCell:tableView ower:self];
    cell.title = self.titleDic[@(row)];
    if (row == HWMBookCycleConfCellTypeAllowJoin) {
        // 允许入会
        cell.menuTitles = @[@"所有人", @"仅企业内人员", @"仅会议邀请人员"];
        cell.currentIndex = self.bookParam.confParam.callInRestrictionType > 0 ? self.bookParam.confParam.callInRestrictionType - 1 : 0;
        @weakify(self)
        [cell setSelectMenuItemHandler:^(NSInteger index,NSString *_Nullable title) {
            @strongify(self)
            self.bookParam.confParam.callInRestrictionType = index > 0 ? index + 1 : 0;
        }];
    } else if (row == HWMBookCycleConfCellTypeAutoMute) {
        // 个人客户端入会自动静音
        cell.menuTitles = @[@"默认", @"开启", @"关闭"];
        cell.currentIndex = self.bookParam.confParam.autoMuteMode;
        @weakify(self)
        [cell setSelectMenuItemHandler:^(NSInteger index,NSString *_Nullable title) {
            @strongify(self)
            self.bookParam.confParam.autoMuteMode = (HWMAutoMuteType)index;
        }];
    } else if (row == HWMBookCycleConfCellTypeHardTerminalAutoMute) {
        // 会议室设备入会自动静音
        cell.menuTitles = @[@"默认", @"开启", @"关闭"];
        cell.currentIndex = self.bookParam.confParam.hardTerminalAutoMuteMode;
        @weakify(self)
        [cell setSelectMenuItemHandler:^(NSInteger index,NSString *_Nullable title) {
            @strongify(self)
            self.bookParam.confParam.hardTerminalAutoMuteMode = (HWMAutoMuteType)index;
        }];
    }
    return cell;
}

#pragma mark - Delegate

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.titleDic.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    if (row == HWMBookCycleConfCellTypeSubject ||
        row == HWMBookCycleConfCellTypeStartTime ||
        row == HWMBookCycleConfCellTypeEndTime ||
        row == HWMBookCycleConfCellTypeDuration ||
        row == HWMBookCycleConfCellTypeCycleDay ||
        row == HWMBookCycleConfCellTypeCycleTime ||
        row == HWMBookCycleConfCellTypePreRemindDays ||
        row == HWMBookCycleConfCellTypePassword ||
        row == HWMBookCycleConfCellTypeCustomInfo ||
        row == HWMBookCycleConfCellTypeParticipants ||
        row == HWMBookCycleConfCellTypeTimeZone) {
        return [self inputInfoCell:tableView row:row];
    } else if (row == HWMBookCycleConfCellTypeAllowJoin ||
               row == HWMBookCycleConfCellTypeAutoMute ||
               row == HWMBookCycleConfCellTypeHardTerminalAutoMute) {
        return [self menuCell:tableView row:row];
    } else if (row == HWMBookCycleConfCellTypeCycleMode) {
        // 会议周期模式（天，周，月）
        HWMBookCycleTypeCell *cell = [HWMBookCycleTypeCell initBookCycleConfType:tableView ower:self];
        @weakify(self)
        [cell setBookCycleSelectModeHandler:^(NSInteger mode) {
            @strongify(self)
            self.bookParam.cycleConfParam.cycleMode = mode;
        }];
        cell.selectMode = self.bookParam.cycleConfParam.cycleMode;
        return cell;
    }
    return [self switchCell:tableView row:row];
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 40.0;
}

- (void)inputInfoCellDidEdite:(NSString *)content index:(NSInteger)index {
    if (index == HWMBookCycleConfCellTypeSubject) {
        // 会议主题
        self.bookParam.confParam.confSubject = content;
    } else if (index == HWMBookCycleConfCellTypeStartTime) {
        // 开始时间
        NSTimeInterval timeStamp = [NSString getTimeStampWithDateString:content];
        if (!isnan(timeStamp)) {
            self.bookParam.confParam.startTimeStamp = timeStamp;
            self.bookParam.cycleConfParam.startTimeStamp = timeStamp;
        } else {
            self.bookParam.confParam.startTimeStamp = 0;
            self.bookParam.cycleConfParam.startTimeStamp = 0;
        }
        
    } else if (index == HWMBookCycleConfCellTypeEndTime) {
        // 结束时间
        NSTimeInterval timeStamp = [NSString getTimeStampWithDateString:content];
        if (!isnan(timeStamp)) {
            self.bookParam.cycleConfParam.endTimeStamp = timeStamp;
        } else {
            self.bookParam.cycleConfParam.endTimeStamp = 0;
        }
    } else if (index == HWMBookCycleConfCellTypeDuration) {
        // 会议时长
        self.bookParam.confParam.duration = content.integerValue;
    } else if (index == HWMBookCycleConfCellTypeCycleDay) {
        // 会议周期
        self.bookParam.cycleConfParam.interval = content.integerValue;
    } else if (index == HWMBookCycleConfCellTypeCycleTime) {
        // 会议时间
        self.bookParam.cycleConfParam.listPoints = content;
    } else if (index == HWMBookCycleConfCellTypePreRemindDays) {
        // 提前通知
        self.bookParam.cycleConfParam.preRemindDays = content.integerValue;
    } else if (index == HWMBookCycleConfCellTypePassword) {
        // 来宾密码
        self.bookParam.confParam.guestPwd = content;
    } else if (index == HWMBookCycleConfCellTypeCustomInfo) {
        // 自定义信息
        self.bookParam.confParam.customInfo = content;
    } else if (index == HWMBookCycleConfCellTypeParticipants) {
        // 最大与会人数
        self.bookParam.confParam.concurrentParticipants = [content integerValue];
    } else if (index == HWMBookCycleConfCellTypeTimeZone) {
        // 时区
        self.bookParam.confParam.timeZone = [content integerValue];
    }
}

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    switch (index) {
        case HWMBookCycleConfCellTypeShareVmr: {
            // 启用共享云会议室
            if (state) {
                self.usePersonalID = NO;
                self.bookParam.confParam.vmrId = @"";
            }
            self.useShareVmr = state;
            self.bookParam.confParam.confResType = state ? HWMSDKConfRestypeShareVmr : HWMSDKConfRestypeDefault;
            [self.listView reloadData];
        }
            break;
        case HWMBookCycleConfCellTypeFixed: {
            // 使用个人会议ID（是否固定会议ID）
            self.usePersonalID = state;
            HWMSwitchCell *pwdCell = [self.listView.listView viewAtColumn:0 row:HWMBookCycleConfCellTypeNeedPassword makeIfNecessary:YES];
            HWMInputInfoTitleCell *pwdTextCell = [self.listView.listView viewAtColumn:0 row:HWMBookCycleConfCellTypePassword makeIfNecessary:YES];
            pwdCell.enabled = !self.usePersonalID;
            pwdTextCell.enabled = !self.usePersonalID && !self.bookParam.confParam.noPassword;
        }
            break;
        case HWMBookCycleConfCellTypeNeedAttendee: {
            // 是否需要携带与会者
            if (!state) {
                self.needAttendee = NO;
                [self.attenteeArr removeAllObjects];
                return;
            }
            HWMSwitchCell *cell = [self.listView.listView viewAtColumn:0 row:index makeIfNecessary:YES];
            cell.state = NO;
            HWMSelectContactViewController *contact = [[HWMSelectContactViewController alloc] init];
            @weakify(self)
            [contact setSelectAttendeeInfoHandler:^(NSArray *_Nullable attendees) {
                @strongify(self)
                for (HWMContactInfoModel *model in attendees) {
                    HWMAttendeeInfo *info = [[HWMAttendeeInfo alloc] init];
                    info.accountId = model.accountId;
                    info.name = model.name;
                    info.aliasCN = model.aliasCN;
                    info.aliasEN = model.aliasEN;
                    info.number = model.number;
                    info.thirdUserId = model.thirdUserId;
                    info.email = model.email;
                    info.mute = model.mute;
                    info.role = model.role;
                    info.sms = model.sms;
                    info.orgId = model.corpId;
                    info.isAutoInvite = self.isAutoInvite;
                    [self.attenteeArr addObject:info];
                }
                if (attendees.count > 0) {
                    self.needAttendee = YES;
                    cell.state = YES;
                } else {
                    self.needAttendee = NO;
                }
                self.bookParam.confParam.attendee = self.attenteeArr;
            }];
            [self presentViewControllerAsModalWindow:contact];
        }
            break;
        case HWMBookCycleConfCellTypeAttendeesExcludeSelf:
            // 与会者列表是否排除自己
            self.bookParam.confParam.attendeesExcludeSelf = state;
            break;
        case HWMBookCycleConfCellTypeAutoInvite: {
            // 会议开始自动呼叫与会者
            self.isAutoInvite = state;
            for (HWMAttendeeInfo *info in self.attenteeArr) {
                info.isAutoInvite = self.isAutoInvite;
            }
        }
            break;
        case HWMBookCycleConfCellTypeAllowRecord:
            // 允许录制
            self.bookParam.confParam.isRecordOn = state;
            break;
        case HWMBookCycleConfCellTypeAutoRecord:
            // 自动录制
            self.bookParam.confParam.isAutoRecord = state;
            break;
        case HWMBookCycleConfCellTypeMail:
            // 邮件通知
            self.bookParam.confParam.isMailOn = state;
            break;
        case HWMBookCycleConfCellTypeSms:
            // 短信通知
            self.bookParam.confParam.isSmsOn = state;
            break;
        case HWMBookCycleConfCellTypeEmailCalender:
            // 日历邮件通知
            self.bookParam.confParam.isEmailCalenderOn = state;
            break;
        case HWMBookCycleConfCellTypeNeedPassword: {
            // 是否设置来宾密码
            self.bookParam.confParam.noPassword = !state;
            HWMInputInfoTitleCell *pwdCell = [self.listView.listView viewAtColumn:0 row:HWMBookCycleConfCellTypePassword makeIfNecessary:YES];
            if (pwdCell && [pwdCell isKindOfClass:[HWMInputInfoTitleCell class]]) {
                pwdCell.enabled = state && !self.usePersonalID;
            }
        }
            break;
        case HWMBookCycleConfCellTypeWaitingRoom:
            // 是否开启等候室
            self.bookParam.confParam.isOpenWaitingRoom = state;
            break;
        case HWMBookCycleConfCellTypeSupportWatermark:
            // 是否支持水印
            self.bookParam.confParam.supportWatermark = state;
            break;
        default:
            break;
    }
}
#pragma mark - Event

- (void)confirmBtnClick {
    
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }
    
    if (self.usePersonalID) {
        HWMVmrInfoModel *model = self.vmrList.firstObject;
        self.bookParam.confParam.vmrId = model.vmrId;
        self.bookParam.confParam.vmrConfIdType = HWMVmrConfIdTypeFixed;
    } else {
        self.bookParam.confParam.vmrId = @"";
    }
    
    if (self.detailModel) {
        
        [[HWMBizSdk getBizOpenApi] editCycleConf:self.bookParam callback:^(NSError * _Nullable error, id  _Nullable result) {
            if (error) {
                [HWMConsoleManager shareInstance].error = error;
            } else {
                [HWMConsoleManager shareInstance].console = @"edit conf succeeded";
                if (self.editCycleConfSuccessHandler) {
                    self.editCycleConfSuccessHandler();
                }
                [self.customNavigationController popViewControllerAnimated:YES];
            }
        }];
    } else {
        
        [[HWMBizSdk getBizOpenApi] bookCycleConf:self.bookParam callback:^(NSError * _Nullable error, id  _Nullable result) {
            if (error) {
                [HWMConsoleManager shareInstance].error = error;
            } else {
                [HWMConsoleManager shareInstance].console = @"book cycle conf succeed";
            }
        }];
    }
}

#pragma mark - Lazy

- (NSMutableArray<HWMAttendeeInfo *> *)attenteeArr {
    if (!_attenteeArr) {
        _attenteeArr = [NSMutableArray array];
    }
    return _attenteeArr;
}

@end
