//
//  HWMCancelConfViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/28.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMCancelConfViewController.h"
#import "HWMInputView.h"
#import <HWMUISDK/HWMUISDK.h>

@interface HWMCancelConfViewController ()<HWMInputViewDelegate>
/// 输入框
@property (nonatomic, strong) HWMInputView *inputView;
/// 取消按钮
@property (nonatomic, strong) NSButton *cancelBtn;
/// 会议ID
@property (nonatomic, copy) NSString *confID;

@end

@implementation HWMCancelConfViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

#pragma mark - UI
- (void)setupUI {
    [self.view addSubview:self.inputView];
    [self.view addSubview:self.cancelBtn];

    [self.inputView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view).offset(100);
        make.centerX.equalTo(self.view);
        make.height.mas_equalTo(50);
        make.width.mas_equalTo(350);
    }];

    [self.cancelBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.inputView.mas_bottom).offset(80);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

#pragma mark - Delegate
- (void)textFieldDidChanged:(NSTextField *)field {
    self.confID = field.stringValue;
}

#pragma mark - Event
- (void)cancelConf {
    if (self.confID.length == 0) {
        [HWMConsoleManager shareInstance].console = @"请输入会议ID";
        return;
    }
    [[HWMBizSdk getBizOpenApi] cancelConf:self.confID callback:^(NSError *_Nullable error, id _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        } else {
            [HWMConsoleManager shareInstance].console = @"cancel conf successful";
        }
    }];
}

#pragma mark - Lazy
- (HWMInputView *)inputView {
    if (!_inputView) {
        _inputView = [[HWMInputView alloc] init];
        _inputView.placeholder = @"会议ID";
        _inputView.delegate = self;
    }
    return _inputView;
}

- (NSButton *)cancelBtn {
    if (!_cancelBtn) {
        _cancelBtn = [NSButton buttonWithTitle:@"取消会议" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(cancelConf)];
        _cancelBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _cancelBtn.layer.cornerRadius = 4.0;
        _cancelBtn.layer.masksToBounds = YES;
    }
    return _cancelBtn;
}

@end
