//
//  HWMJoinConfViewController.m
//  HWMUISDKNativeDemo
//
//  Created by guomeng on 2020/10/24.
//  Copyright © 2020 Huawei Technologies Co. Ltd. All rights reserved.
//

#import "HWMJoinConfViewController.h"
#import "HWMInputViewCell.h"
#import "HWMSwitchCell.h"
#import <HWMUISDK/HWMUISDK.h>
#import "HWMSDKTableView.h"

@interface HWMJoinConfViewController ()<HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate, HWMSwitchCellDelegate>
/// tableView
@property (nonatomic, strong) HWMSDKTableView *listView;
/// scrollView
@property (nonatomic, strong) NSScrollView *scrollView;
/// 按钮
@property (nonatomic, strong) NSButton *createBtn;
/// 标题
@property (nonatomic, copy) NSArray *titlesArr;
/// 会议ID
@property (nonatomic, copy) NSString *confId;
/// 会议密码
@property (nonatomic, copy) NSString *password;
/// 昵称
@property (nonatomic, copy) NSString *nickName;
/// 中文昵称
@property (nonatomic, copy) NSString *aliasCN;
/// 英文昵称
@property (nonatomic, copy) NSString *aliasEN;
/// random
@property (nonatomic, copy) NSString *random;
/// random入会时需要
@property (nonatomic, copy) NSString *serverUrl;
/// 是否打开麦克风
@property (nonatomic, assign) BOOL isOnMic;
/// 是否打开摄像头
@property (nonatomic, assign) BOOL isOnCamera;
/// 是否打开扬声器
@property (nonatomic, assign) BOOL isOnSpker;
/// 是否为random入会
@property (nonatomic, assign) BOOL isRandom;
/// 是否结束冲突的vmr会议
@property (nonatomic, assign) BOOL isStopConflictConf;
/// 三方自定义字段
@property (nonatomic, copy) NSString *extendedField;
/// 企业互信应用ID
@property (nonatomic, copy) NSString *corpTrustAppId;
/// 是否隐藏密码弹窗，默认为NO
@property (nonatomic, assign) BOOL isHidePasswordAlert;

@end

@implementation HWMJoinConfViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.isRandom = NO;
    [self setupData];
    [self setupUI];
}

#pragma mark - Data
- (void)setupData {
    if (self.isRandom) {
        self.titlesArr = @[@"会议ID", @"random", @"用户昵称", @"中文昵称", @"英文昵称", @"打开摄像头", @"打开麦克风", @"打开扬声器", @"domain", @"自定义字段"];
    } else {
        self.titlesArr = @[@"会议ID", @"会议密码", @"用户昵称", @"中文昵称", @"英文昵称", @"打开摄像头", @"打开麦克风", @"打开扬声器", @"强制结束当前冲突的vmr会议", @"自定义字段", @"企业互信应用ID", @"关闭密码弹窗"];
    }

    self.isOnMic = YES;
    self.isOnCamera = NO;
    self.isOnSpker = YES;
    self.isStopConflictConf = NO;
    self.isHidePasswordAlert = NO;
}

#pragma mark - UI
- (void)setupUI {
    NSSegmentedControl *seg = [[NSSegmentedControl alloc] init];
    seg.segmentCount = 2;
    seg.selectedSegment = 0;
    seg.segmentStyle = NSSegmentStyleAutomatic;
    if (@available(macOS 10.13, *)) {
        seg.segmentDistribution = NSSegmentDistributionFillProportionally;
    } else {
        // Fallback on earlier versions
    }
    seg.target = self;
    seg.action = @selector(segmentItemClick:);
    [seg setLabel:@"密码入会" forSegment:0];
    [seg setLabel:@"random入会" forSegment:1];
    [seg setWidth:100 forSegment:0];
    [seg setWidth:100 forSegment:1];
    [self.view addSubview:seg];
    [seg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.top.equalTo(self.view).offset(20);
        make.width.mas_equalTo(210);
        make.height.mas_equalTo(50);
    }];
    
    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"joinConf"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.leading.equalTo(self.view).offset(15);
        make.top.equalTo(self.view).offset(100);
        make.trailing.equalTo(self.view).offset(-15);
        make.bottom.equalTo(self.view).offset(-100);
    }];

    [self.view addSubview:self.createBtn];
    [self.createBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.equalTo(self.view).offset(-20);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];
}

- (NSString *)contentForRow:(NSInteger)index {
    if (index == 0) {
        return self.confId;
    } else if (index == 1) {
        if (self.isRandom) {
            return self.random;
        } else {
            return self.password;
        }
    } else if (index == 2) {
        return self.nickName;
    } else if (index == 3) {
        return self.aliasCN;
    } else if (index == 4) {
        return self.aliasEN;
    } else if (index == 9) {
        return self.extendedField;
    } else if (index == 10) {
        return self.corpTrustAppId;
    }
    return @"";
}
#pragma mark - Delegate

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.titlesArr.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    if (row < 5 || row == 9 || row == 10 || row == 12) {
        HWMInputViewCell *cell = [HWMInputViewCell initInputViewCell:tableView ower:self];
        cell.placeholder = self.titlesArr[row];
        cell.index = row;
        cell.content = [self contentForRow:row];
        @weakify(self)
        [cell setInputViewDidEndEditerHandler:^(NSString *_Nonnull content, NSInteger index) {
            @strongify(self)
            if (index == 0) {
                self.confId = content;
            } else if (index == 1) {
                if (self.isRandom) {
                    self.random = content;
                } else {
                    self.password = content;
                }
            } else if (index == 2) {
                self.nickName = content;
            } else if (index == 3) {
                self.aliasCN = content;
            } else if (index == 4) {
                self.aliasEN = content;
            } else if (index == 9) {
                self.extendedField = content;
            } else if (index == 10) {
                self.corpTrustAppId = content;
            }
        }];
        return cell;
    }
    HWMSwitchCell *cell = [HWMSwitchCell initSwitchCell:tableView ower:self];
    cell.index = row;
    cell.delegate = self;
    if (row == 5) {
        cell.state = self.isOnCamera;
    } else if(row == 6) {
        cell.state = self.isOnMic;
    } else if(row == 7) {
        cell.state = self.isOnSpker;
    } else if (row == 8) {
        if (self.isRandom) {
            HWMInputViewCell *cell = [HWMInputViewCell initInputViewCell:tableView ower:self];
            cell.placeholder = self.titlesArr[row];
            cell.index = row;
            cell.content = @"";
            @weakify(self)
            [cell setInputViewDidEndEditerHandler:^(NSString *_Nonnull content, NSInteger index) {
                @strongify(self)
                self.serverUrl = content;
            }];
            return cell;
        } else {
            cell.state = self.isStopConflictConf;
        }
    } else if (row == 11) {
        cell.state = self.isHidePasswordAlert;
    }
    cell.title = self.titlesArr[row];

    return cell;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 40.0;
}

- (void)switchStateChanged:(BOOL)state index:(NSInteger)index {
    if (index == 5) {
        self.isOnCamera = state;
    } else if (index == 6) {
        self.isOnMic = state;
    } else if (index == 7){
        self.isOnSpker = state;
    } else if (index == 8) {
        self.isStopConflictConf = state;
    } else if (index == 11) {
        self.isHidePasswordAlert = state;
    }
}

#pragma mark - Event

- (void)segmentItemClick:(NSSegmentedControl *)sender {
    self.isRandom = sender.selectedSegment;
    [self setupData];
    [self.listView reloadData];
    
    /// 清除数据
    self.confId = @"";
    self.nickName = @"";
    self.aliasCN = @"";
    self.aliasEN = @"";
    self.password = @"";
    self.random = @"";
    self.serverUrl = @"";
    self.extendedField = @"";
    self.corpTrustAppId = @"";
}

- (void)joinConf {
    if (self.isRandom) {
        [self joinConfByRandom];
    } else {
        [self joinConfById];
    }
}

/// 会议Id入会
- (void)joinConfById {
    HWMJoinConfParam *joinParam = [[HWMJoinConfParam alloc] init];
    joinParam.confId = self.confId;
    joinParam.password = self.password;
    joinParam.nickname = self.nickName;
    joinParam.aliasCN = self.aliasCN;
    joinParam.aliasEN = self.aliasEN;
    joinParam.isMicOn = self.isOnMic;
    joinParam.isCameraOn = self.isOnCamera;
    joinParam.isSpkOn = self.isOnSpker;
    joinParam.isStopConflictConf = self.isStopConflictConf;
    joinParam.corpTrustAppId = self.corpTrustAppId;
    joinParam.extendedField = self.extendedField;
    joinParam.isHidePasswordAlert = self.isHidePasswordAlert;
    [[HWMSdk getOpenApi] joinConfByPassword:joinParam callback:^(NSError *_Nullable error, id _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        }
    }];
}

/// random入会
- (void)joinConfByRandom {
    HWMRandomConfParam *param = [[HWMRandomConfParam alloc] init];
    param.confId = self.confId;
    param.random = self.random;
    param.nickname = self.nickName;
    param.aliasCN = self.aliasCN;
    param.aliasEN = self.aliasEN;
    param.isCameraOn = self.isOnCamera;
    param.isMicOn = self.isOnMic;
    param.isSpkOn = self.isOnSpker;
    param.domain = self.serverUrl;
    param.extendedField = self.extendedField;
    
    [[HWMSdk getOpenApi] joinConfByRandom:param callback:^(NSError *_Nullable error, id _Nullable result) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
        } else {
            [HWMConsoleManager shareInstance].console = @"join conf successful";
        }
    }];
}

#pragma mark - Lazy

- (NSButton *)createBtn {
    if (!_createBtn) {
        _createBtn = [NSButton buttonWithTitle:@"加入会议" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(joinConf)];
        _createBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
        _createBtn.layer.cornerRadius = 4.0;
        _createBtn.layer.masksToBounds = YES;
    }
    return _createBtn;
}

@end
