//
//  HWMStartProjectionController.m
//  HWMUISDKNativeDemo
//
//  Created by linweiqiang on 2024/6/27.
//  Copyright © 2024 Huawei Technologies Co. Ltd. All rights reserved.
//

#import <HWMUISDK/HWMUISDK.h>
#import "HWMInputInfoTitleCell.h"
#import "HWMSDKTableView.h"
#import "HWMStartProjectionController.h"

typedef NS_ENUM(NSInteger, HWMStartProjectionCellType) {
    HWMStartProjectionCellTypePairCode = 0,
    HWMStartProjectionCellTypeRandomNumber,
    HWMStartProjectionCellTypeVerifyCode
};

@interface HWMStartProjectionController () <HWMSDKTableViewDataSourse, HWMSDKTableViewDelegate, HWMInputInfoTitleCellDelegate>

@property (nonatomic, strong) HWMSDKTableView *listView;
@property (nonatomic, strong) NSButton *startProjectionBtn;
@property (nonatomic, strong) HWMUISDKStartProjectionParamModel *startProjectionParam;

@end

@implementation HWMStartProjectionController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

- (void)setupUI {
    self.startProjectionBtn = [NSButton buttonWithTitle:@"发起投屏" font:nil fontColor:[NSColor whiteColor] target:self action:@selector(click)];
    self.startProjectionBtn.layer.backgroundColor = [NSColor colorWithRGB:0x0D94FF].CGColor;
    self.startProjectionBtn.layer.cornerRadius = 4.0;
    self.startProjectionBtn.layer.masksToBounds = YES;
    [self.view addSubview:self.startProjectionBtn];
    [self.startProjectionBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.bottom.mas_equalTo(-100);
        make.height.mas_equalTo(35);
        make.width.mas_equalTo(250);
    }];

    self.listView = [[HWMSDKTableView alloc] initTableViewClomuIdentifier:@"startProjection"];
    self.listView.delegate = self;
    self.listView.dataSource = self;
    [self.view addSubview:self.listView];
    [self.listView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(65);
        make.leading.mas_equalTo(15);
        make.trailing.mas_equalTo(-15);
        make.bottom.mas_equalTo(self.startProjectionBtn.mas_top).offset(-20);
    }];
}

#pragma mark - HWMSDKTableView

- (NSInteger)numberOfRowsInTableView:(NSTableView *)tableView {
    return self.titleDic.count;
}

- (NSView *)tableView:(NSTableView *)tableView viewForTableColumn:(NSTableColumn *)tableColumn row:(NSInteger)row {
    HWMInputInfoTitleCell *cell = [HWMInputInfoTitleCell inputInfoTitleCell:tableView ower:self];

    cell.delegate = self;
    cell.index = row;
    cell.title = self.titleDic[@(row)];

    if (row == HWMStartProjectionCellTypePairCode) {
        cell.content = self.startProjectionParam.pairCode;
    } else if (row == HWMStartProjectionCellTypeRandomNumber) {
        cell.content = self.startProjectionParam.randomNumber;
    } else if (row == HWMStartProjectionCellTypeVerifyCode) {
        cell.content = self.startProjectionParam.verifyCode;
    }

    return cell;
}

- (CGFloat)tableView:(NSTableView *)tableView heightOfRow:(NSInteger)row {
    return 50.0;
}

#pragma mark - HWMInputInfoTitleCellDelegate

- (void)inputInfoCellDidEdite:(NSString *)content index:(NSInteger)index {
    if (index == HWMStartProjectionCellTypePairCode) {
        self.startProjectionParam.pairCode = content;
    } else if (index == HWMStartProjectionCellTypeRandomNumber) {
        self.startProjectionParam.randomNumber = content;
    } else if (index == HWMStartProjectionCellTypeVerifyCode) {
        self.startProjectionParam.verifyCode = content;
    }
}

- (HWMUISDKStartProjectionParamModel *)startProjectionParam {
    if (!_startProjectionParam) {
        _startProjectionParam = [[HWMUISDKStartProjectionParamModel alloc] init];
    }

    return _startProjectionParam;
}

- (NSDictionary<NSNumber *, NSString *> *)titleDic {
    return @{
        @(HWMStartProjectionCellTypePairCode): @"pairCode",
        @(HWMStartProjectionCellTypeRandomNumber): @"randomNumber",
        @(HWMStartProjectionCellTypeVerifyCode): @"verifyCode"
    };
}

- (void)click {
    if (![HWMSdk hasInit]) {
        [HWMConsoleManager shareInstance].console = @"no init";
        return;
    }

    [[HWMSdk getOpenApi] startProjectionWithParam:self.startProjectionParam
                                         callback:^(NSError *_Nullable error, HWMUISDKStartProjectionResultModel *_Nullable startProjectionResult) {
        if (error) {
            [HWMConsoleManager shareInstance].error = error;
            [HWMConsoleManager shareInstance].console = [NSString stringWithFormat:@"start projection failed, %@", [startProjectionResult yy_modelDescription]];

            if (startProjectionResult.randomNumber.length > 0) {
                self.startProjectionParam.randomNumber = startProjectionResult.randomNumber;
                [self.listView reloadData];
            }
        } else {
            [HWMConsoleManager shareInstance].console = @"start projection success";
            self.startProjectionParam.pairCode = @"";
            self.startProjectionParam.randomNumber = @"";
            self.startProjectionParam.verifyCode = @"";
            [self.listView reloadData];
        }
    }];
}

@end
